/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.foundation.gestures.BringIntoViewSpec;
import androidx.compose.foundation.pager.PagerState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Landroidx/compose/foundation/pager/PagerBringIntoViewSpec;", "Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "pagerState", "Landroidx/compose/foundation/pager/PagerState;", "defaultBringIntoViewSpec", "(Landroidx/compose/foundation/pager/PagerState;Landroidx/compose/foundation/gestures/BringIntoViewSpec;)V", "getDefaultBringIntoViewSpec", "()Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "getPagerState", "()Landroidx/compose/foundation/pager/PagerState;", "scrollAnimationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "", "getScrollAnimationSpec", "()Landroidx/compose/animation/core/AnimationSpec;", "calculateScrollDistance", "offset", "size", "containerSize", "overrideProposedOffsetMove", "proposedOffsetMove", "foundation"})
final class PagerBringIntoViewSpec
implements BringIntoViewSpec {
    private final PagerState pagerState;
    private final BringIntoViewSpec defaultBringIntoViewSpec;
    private final AnimationSpec<Float> scrollAnimationSpec;

    /*
     * WARNING - void declaration
     */
    public PagerBringIntoViewSpec(PagerState pagerState, BringIntoViewSpec defaultBringIntoViewSpec) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"pagerState");
        Intrinsics.checkNotNullParameter((Object)defaultBringIntoViewSpec, (String)"defaultBringIntoViewSpec");
        this.pagerState = var1_1;
        this.defaultBringIntoViewSpec = var2_2;
        this.scrollAnimationSpec = this.defaultBringIntoViewSpec.getScrollAnimationSpec();
    }

    public final PagerState getPagerState() {
        return this.pagerState;
    }

    public final BringIntoViewSpec getDefaultBringIntoViewSpec() {
        return this.defaultBringIntoViewSpec;
    }

    @Override
    public final AnimationSpec<Float> getScrollAnimationSpec() {
        return this.scrollAnimationSpec;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final float calculateScrollDistance(float offset, float size, float containerSize) {
        float f;
        float f2;
        void var2_2;
        float proposedOffsetMove = this.defaultBringIntoViewSpec.calculateScrollDistance(offset, (float)var2_2, containerSize);
        if (!(proposedOffsetMove == 0.0f)) {
            f2 = this.overrideProposedOffsetMove(proposedOffsetMove);
        } else if (this.pagerState.getFirstVisiblePageOffset$foundation() == 0) {
            f2 = 0.0f;
        } else {
            void var3_3;
            float reversedFirstPageScroll = -((float)this.pagerState.getFirstVisiblePageOffset$foundation());
            f2 = RangesKt.coerceIn((float)(this.pagerState.getLastScrolledForward() ? reversedFirstPageScroll + (float)this.pagerState.getPageSizeWithSpacing$foundation() : f), (float)(-containerSize), (float)var3_3);
        }
        f = f2;
        return f2;
    }

    /*
     * WARNING - void declaration
     */
    private final float overrideProposedOffsetMove(float proposedOffsetMove) {
        void var2_2;
        float correctedOffset;
        for (correctedOffset = -((float)this.pagerState.getFirstVisiblePageOffset$foundation()); proposedOffsetMove > 0.0f && correctedOffset < proposedOffsetMove; correctedOffset += (float)this.pagerState.getPageSizeWithSpacing$foundation()) {
        }
        while (proposedOffsetMove < 0.0f && correctedOffset > proposedOffsetMove) {
            correctedOffset -= (float)this.pagerState.getPageSizeWithSpacing$foundation();
        }
        return (float)var2_2;
    }
}

