/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.staggeredgrid;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0004H\u0002J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u000fJ\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u0006\u0010\u001e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo;", "", "()V", "anchor", "", "lanes", "", "spannedItems", "Lkotlin/collections/ArrayDeque;", "Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$SpannedItem;", "assignedToLane", "", "itemIndex", "targetLane", "ensureCapacity", "", "capacity", "newOffset", "ensureValidIndex", "requestedIndex", "findNextItemIndex", "findPreviousItemIndex", "getGaps", "getLane", "lowerBound", "reset", "setGaps", "gaps", "setLane", "lane", "upperBound", "Companion", "SpannedItem", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLazyStaggeredGridLaneInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyStaggeredGridLaneInfo.kt\nandroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Collections.kt\nkotlin/collections/CollectionsKt__CollectionsKt\n*L\n1#1,208:1\n1#2:209\n399#3,7:210\n399#3,7:217\n*S KotlinDebug\n*F\n+ 1 LazyStaggeredGridLaneInfo.kt\nandroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo\n*L\n167#1:210,7\n187#1:217,7\n*E\n"})
public final class LazyStaggeredGridLaneInfo {
    public static final Companion Companion = new Companion(null);
    private int anchor;
    private int[] lanes = new int[16];
    private final ArrayDeque<SpannedItem> spannedItems = new ArrayDeque();
    public static final int $stable = 8;
    private static final int MaxCapacity = 131072;
    public static final int Unset = -1;
    public static final int FullSpan = -2;

    /*
     * WARNING - void declaration
     */
    public final void setLane(int itemIndex22, int lane) {
        void var2_3;
        int itemIndex22;
        if (!(itemIndex22 >= 0)) {
            String itemIndex22 = "Negative lanes are not supported";
            throw new IllegalArgumentException(itemIndex22.toString());
        }
        this.ensureValidIndex(itemIndex22);
        this.lanes[var1_1 - this.anchor] = var2_3 + true;
    }

    /*
     * WARNING - void declaration
     */
    public final int getLane(int itemIndex) {
        void var1_1;
        if (itemIndex < this.lowerBound() || itemIndex >= this.upperBound()) {
            return -1;
        }
        return this.lanes[var1_1 - this.anchor] - 1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean assignedToLane(int itemIndex, int targetLane) {
        void var1_1;
        void var2_2;
        int lane = this.getLane(itemIndex);
        return lane == var2_2 || lane == -1 || var1_1 == -2;
    }

    public final int upperBound() {
        return this.anchor + this.lanes.length;
    }

    public final int lowerBound() {
        return this.anchor;
    }

    public final void reset() {
        ArraysKt.fill$default((int[])this.lanes, (int)0, (int)0, (int)0, (int)6, null);
        this.spannedItems.clear();
    }

    public final int findPreviousItemIndex(int itemIndex, int targetLane) {
        for (int i = itemIndex - 1; i >= 0; --i) {
            if (!this.assignedToLane(i, targetLane)) continue;
            return i;
        }
        return -1;
    }

    public final int findNextItemIndex(int itemIndex, int targetLane) {
        int n = this.upperBound();
        for (int i = itemIndex + 1; i < n; ++i) {
            if (!this.assignedToLane(i, targetLane)) continue;
            return i;
        }
        return this.upperBound();
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureValidIndex(int requestedIndex) {
        int requestedCapacity = requestedIndex - this.anchor;
        boolean bl = requestedCapacity >= 0 ? requestedCapacity < 131072 : false;
        if (bl) {
            LazyStaggeredGridLaneInfo.ensureCapacity$default(this, requestedCapacity + 1, 0, 2, null);
        } else {
            void var2_2;
            int oldAnchor = this.anchor;
            this.anchor = Math.max(requestedIndex - this.lanes.length / 2, 0);
            int delta = this.anchor - var2_2;
            if (delta >= 0) {
                if (delta < this.lanes.length) {
                    ArraysKt.copyInto((int[])this.lanes, (int[])this.lanes, (int)0, (int)delta, (int)this.lanes.length);
                }
                ArraysKt.fill((int[])this.lanes, (int)0, (int)Math.max(0, this.lanes.length - delta), (int)this.lanes.length);
            } else if (this.lanes.length + (delta = -delta) < 131072) {
                LazyStaggeredGridLaneInfo lazyStaggeredGridLaneInfo = this;
                lazyStaggeredGridLaneInfo.ensureCapacity(lazyStaggeredGridLaneInfo.lanes.length + delta + 1, delta);
            } else {
                void var1_1;
                if (delta < this.lanes.length) {
                    ArraysKt.copyInto((int[])this.lanes, (int[])this.lanes, (int)delta, (int)0, (int)(this.lanes.length - delta));
                }
                ArraysKt.fill((int[])this.lanes, (int)0, (int)0, (int)Math.min(this.lanes.length, (int)var1_1));
            }
        }
        while (!((Collection)this.spannedItems).isEmpty() && ((SpannedItem)this.spannedItems.first()).getIndex() < this.lowerBound()) {
            this.spannedItems.removeFirst();
        }
        while (!((Collection)this.spannedItems).isEmpty() && ((SpannedItem)this.spannedItems.last()).getIndex() > this.upperBound()) {
            this.spannedItems.removeLast();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setGaps(int itemIndex, int[] gaps) {
        void var2_2;
        void var3_4;
        void $this$binarySearchBy_u24default$iv;
        List list = (List)this.spannedItems;
        Comparable key$iv = Integer.valueOf(itemIndex);
        int toIndex$iv = $this$binarySearchBy_u24default$iv.size();
        int foundIndex = CollectionsKt.binarySearch((List)$this$binarySearchBy_u24default$iv, (int)0, (int)toIndex$iv, (Function1)((Function1)new Function1<SpannedItem, Integer>(key$iv){
            final /* synthetic */ Comparable $key;
            {
                void var1_1;
                this.$key = var1_1;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object it) {
                SpannedItem spannedItem = (SpannedItem)it;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(spannedItem.getIndex()), (Comparable)this.$key);
            }
        }));
        if (foundIndex < 0) {
            void var1_1;
            if (gaps == null) {
                return;
            }
            int insertionIndex = -(foundIndex + 1);
            this.spannedItems.add((int)var3_4, (Object)new SpannedItem((int)var1_1, gaps));
            return;
        }
        if (gaps == null) {
            this.spannedItems.remove((int)var3_4);
            return;
        }
        ((SpannedItem)this.spannedItems.get((int)var3_4)).setGaps((int[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int[] getGaps(int itemIndex) {
        void var1_3;
        void var3_5;
        void $this$binarySearchBy_u24default$iv;
        List list = (List)this.spannedItems;
        Comparable key$iv = Integer.valueOf(itemIndex);
        int toIndex$iv = $this$binarySearchBy_u24default$iv.size();
        int foundIndex = CollectionsKt.binarySearch((List)list, (int)0, (int)var3_5, (Function1)((Function1)new Function1<SpannedItem, Integer>(key$iv){
            final /* synthetic */ Comparable $key;
            {
                void var1_1;
                this.$key = var1_1;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object it) {
                SpannedItem spannedItem = (SpannedItem)it;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(spannedItem.getIndex()), (Comparable)this.$key);
            }
        }));
        SpannedItem spannedItem = (SpannedItem)CollectionsKt.getOrNull((List)((List)this.spannedItems), (int)var1_3);
        if (spannedItem != null) {
            return spannedItem.getGaps();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureCapacity(int capacity22, int newOffset) {
        int capacity22;
        if (!(capacity22 <= 131072)) {
            String capacity22 = "Requested item capacity " + capacity22 + " is larger than max supported: 131072!";
            throw new IllegalArgumentException(capacity22.toString());
        }
        if (this.lanes.length < capacity22) {
            void var2_3;
            void var3_4;
            for (int newSize = this.lanes.length; newSize < capacity22; newSize <<= 1) {
            }
            this.lanes = ArraysKt.copyInto$default((int[])this.lanes, (int[])new int[var3_4], (int)var2_3, (int)0, (int)0, (int)12, null);
        }
    }

    static /* synthetic */ void ensureCapacity$default(LazyStaggeredGridLaneInfo lazyStaggeredGridLaneInfo, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        lazyStaggeredGridLaneInfo.ensureCapacity(n, n2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$Companion;", "", "()V", "FullSpan", "", "MaxCapacity", "Unset", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$SpannedItem;", "", "index", "", "gaps", "", "(I[I)V", "getGaps", "()[I", "setGaps", "([I)V", "getIndex", "()I", "foundation"})
    private static final class SpannedItem {
        private final int index;
        private int[] gaps;

        /*
         * WARNING - void declaration
         */
        public SpannedItem(int index2, int[] gaps) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)gaps, (String)"gaps");
            this.index = var1_1;
            this.gaps = var2_2;
        }

        public final int getIndex() {
            return this.index;
        }

        public final int[] getGaps() {
            return this.gaps;
        }

        /*
         * WARNING - void declaration
         */
        public final void setGaps(int[] nArray) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.gaps = var1_1;
        }
    }
}

