/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.lazy.grid.LazyGridDslKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\bg\u0018\u00002\u00020\u0001:\u0003\b\t\nJ\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Landroidx/compose/foundation/lazy/grid/GridCells;", "", "calculateCrossAxisCellSizes", "", "", "Landroidx/compose/ui/unit/Density;", "availableSize", "spacing", "Adaptive", "Fixed", "FixedSize", "foundation"})
@Stable
public interface GridCells {
    public List<Integer> calculateCrossAxisCellSizes(Density var1, int var2, int var3);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u0016\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0011"}, d2={"Landroidx/compose/foundation/lazy/grid/GridCells$Adaptive;", "Landroidx/compose/foundation/lazy/grid/GridCells;", "minSize", "Landroidx/compose/ui/unit/Dp;", "(FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "F", "equals", "", "other", "", "hashCode", "", "calculateCrossAxisCellSizes", "", "Landroidx/compose/ui/unit/Density;", "availableSize", "spacing", "foundation"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nLazyGridDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridDsl.kt\nandroidx/compose/foundation/lazy/grid/GridCells$Adaptive\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,569:1\n149#2:570\n1#3:571\n*S KotlinDebug\n*F\n+ 1 LazyGridDsl.kt\nandroidx/compose/foundation/lazy/grid/GridCells$Adaptive\n*L\n304#1:570\n*E\n"})
    public static final class Adaptive
    implements GridCells {
        private final float minSize;
        public static final int $stable;

        /*
         * WARNING - void declaration
         */
        private Adaptive(float minSize) {
            void var1_1;
            this.minSize = var1_1;
            if (!(Dp.compareTo-0680j_4((float)this.minSize, (float)Dp.constructor-impl((float)0.0f)) > 0)) {
                String string = "Provided min size " + Dp.toString-impl((float)this.minSize) + " should be larger than zero.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final List<Integer> calculateCrossAxisCellSizes(Density $this$calculateCrossAxisCellSizes, int availableSize, int spacing) {
            void var3_4;
            void var1_2;
            void var2_3;
            Intrinsics.checkNotNullParameter((Object)$this$calculateCrossAxisCellSizes, (String)"<this>");
            int count = Math.max((availableSize + spacing) / ($this$calculateCrossAxisCellSizes.roundToPx-0680j_4(this.minSize) + spacing), 1);
            return LazyGridDslKt.access$calculateCellsCrossAxisSizeImpl((int)var2_3, (int)var1_2, (int)var3_4);
        }

        public final int hashCode() {
            return Dp.hashCode-impl((float)this.minSize);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return other instanceof Adaptive && Dp.equals-impl0((float)this.minSize, (float)((Adaptive)var1_1).minSize);
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ Adaptive(float minSize, DefaultConstructorMarker $constructor_marker) {
            this((float)var1_1);
            void var1_1;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0096\u0002J\b\u0010\t\u001a\u00020\u0003H\u0016J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/compose/foundation/lazy/grid/GridCells$Fixed;", "Landroidx/compose/foundation/lazy/grid/GridCells;", "count", "", "(I)V", "equals", "", "other", "", "hashCode", "calculateCrossAxisCellSizes", "", "Landroidx/compose/ui/unit/Density;", "availableSize", "spacing", "foundation"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nLazyGridDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridDsl.kt\nandroidx/compose/foundation/lazy/grid/GridCells$Fixed\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,569:1\n1#2:570\n*E\n"})
    public static final class Fixed
    implements GridCells {
        private final int count;
        public static final int $stable;

        /*
         * WARNING - void declaration
         */
        public Fixed(int count) {
            void var1_1;
            this.count = var1_1;
            if (!(this.count > 0)) {
                String string = "Provided count " + this.count + " should be larger than zero";
                throw new IllegalArgumentException(string.toString());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final List<Integer> calculateCrossAxisCellSizes(Density $this$calculateCrossAxisCellSizes, int availableSize, int spacing) {
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)$this$calculateCrossAxisCellSizes, (String)"<this>");
            return LazyGridDslKt.access$calculateCellsCrossAxisSizeImpl((int)var2_2, this.count, (int)var3_3);
        }

        public final int hashCode() {
            return -this.count;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return other instanceof Fixed && this.count == ((Fixed)var1_1).count;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u0016\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0011"}, d2={"Landroidx/compose/foundation/lazy/grid/GridCells$FixedSize;", "Landroidx/compose/foundation/lazy/grid/GridCells;", "size", "Landroidx/compose/ui/unit/Dp;", "(FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "F", "equals", "", "other", "", "hashCode", "", "calculateCrossAxisCellSizes", "", "Landroidx/compose/ui/unit/Density;", "availableSize", "spacing", "foundation"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nLazyGridDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridDsl.kt\nandroidx/compose/foundation/lazy/grid/GridCells$FixedSize\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,569:1\n149#2:570\n1#3:571\n*S KotlinDebug\n*F\n+ 1 LazyGridDsl.kt\nandroidx/compose/foundation/lazy/grid/GridCells$FixedSize\n*L\n337#1:570\n*E\n"})
    public static final class FixedSize
    implements GridCells {
        private final float size;
        public static final int $stable;

        /*
         * WARNING - void declaration
         */
        private FixedSize(float size) {
            void var1_1;
            this.size = var1_1;
            if (!(Dp.compareTo-0680j_4((float)this.size, (float)Dp.constructor-impl((float)0.0f)) > 0)) {
                String string = "Provided size " + Dp.toString-impl((float)this.size) + " should be larger than zero.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final List<Integer> calculateCrossAxisCellSizes(Density $this$calculateCrossAxisCellSizes, int availableSize, int spacing) {
            Intrinsics.checkNotNullParameter((Object)$this$calculateCrossAxisCellSizes, (String)"<this>");
            int cellSize = $this$calculateCrossAxisCellSizes.roundToPx-0680j_4(this.size);
            if (cellSize + spacing < availableSize + spacing) {
                void var3_4;
                int cellCount = (availableSize + spacing) / (cellSize + var3_4);
                ArrayList<Integer> arrayList = new ArrayList<Integer>(cellCount);
                for (int i = 0; i < cellCount; ++i) {
                    ArrayList<Integer> arrayList2 = arrayList;
                    arrayList2.add(cellSize);
                }
                return arrayList;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
            for (int i = 0; i <= 0; ++i) {
                void var2_3;
                ArrayList<Integer> arrayList3 = arrayList;
                arrayList3.add((int)var2_3);
            }
            return arrayList;
        }

        public final int hashCode() {
            return Dp.hashCode-impl((float)this.size);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return other instanceof FixedSize && Dp.equals-impl0((float)this.size, (float)((FixedSize)var1_1).size);
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ FixedSize(float size, DefaultConstructorMarker $constructor_marker) {
            this((float)var1_1);
            void var1_1;
        }
    }
}

