/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.LazyGridSnapLayoutInfoProviderKt;
import androidx.compose.foundation.lazy.grid.LazyGridItemInfo;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfo;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchScope;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchStrategy;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.lazy.layout.NestedPrefetchScope;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.collection.MutableVector;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u001c\u0010\u000f\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy;", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchStrategy;", "nestedPrefetchItemCount", "", "(I)V", "currentLinePrefetchHandles", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "lineToPrefetch", "wasScrollingForward", "", "onNestedPrefetch", "", "Landroidx/compose/foundation/lazy/layout/NestedPrefetchScope;", "firstVisibleItemIndex", "onScroll", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchScope;", "delta", "", "layoutInfo", "Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;", "onVisibleItemsUpdated", "foundation"})
@Stable
@SourceDebugExtension(value={"SMAP\nLazyGridPrefetchStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridPrefetchStrategy.kt\nandroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,228:1\n1208#2:229\n1187#2,2:230\n460#3,11:232\n138#3:243\n460#3,11:244\n460#3,11:255\n460#3,11:266\n*S KotlinDebug\n*F\n+ 1 LazyGridPrefetchStrategy.kt\nandroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy\n*L\n139#1:229\n139#1:230,2\n173#1:232,11\n178#1:243\n188#1:244,11\n196#1:255,11\n216#1:266,11\n*E\n"})
final class DefaultLazyGridPrefetchStrategy
implements LazyGridPrefetchStrategy {
    private final int nestedPrefetchItemCount;
    private int lineToPrefetch;
    private final MutableVector<LazyLayoutPrefetchState.PrefetchHandle> currentLinePrefetchHandles;
    private boolean wasScrollingForward;

    /*
     * WARNING - void declaration
     */
    public DefaultLazyGridPrefetchStrategy(int nestedPrefetchItemCount) {
        void var1_1;
        this.nestedPrefetchItemCount = var1_1;
        this.lineToPrefetch = -1;
        this.currentLinePrefetchHandles = new MutableVector((Object[])new LazyLayoutPrefetchState.PrefetchHandle[16], 0);
    }

    public /* synthetic */ DefaultLazyGridPrefetchStrategy(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onScroll(LazyGridPrefetchScope $this$onScroll, float delta, LazyGridLayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$onScroll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        if (!((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty()) {
            int closestNextItemToPrefetch;
            int it22;
            boolean scrollingForward = delta < 0.0f;
            if (scrollingForward) {
                LazyGridItemInfo it22 = (LazyGridItemInfo)CollectionsKt.last(layoutInfo.getVisibleItemsInfo());
                it22 = layoutInfo.getOrientation() == Orientation.Vertical ? it22.getRow() : it22.getColumn();
                int lineToPrefetch = it22 + 1;
                closestNextItemToPrefetch = ((LazyGridItemInfo)CollectionsKt.last(layoutInfo.getVisibleItemsInfo())).getIndex() + 1;
            } else {
                LazyGridItemInfo it = (LazyGridItemInfo)CollectionsKt.first(layoutInfo.getVisibleItemsInfo());
                it22 = layoutInfo.getOrientation() == Orientation.Vertical ? it.getRow() : it.getColumn();
                it22 += -1;
                closestNextItemToPrefetch = ((LazyGridItemInfo)CollectionsKt.first(layoutInfo.getVisibleItemsInfo())).getIndex() - 1;
            }
            boolean bl = closestNextItemToPrefetch >= 0 ? closestNextItemToPrefetch < layoutInfo.getTotalItemsCount() : false;
            if (bl) {
                if (it22 != this.lineToPrefetch && it22 >= 0) {
                    MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv;
                    int size$iv;
                    if (this.wasScrollingForward != scrollingForward && (size$iv = (this_$iv = this.currentLinePrefetchHandles).getSize()) > 0) {
                        int i$iv = 0;
                        Object[] content$iv = this_$iv.getContent();
                        do {
                            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                            prefetchHandle.cancel();
                        } while (++i$iv < size$iv);
                    }
                    this.wasScrollingForward = scrollingForward;
                    this.lineToPrefetch = it22;
                    this.currentLinePrefetchHandles.clear();
                    MutableVector<LazyLayoutPrefetchState.PrefetchHandle> content$iv = this.currentLinePrefetchHandles;
                    List<LazyLayoutPrefetchState.PrefetchHandle> elements$iv = $this$onScroll.scheduleLinePrefetch(it22);
                    void v1 = this_$iv;
                    v1.addAll(v1.getSize(), elements$iv);
                }
                if (scrollingForward) {
                    int n;
                    LazyGridItemInfo lastItem = (LazyGridItemInfo)CollectionsKt.last(layoutInfo.getVisibleItemsInfo());
                    int itemSize = LazyGridSnapLayoutInfoProviderKt.sizeOnMainAxis(lastItem, layoutInfo.getOrientation());
                    int itemSpacing = layoutInfo.getMainAxisItemSpacing();
                    int n2 = LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(lastItem, layoutInfo.getOrientation()) + itemSize + itemSpacing - layoutInfo.getViewportEndOffset();
                    if ((float)n < -delta) {
                        MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv = this.currentLinePrefetchHandles;
                        int size$iv = this_$iv.getSize();
                        if (size$iv > 0) {
                            int i$iv = 0;
                            Object[] content$iv = this_$iv.getContent();
                            do {
                                LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                                prefetchHandle.markAsUrgent();
                            } while (++i$iv < size$iv);
                        }
                        return;
                    }
                } else {
                    MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv;
                    int size$iv;
                    void var2_3;
                    int n;
                    void var3_6;
                    LazyGridItemInfo firstItem = (LazyGridItemInfo)CollectionsKt.first(var3_6.getVisibleItemsInfo());
                    int n3 = var3_6.getViewportStartOffset() - LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(firstItem, var3_6.getOrientation());
                    if ((float)n < var2_3 && (size$iv = (this_$iv = this.currentLinePrefetchHandles).getSize()) > 0) {
                        int i$iv = 0;
                        Object[] content$iv = this_$iv.getContent();
                        do {
                            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                            prefetchHandle.markAsUrgent();
                        } while (++i$iv < size$iv);
                    }
                }
            }
        }
    }

    @Override
    public final void onVisibleItemsUpdated(LazyGridPrefetchScope $this$onVisibleItemsUpdated, LazyGridLayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$onVisibleItemsUpdated, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        if (this.lineToPrefetch != -1 && !((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty()) {
            int expectedLineToPrefetch;
            int n;
            LazyGridItemInfo it;
            if (this.wasScrollingForward) {
                it = (LazyGridItemInfo)CollectionsKt.last(layoutInfo.getVisibleItemsInfo());
                n = (layoutInfo.getOrientation() == Orientation.Vertical ? it.getRow() : it.getColumn()) + 1;
            } else {
                it = (LazyGridItemInfo)CollectionsKt.first(layoutInfo.getVisibleItemsInfo());
                n = expectedLineToPrefetch = (layoutInfo.getOrientation() == Orientation.Vertical ? it.getRow() : it.getColumn()) - 1;
            }
            if (this.lineToPrefetch != expectedLineToPrefetch) {
                this.lineToPrefetch = -1;
                MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv = this.currentLinePrefetchHandles;
                int size$iv = this_$iv.getSize();
                if (size$iv > 0) {
                    int i$iv = 0;
                    Object[] content$iv = this_$iv.getContent();
                    do {
                        LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                        prefetchHandle.cancel();
                    } while (++i$iv < size$iv);
                }
                this.currentLinePrefetchHandles.clear();
            }
        }
    }

    @Override
    public final void onNestedPrefetch(NestedPrefetchScope $this$onNestedPrefetch, int firstVisibleItemIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$onNestedPrefetch, (String)"<this>");
        int n = this.nestedPrefetchItemCount;
        int n2 = 0;
        while (n2 < n) {
            int i = n2++;
            $this$onNestedPrefetch.schedulePrefetch(firstVisibleItemIndex + i);
        }
    }

    public DefaultLazyGridPrefetchStrategy() {
        this(0, 1, null);
    }
}

