/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures.snapping;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.FinalSnappingItem;
import androidx.compose.foundation.gestures.snapping.LazyListSnapLayoutInfoProviderKt;
import androidx.compose.foundation.gestures.snapping.SnapLayoutInfoProvider;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.foundation.gestures.snapping.SnapPositionKt;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerLayoutInfo;
import androidx.compose.foundation.pager.PagerLayoutInfoKt;
import androidx.compose.foundation.pager.PagerSnapDistance;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a8\u0010\u0006\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0000\u001a\u0017\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\b\u001a\f\u0010\u0014\u001a\u00020\b*\u00020\u0003H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0003H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0016*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"SnapLayoutInfoProvider", "Landroidx/compose/foundation/gestures/snapping/SnapLayoutInfoProvider;", "pagerState", "Landroidx/compose/foundation/pager/PagerState;", "pagerSnapDistance", "Landroidx/compose/foundation/pager/PagerSnapDistance;", "calculateFinalSnappingBound", "Lkotlin/Function3;", "", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "snapPositionalThreshold", "flingVelocity", "lowerBoundOffset", "upperBoundOffset", "debugLog", "", "generateMsg", "Lkotlin/Function0;", "", "dragGestureDelta", "isLtrDragging", "", "isScrollingForward", "velocity", "foundation"})
@SourceDebugExtension(value={"SMAP\nPagerSnapLayoutInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerSnapLayoutInfoProvider.kt\nandroidx/compose/foundation/gestures/snapping/PagerSnapLayoutInfoProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,315:1\n226#1,4:316\n226#1,4:321\n226#1,4:325\n226#1,4:329\n226#1,4:333\n1#2:320\n*S KotlinDebug\n*F\n+ 1 PagerSnapLayoutInfoProvider.kt\nandroidx/compose/foundation/gestures/snapping/PagerSnapLayoutInfoProviderKt\n*L\n255#1:316,4\n278#1:321,4\n288#1:325,4\n296#1:329,4\n300#1:333,4\n*E\n"})
public final class PagerSnapLayoutInfoProviderKt {
    /*
     * WARNING - void declaration
     */
    public static final SnapLayoutInfoProvider SnapLayoutInfoProvider(PagerState pagerState, PagerSnapDistance pagerSnapDistance, Function3<? super Float, ? super Float, ? super Float, Float> calculateFinalSnappingBound) {
        void var1_1;
        void var2_2;
        PagerState pagerState2;
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"pagerState");
        Intrinsics.checkNotNullParameter((Object)pagerSnapDistance, (String)"pagerSnapDistance");
        Intrinsics.checkNotNullParameter(calculateFinalSnappingBound, (String)"calculateFinalSnappingBound");
        return new SnapLayoutInfoProvider(pagerState2, (Function3<? super Float, ? super Float, ? super Float, Float>)var2_2, (PagerSnapDistance)var1_1){
            final /* synthetic */ PagerState $pagerState;
            final /* synthetic */ Function3<Float, Float, Float, Float> $calculateFinalSnappingBound;
            final /* synthetic */ PagerSnapDistance $pagerSnapDistance;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$pagerState = var1_1;
                this.$calculateFinalSnappingBound = var2_2;
                this.$pagerSnapDistance = var3_3;
            }

            public final PagerLayoutInfo getLayoutInfo() {
                return this.$pagerState.getLayoutInfo();
            }

            /*
             * WARNING - void declaration
             */
            public final boolean isValidDistance(float $this$isValidDistance) {
                void var1_1;
                return !($this$isValidDistance == Float.POSITIVE_INFINITY) && !(var1_1 == Float.NEGATIVE_INFINITY);
            }

            /*
             * WARNING - void declaration
             */
            public final float calculateSnapOffset(float velocity) {
                Pair<Float, Float> snapPosition = this.$pagerState.getLayoutInfo().getSnapPosition();
                snapPosition = this.searchForSnappingBounds((SnapPosition)snapPosition, velocity);
                float lowerBoundOffset = ((Number)snapPosition.component1()).floatValue();
                float upperBoundOffset = ((Number)snapPosition.component2()).floatValue();
                float finalDistance2 = ((Number)this.$calculateFinalSnappingBound.invoke((Object)Float.valueOf(velocity), (Object)Float.valueOf(lowerBoundOffset), (Object)Float.valueOf(upperBoundOffset))).floatValue();
                if (!(finalDistance2 == lowerBoundOffset || finalDistance2 == upperBoundOffset || finalDistance2 == 0.0f)) {
                    void var2_4;
                    void var3_5;
                    String finalDistance2 = "Final Snapping Offset Should Be one of " + (float)var3_5 + ", " + (float)var2_4 + " or 0.0";
                    throw new IllegalStateException(finalDistance2.toString());
                }
                if (this.isValidDistance(finalDistance2)) {
                    void var1_1;
                    return (float)var1_1;
                }
                return 0.0f;
            }

            /*
             * WARNING - void declaration
             */
            public final float calculateApproachOffset(float velocity, float decayOffset) {
                float f;
                void var2_3;
                void var3_4;
                void animationOffsetPx;
                int effectivePageSizePx = this.$pagerState.getPageSize$foundation() + this.$pagerState.getPageSpacing$foundation();
                if (effectivePageSizePx == 0) {
                    return 0.0f;
                }
                int startPage = velocity < 0.0f ? this.$pagerState.getFirstVisiblePage$foundation() + 1 : this.$pagerState.getFirstVisiblePage$foundation();
                void pagesInAnimationOffset = animationOffsetPx / (float)effectivePageSizePx;
                int targetPage2 = RangesKt.coerceIn((int)(startPage + (int)pagesInAnimationOffset), (int)0, (int)this.$pagerState.getPageCount());
                targetPage2 = RangesKt.coerceIn((int)this.$pagerSnapDistance.calculateTargetPage(startPage, targetPage2, velocity, this.$pagerState.getPageSize$foundation(), this.$pagerState.getPageSpacing$foundation()), (int)0, (int)this.$pagerState.getPageCount());
                targetPage2 = (targetPage2 - startPage) * effectivePageSizePx;
                int flingApproachOffsetPx = RangesKt.coerceAtLeast((int)(Math.abs(targetPage2) - var3_4), (int)0);
                f = flingApproachOffsetPx == 0 ? (float)flingApproachOffsetPx : (float)var2_3 * Math.signum(f);
                return f;
            }

            /*
             * WARNING - void declaration
             */
            private final Pair<Float, Float> searchForSnappingBounds(SnapPosition snapPosition, float velocity) {
                void var3_3;
                void $this$fastForEach$iv;
                float lowerBoundOffset = Float.NEGATIVE_INFINITY;
                float upperBoundOffset = Float.POSITIVE_INFINITY;
                List<PageInfo> list = this.getLayoutInfo().getVisiblePagesInfo();
                PagerState pagerState = this.$pagerState;
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    float f;
                    E e = $this$fastForEach$iv.get(index$iv);
                    PageInfo page = (PageInfo)e;
                    float offset = SnapPositionKt.calculateDistanceToDesiredSnapPosition(PagerLayoutInfoKt.getMainAxisViewportSize(this.getLayoutInfo()), this.getLayoutInfo().getBeforeContentPadding(), this.getLayoutInfo().getAfterContentPadding(), this.getLayoutInfo().getPageSize(), page.getOffset(), page.getIndex(), snapPosition, pagerState.getPageCount());
                    if (f <= 0.0f && offset > lowerBoundOffset) {
                        lowerBoundOffset = offset;
                    }
                    if (!(offset >= 0.0f) || !(offset < upperBoundOffset)) continue;
                    upperBoundOffset = offset;
                }
                if (lowerBoundOffset == Float.NEGATIVE_INFINITY) {
                    lowerBoundOffset = upperBoundOffset;
                }
                if (upperBoundOffset == Float.POSITIVE_INFINITY) {
                    upperBoundOffset = lowerBoundOffset;
                }
                if (!this.$pagerState.getCanScrollForward()) {
                    upperBoundOffset = 0.0f;
                    if (PagerSnapLayoutInfoProviderKt.access$isScrollingForward(this.$pagerState, velocity)) {
                        lowerBoundOffset = 0.0f;
                    }
                }
                if (!this.$pagerState.getCanScrollBackward()) {
                    void var2_2;
                    lowerBoundOffset = 0.0f;
                    if (!PagerSnapLayoutInfoProviderKt.access$isScrollingForward(this.$pagerState, (float)var2_2)) {
                        upperBoundOffset = 0.0f;
                    }
                }
                return TuplesKt.to((Object)Float.valueOf((float)var3_3), (Object)Float.valueOf(upperBoundOffset));
            }
        };
    }

    private static final boolean isLtrDragging(PagerState $this$isLtrDragging) {
        return PagerSnapLayoutInfoProviderKt.dragGestureDelta($this$isLtrDragging) > 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isScrollingForward(PagerState $this$isScrollingForward, float velocity) {
        void var2_3;
        void var0_1;
        boolean isForward;
        void var1_2;
        boolean reverseScrollDirection = $this$isScrollingForward.getLayoutInfo().getReverseLayout();
        boolean bl = $this$isScrollingForward.isNotGestureAction$foundation() ? var1_2 < 0.0f : (isForward = PagerSnapLayoutInfoProviderKt.isLtrDragging($this$isScrollingForward));
        return bl && reverseScrollDirection || var0_1 == false && var2_3 == false;
    }

    private static final float dragGestureDelta(PagerState $this$dragGestureDelta) {
        PagerState pagerState;
        if ($this$dragGestureDelta.getLayoutInfo().getOrientation() == Orientation.Horizontal) {
            return Offset.getX-impl((long)$this$dragGestureDelta.getUpDownDifference-F1C5BW0$foundation());
        }
        return Offset.getY-impl((long)pagerState.getUpDownDifference-F1C5BW0$foundation());
    }

    private static final void debugLog(Function0<String> generateMsg) {
    }

    /*
     * WARNING - void declaration
     */
    public static final float calculateFinalSnappingBound(PagerState pagerState, LayoutDirection layoutDirection, float snapPositionalThreshold, float flingVelocity, float lowerBoundOffset, float upperBoundOffset) {
        int n;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"pagerState");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        boolean isScrollingForward = PagerSnapLayoutInfoProviderKt.isScrollingForward(pagerState, flingVelocity);
        boolean isForward = pagerState.getLayoutInfo().getOrientation() == Orientation.Vertical ? isScrollingForward : (layoutDirection == LayoutDirection.Ltr ? isScrollingForward : !isScrollingForward);
        int pageSize = pagerState.getLayoutInfo().getPageSize();
        float offsetFromSnappedPosition = pageSize == 0 ? 0.0f : PagerSnapLayoutInfoProviderKt.dragGestureDelta(pagerState) / (float)pageSize;
        float offsetFromSnappedPositionOverflow = offsetFromSnappedPosition - (float)((int)offsetFromSnappedPosition);
        Density density = pagerState.getDensity$foundation();
        int n2 = LazyListSnapLayoutInfoProviderKt.calculateFinalSnappingItem(density, (float)var3_4);
        n2 = n2;
        if (FinalSnappingItem.equals-impl0(n, FinalSnappingItem.Companion.getClosestItem-bbeMdSM())) {
            PagerState pagerState2;
            void var2_3;
            if (Math.abs(offsetFromSnappedPositionOverflow) > var2_3) {
                if (isForward) {
                    return upperBoundOffset;
                }
                return lowerBoundOffset;
            }
            if (Math.abs(offsetFromSnappedPosition) >= Math.abs(pagerState2.getPositionThresholdFraction$foundation())) {
                void var1_2;
                if (var1_2 != false) {
                    return lowerBoundOffset;
                }
                return upperBoundOffset;
            }
            if (Math.abs(lowerBoundOffset) < Math.abs(upperBoundOffset)) {
                return lowerBoundOffset;
            }
            return upperBoundOffset;
        }
        if (FinalSnappingItem.equals-impl0(n2, FinalSnappingItem.Companion.getNextItem-bbeMdSM())) {
            return upperBoundOffset;
        }
        if (FinalSnappingItem.equals-impl0(n2, FinalSnappingItem.Companion.getPreviousItem-bbeMdSM())) {
            return lowerBoundOffset;
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$isScrollingForward(PagerState $receiver, float velocity) {
        void var1_1;
        return PagerSnapLayoutInfoProviderKt.isScrollingForward($receiver, (float)var1_1);
    }
}

