/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoop;
import io.netty.channel.oio.OioByteStreamChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.oio.DefaultOioSocketChannelConfig;
import io.netty.channel.socket.oio.OioSocketChannelConfig;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;

@Deprecated
public class OioSocketChannel
extends OioByteStreamChannel
implements SocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OioSocketChannel.class);
    private final Socket socket;
    private final OioSocketChannelConfig config;

    public OioSocketChannel() {
        this(new Socket());
    }

    /*
     * WARNING - void declaration
     */
    public OioSocketChannel(Socket socket) {
        this(null, (Socket)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public OioSocketChannel(Channel parent, Socket socket) {
        super(parent);
        this.socket = socket;
        this.config = new DefaultOioSocketChannelConfig(this, socket);
        try {
            try {
                if (socket.isConnected()) {
                    this.activate(socket.getInputStream(), socket.getOutputStream());
                }
                socket.setSoTimeout(1000);
                return;
            }
            catch (Exception e) {
                void var1_2;
                throw new ChannelException("failed to initialize a socket", (Throwable)var1_2);
            }
        }
        catch (Throwable throwable) {
            try {
                socket.close();
            }
            catch (IOException e) {
                void var2_5;
                logger.warn("Failed to close a socket.", (Throwable)var2_5);
            }
            throw throwable;
        }
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public OioSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public boolean isActive() {
        return !this.socket.isClosed() && this.socket.isConnected();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown() || !((OioByteStreamChannel)this).isActive();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown() || !((OioByteStreamChannel)this).isActive();
    }

    @Override
    public boolean isShutdown() {
        return this.socket.isInputShutdown() && this.socket.isOutputShutdown() || !((OioByteStreamChannel)this).isActive();
    }

    @Override
    protected final void doShutdownOutput() throws Exception {
        this.shutdownOutput0();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        OioSocketChannel oioSocketChannel = this;
        return oioSocketChannel.shutdownOutput(oioSocketChannel.newPromise());
    }

    @Override
    public ChannelFuture shutdownInput() {
        OioSocketChannel oioSocketChannel = this;
        return oioSocketChannel.shutdownInput(oioSocketChannel.newPromise());
    }

    @Override
    public ChannelFuture shutdown() {
        OioSocketChannel oioSocketChannel = this;
        return oioSocketChannel.shutdown(oioSocketChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int doReadBytes(ByteBuf buf) throws Exception {
        if (this.socket.isClosed()) {
            return -1;
        }
        try {
            void var1_1;
            return super.doReadBytes((ByteBuf)var1_1);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture shutdownOutput(ChannelPromise promise) {
        void var1_1;
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            this.shutdownOutput0(promise);
        } else {
            void var2_2;
            var2_2.execute(new Runnable(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ OioSocketChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    OioSocketChannel.access$000(this.this$0, this.val$promise);
                }
            });
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownOutput0(ChannelPromise promise) {
        try {
            this.shutdownOutput0();
            promise.setSuccess();
            return;
        }
        catch (Throwable t) {
            void var2_2;
            void var1_1;
            var1_1.setFailure((Throwable)var2_2);
            return;
        }
    }

    private void shutdownOutput0() throws IOException {
        this.socket.shutdownOutput();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture shutdownInput(ChannelPromise promise) {
        void var1_1;
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            this.shutdownInput0(promise);
        } else {
            void var2_2;
            var2_2.execute(new Runnable(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ OioSocketChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    OioSocketChannel.access$100(this.this$0, this.val$promise);
                }
            });
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownInput0(ChannelPromise promise) {
        try {
            this.socket.shutdownInput();
            promise.setSuccess();
            return;
        }
        catch (Throwable t) {
            void var2_2;
            void var1_1;
            var1_1.setFailure((Throwable)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture shutdown(ChannelPromise promise) {
        void var1_1;
        ChannelFuture shutdownOutputFuture = this.shutdownOutput();
        if (shutdownOutputFuture.isDone()) {
            this.shutdownOutputDone(shutdownOutputFuture, promise);
        } else {
            void var2_2;
            var2_2.addListener(new ChannelFutureListener(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ OioSocketChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture shutdownOutputFuture) throws Exception {
                    void var1_1;
                    OioSocketChannel.access$200(this.this$0, (ChannelFuture)var1_1, this.val$promise);
                }
            });
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownOutputDone(ChannelFuture shutdownOutputFuture, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        void var3_3;
        ChannelFuture shutdownInputFuture = this.shutdownInput();
        if (shutdownInputFuture.isDone()) {
            OioSocketChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
            return;
        }
        var3_3.addListener(new ChannelFutureListener(this, (ChannelFuture)var1_1, (ChannelPromise)var2_2){
            final /* synthetic */ ChannelFuture val$shutdownOutputFuture;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ OioSocketChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$shutdownOutputFuture = channelFuture;
                this.val$promise = channelPromise;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture shutdownInputFuture) throws Exception {
                void var1_1;
                OioSocketChannel.access$300(this.val$shutdownOutputFuture, (ChannelFuture)var1_1, this.val$promise);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void shutdownDone(ChannelFuture shutdownOutputFuture, ChannelFuture shutdownInputFuture, ChannelPromise promise) {
        void var2_2;
        Throwable shutdownOutputCause = shutdownOutputFuture.cause();
        Throwable shutdownInputCause = shutdownInputFuture.cause();
        if (shutdownOutputCause != null) {
            Throwable throwable;
            if (shutdownInputCause != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", shutdownInputCause);
            }
            promise.setFailure(throwable);
            return;
        }
        if (shutdownInputCause != null) {
            void var1_1;
            promise.setFailure((Throwable)var1_1);
            return;
        }
        var2_2.setSuccess();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.socket.getRemoteSocketAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        SocketUtils.bind((Socket)this.socket, (SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (localAddress != null) {
            SocketUtils.bind((Socket)this.socket, (SocketAddress)localAddress);
        }
        int connectTimeoutMillis = this.config().getConnectTimeoutMillis();
        try {
            try {
                SocketUtils.connect((Socket)this.socket, (SocketAddress)remoteAddress, (int)connectTimeoutMillis);
                OioSocketChannel oioSocketChannel = this;
                oioSocketChannel.activate(oioSocketChannel.socket.getInputStream(), this.socket.getOutputStream());
                return;
            }
            catch (SocketTimeoutException e) {
                void var1_1;
                void var3_5;
                void var2_4;
                ConnectTimeoutException cause = new ConnectTimeoutException("connection timed out after " + (int)var2_4 + " ms: " + remoteAddress);
                cause.setStackTrace(var3_5.getStackTrace());
                throw var1_1;
            }
        }
        catch (Throwable throwable) {
            this.doClose();
            throw throwable;
        }
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        this.socket.close();
    }

    protected boolean checkInputShutdown() {
        if (this.isInputShutdown()) {
            try {
                Thread.sleep(this.config().getSoTimeout());
            }
            catch (Throwable throwable) {}
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    protected void setReadPending(boolean readPending) {
        void var1_1;
        super.setReadPending((boolean)var1_1);
    }

    final void clearReadPending0() {
        this.clearReadPending();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(OioSocketChannel x0, ChannelPromise x1) {
        void var1_1;
        x0.shutdownOutput0((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(OioSocketChannel x0, ChannelPromise x1) {
        void var1_1;
        x0.shutdownInput0((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(OioSocketChannel x0, ChannelFuture x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        x0.shutdownOutputDone((ChannelFuture)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(ChannelFuture x0, ChannelFuture x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        OioSocketChannel.shutdownDone(x0, (ChannelFuture)var1_1, (ChannelPromise)var2_2);
    }
}

