/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.oio.AbstractOioMessageChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramChannelConfig;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.oio.DefaultOioDatagramChannelConfig;
import io.netty.channel.socket.oio.OioDatagramChannelConfig;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.util.List;
import java.util.Locale;

@Deprecated
public class OioDatagramChannel
extends AbstractOioMessageChannel
implements DatagramChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OioDatagramChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(true);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(SocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private final MulticastSocket socket;
    private final OioDatagramChannelConfig config;
    private final java.net.DatagramPacket tmpPacket = new java.net.DatagramPacket(EmptyArrays.EMPTY_BYTES, 0);

    /*
     * WARNING - void declaration
     */
    private static MulticastSocket newSocket() {
        try {
            return new MulticastSocket(null);
        }
        catch (Exception e) {
            void var0;
            throw new ChannelException("failed to create a new socket", (Throwable)var0);
        }
    }

    public OioDatagramChannel() {
        this(OioDatagramChannel.newSocket());
    }

    /*
     * WARNING - void declaration
     */
    public OioDatagramChannel(MulticastSocket socket) {
        super(null);
        void var1_1;
        try {
            try {
                socket.setSoTimeout(1000);
                socket.setBroadcast(false);
            }
            catch (SocketException e) {
                void var2_2;
                throw new ChannelException("Failed to configure the datagram socket timeout.", (Throwable)var2_2);
            }
        }
        catch (Throwable throwable) {
            socket.close();
            throw throwable;
        }
        this.socket = socket;
        this.config = new DefaultOioDatagramChannelConfig(this, (DatagramSocket)var1_1);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public DatagramChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && (this.config.getOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) != false && this.isRegistered() || this.socket.isBound());
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.socket.getRemoteSocketAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        this.socket.bind((SocketAddress)var1_1);
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (localAddress != null) {
            this.socket.bind(localAddress);
        }
        try {
            void var1_1;
            this.socket.connect((SocketAddress)var1_1);
            return;
        }
        catch (Throwable throwable) {
            try {
                this.socket.close();
            }
            catch (Throwable t) {
                void var2_4;
                logger.warn("Failed to close a socket.", (Throwable)var2_4);
            }
            throw throwable;
        }
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.socket.disconnect();
    }

    @Override
    protected void doClose() throws Exception {
        this.socket.close();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    protected int doReadMessages(List<Object> buf) throws Exception {
        DatagramChannelConfig config = this.config();
        RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
        ByteBuf data = config.getAllocator().heapBuffer(allocHandle.guess());
        boolean free = true;
        try {
            void var3_4;
            void var1_1;
            this.tmpPacket.setAddress(null);
            this.tmpPacket.setData(data.array(), data.arrayOffset(), data.capacity());
            this.socket.receive(this.tmpPacket);
            InetSocketAddress remoteAddr = (InetSocketAddress)this.tmpPacket.getSocketAddress();
            allocHandle.lastBytesRead(this.tmpPacket.getLength());
            var1_1.add(new DatagramPacket(data.writerIndex(var3_4.lastBytesRead()), this.localAddress(), remoteAddr));
            free = false;
            return 1;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (free) {
                data.release();
            }
            return 0;
        }
        catch (SocketException socketException) {
            block10: {
                SocketException e = socketException;
                if (!socketException.getMessage().toLowerCase(Locale.US).contains("socket closed")) {
                    throw e;
                }
                if (!free) break block10;
                data.release();
            }
            return -1;
        }
        catch (Throwable throwable) {
            block11: {
                Throwable throwable2 = throwable;
                PlatformDependent.throwException((Throwable)throwable);
                if (!free) break block11;
                {
                    catch (Throwable throwable3) {
                        if (free) {
                            void var2_3;
                            var2_3.release();
                        }
                        throw throwable3;
                    }
                }
                data.release();
            }
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        Object o;
        while ((o = in.current()) != null) {
            ByteBuf data;
            Object remoteAddress;
            if (o instanceof AddressedEnvelope) {
                AddressedEnvelope envelope = (AddressedEnvelope)o;
                remoteAddress = envelope.recipient();
                data = (ByteBuf)envelope.content();
            } else {
                data = data;
                remoteAddress = null;
            }
            int length = data.readableBytes();
            try {
                if (remoteAddress != null) {
                    void var3_4;
                    this.tmpPacket.setSocketAddress((SocketAddress)var3_4);
                } else {
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                    this.tmpPacket.setAddress(null);
                }
                if (data.hasArray()) {
                    this.tmpPacket.setData(data.array(), data.arrayOffset() + data.readerIndex(), length);
                } else {
                    ByteBuf byteBuf = data;
                    this.tmpPacket.setData(ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)byteBuf.readerIndex(), (int)length));
                }
                this.socket.send(this.tmpPacket);
                in.remove();
            }
            catch (Exception e) {
                void var2_3;
                in.remove((Throwable)var2_3);
            }
        }
    }

    private static void checkUnresolved(AddressedEnvelope<?, ?> envelope) {
        AddressedEnvelope<?, ?> addressedEnvelope;
        if (envelope.recipient() instanceof InetSocketAddress && ((InetSocketAddress)addressedEnvelope.recipient()).isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Object filterOutboundMessage(Object msg) {
        void var1_1;
        if (msg instanceof DatagramPacket) {
            OioDatagramChannel.checkUnresolved((DatagramPacket)msg);
            return msg;
        }
        if (msg instanceof ByteBuf) {
            return msg;
        }
        if (msg instanceof AddressedEnvelope) {
            void var2_2;
            AddressedEnvelope e = (AddressedEnvelope)msg;
            OioDatagramChannel.checkUnresolved(e);
            if (var2_2.content() instanceof ByteBuf) {
                return msg;
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)var1_1) + EXPECTED_TYPES);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture joinGroup(InetAddress multicastAddress) {
        void var1_1;
        return this.joinGroup((InetAddress)var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture joinGroup(InetAddress multicastAddress, ChannelPromise promise) {
        void var2_3;
        this.ensureBound();
        try {
            this.socket.joinGroup(multicastAddress);
            promise.setSuccess();
        }
        catch (IOException e) {
            void var1_2;
            promise.setFailure((Throwable)var1_2);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        void var2_2;
        void var1_1;
        return this.joinGroup((InetSocketAddress)var1_1, (NetworkInterface)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        void var3_4;
        this.ensureBound();
        try {
            void var2_3;
            this.socket.joinGroup(multicastAddress, (NetworkInterface)var2_3);
            promise.setSuccess();
        }
        catch (IOException e) {
            void var1_2;
            promise.setFailure((Throwable)var1_2);
        }
        return var3_4;
    }

    @Override
    public ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        return this.newFailedFuture(new UnsupportedOperationException());
    }

    @Override
    public ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        promise.setFailure(new UnsupportedOperationException());
        return promise;
    }

    private void ensureBound() {
        if (!this.isActive()) {
            throw new IllegalStateException(DatagramChannel.class.getName() + " must be bound to join a group.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture leaveGroup(InetAddress multicastAddress) {
        void var1_1;
        return this.leaveGroup((InetAddress)var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture leaveGroup(InetAddress multicastAddress, ChannelPromise promise) {
        void var2_3;
        try {
            this.socket.leaveGroup(multicastAddress);
            promise.setSuccess();
        }
        catch (IOException e) {
            void var1_2;
            promise.setFailure((Throwable)var1_2);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        void var2_2;
        void var1_1;
        return this.leaveGroup((InetSocketAddress)var1_1, (NetworkInterface)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        void var3_4;
        try {
            void var2_3;
            this.socket.leaveGroup(multicastAddress, (NetworkInterface)var2_3);
            promise.setSuccess();
        }
        catch (IOException e) {
            void var1_2;
            promise.setFailure((Throwable)var1_2);
        }
        return var3_4;
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        return this.newFailedFuture(new UnsupportedOperationException());
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        promise.setFailure(new UnsupportedOperationException());
        return promise;
    }

    @Override
    public ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
        return this.newFailedFuture(new UnsupportedOperationException());
    }

    @Override
    public ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock, ChannelPromise promise) {
        promise.setFailure(new UnsupportedOperationException());
        return promise;
    }

    @Override
    public ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock) {
        return this.newFailedFuture(new UnsupportedOperationException());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock, ChannelPromise promise) {
        void var3_3;
        promise.setFailure(new UnsupportedOperationException());
        return var3_3;
    }
}

