/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.PreferHeapByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DefaultDatagramChannelConfig;
import io.netty.channel.socket.oio.OioDatagramChannelConfig;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;

final class DefaultOioDatagramChannelConfig
extends DefaultDatagramChannelConfig
implements OioDatagramChannelConfig {
    /*
     * WARNING - void declaration
     */
    DefaultOioDatagramChannelConfig(DatagramChannel channel, DatagramSocket javaSocket) {
        super((DatagramChannel)var1_1, (DatagramSocket)var2_2);
        void var2_2;
        void var1_1;
        this.setAllocator(new PreferHeapByteBufAllocator(this.getAllocator()));
    }

    @Override
    public final Map<ChannelOption<?>, Object> getOptions() {
        DefaultOioDatagramChannelConfig defaultOioDatagramChannelConfig = this;
        return defaultOioDatagramChannelConfig.getOptions(super.getOptions(), ChannelOption.SO_TIMEOUT);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T getOption(ChannelOption<T> option) {
        void var1_1;
        if (option == ChannelOption.SO_TIMEOUT) {
            return (T)Integer.valueOf(this.getSoTimeout());
        }
        return super.getOption(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option != ChannelOption.SO_TIMEOUT) {
            void var2_2;
            void var1_1;
            return super.setOption(var1_1, var2_2);
        }
        this.setSoTimeout((Integer)value);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setSoTimeout(int timeout) {
        try {
            this.javaSocket().setSoTimeout(timeout);
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getSoTimeout() {
        try {
            return this.javaSocket().getSoTimeout();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setBroadcast(boolean broadcast) {
        void var1_1;
        super.setBroadcast((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setInterface(InetAddress interfaceAddress) {
        void var1_1;
        super.setInterface((InetAddress)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setLoopbackModeDisabled(boolean loopbackModeDisabled) {
        void var1_1;
        super.setLoopbackModeDisabled((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setNetworkInterface(NetworkInterface networkInterface) {
        void var1_1;
        super.setNetworkInterface((NetworkInterface)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setReuseAddress(boolean reuseAddress) {
        void var1_1;
        super.setReuseAddress((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        void var1_1;
        super.setReceiveBufferSize((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setSendBufferSize(int sendBufferSize) {
        void var1_1;
        super.setSendBufferSize((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setTimeToLive(int ttl) {
        void var1_1;
        super.setTimeToLive((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setTrafficClass(int trafficClass) {
        void var1_1;
        super.setTrafficClass((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setWriteSpinCount(int writeSpinCount) {
        void var1_1;
        super.setWriteSpinCount((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        void var1_1;
        super.setConnectTimeoutMillis((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        void var1_1;
        super.setMaxMessagesPerRead((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setAllocator(ByteBufAllocator allocator) {
        void var1_1;
        super.setAllocator((ByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        void var1_1;
        super.setRecvByteBufAllocator((RecvByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setAutoRead(boolean autoRead) {
        void var1_1;
        super.setAutoRead((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setAutoClose(boolean autoClose) {
        void var1_1;
        super.setAutoClose((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        void var1_1;
        super.setWriteBufferHighWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        void var1_1;
        super.setWriteBufferLowWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        void var1_1;
        super.setWriteBufferWaterMark((WriteBufferWaterMark)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final OioDatagramChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        void var1_1;
        super.setMessageSizeEstimator((MessageSizeEstimator)var1_1);
        return this;
    }
}

