/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.ProtocolFamilyConverter;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ProtocolFamily;
import java.net.StandardProtocolFamily;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;

final class SelectorProviderUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SelectorProviderUtil.class);

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    static Method findOpenMethod(String methodName) {
        if (PlatformDependent.javaVersion() >= 15) {
            try {
                return SelectorProvider.class.getMethod(methodName, ProtocolFamily.class);
            }
            catch (Throwable e) {
                void var1_1;
                String string;
                logger.debug("SelectorProvider.{}(ProtocolFamily) not available, will use default", (Object)string, (Object)var1_1);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private static <C extends Channel> C newChannel(Method method, SelectorProvider provider, Object family) throws IOException {
        if (family != null && method != null) {
            try {
                void var2_4;
                void var1_3;
                method = (Channel)((Method)method).invoke((Object)var1_3, var2_4);
                return (C)method;
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                void var0_2;
                throw new IOException((Throwable)var0_2);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    static <C extends Channel> C newChannel(Method method, SelectorProvider provider, InternetProtocolFamily family) throws IOException {
        if (family != null) {
            void var2_2;
            void var1_1;
            Method method2;
            return SelectorProviderUtil.newChannel(method2, (SelectorProvider)var1_1, ProtocolFamilyConverter.convert((InternetProtocolFamily)var2_2));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    static <C extends Channel> C newDomainSocketChannel(Method method, SelectorProvider provider) throws IOException {
        void var1_1;
        return SelectorProviderUtil.newChannel(method, (SelectorProvider)var1_1, StandardProtocolFamily.valueOf("UNIX"));
    }

    private SelectorProviderUtil() {
    }
}

