/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioByteChannel;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.NioEventLoop;
import io.netty.channel.socket.DefaultSocketChannelConfig;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.SelectorProviderUtil;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Map;
import java.util.concurrent.Executor;

public class NioSocketChannel
extends AbstractNioByteChannel
implements SocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioSocketChannel.class);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final Method OPEN_SOCKET_CHANNEL_WITH_FAMILY = SelectorProviderUtil.findOpenMethod("openSocketChannel");
    private final SocketChannelConfig config;

    /*
     * WARNING - void declaration
     */
    private static java.nio.channels.SocketChannel newChannel(SelectorProvider provider, InternetProtocolFamily family) {
        try {
            java.nio.channels.SocketChannel channel = (java.nio.channels.SocketChannel)SelectorProviderUtil.newChannel(OPEN_SOCKET_CHANNEL_WITH_FAMILY, provider, family);
            if (channel == null) {
                SelectorProvider selectorProvider;
                return selectorProvider.openSocketChannel();
            }
            return channel;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException("Failed to open a socket.", (Throwable)var1_2);
        }
    }

    public NioSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    /*
     * WARNING - void declaration
     */
    public NioSocketChannel(SelectorProvider provider) {
        this((SelectorProvider)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NioSocketChannel(SelectorProvider provider, InternetProtocolFamily family) {
        this(NioSocketChannel.newChannel((SelectorProvider)var1_1, (InternetProtocolFamily)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NioSocketChannel(java.nio.channels.SocketChannel socket) {
        this(null, (java.nio.channels.SocketChannel)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NioSocketChannel(Channel parent, java.nio.channels.SocketChannel socket) {
        super((Channel)var1_1, socket);
        void var2_2;
        void var1_1;
        NioSocketChannel nioSocketChannel = this;
        this.config = nioSocketChannel.new NioSocketChannelConfig(nioSocketChannel, var2_2.socket());
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public SocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected java.nio.channels.SocketChannel javaChannel() {
        return (java.nio.channels.SocketChannel)super.javaChannel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isActive() {
        void var1_1;
        java.nio.channels.SocketChannel ch = this.javaChannel();
        return ch.isOpen() && var1_1.isConnected();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.javaChannel().socket().isOutputShutdown() || !this.isActive();
    }

    @Override
    public boolean isInputShutdown() {
        return this.javaChannel().socket().isInputShutdown() || !this.isActive();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isShutdown() {
        void var1_1;
        Socket socket = this.javaChannel().socket();
        return socket.isInputShutdown() && var1_1.isOutputShutdown() || !this.isActive();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    protected final void doShutdownOutput() throws Exception {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownOutput();
            return;
        }
        this.javaChannel().socket().shutdownOutput();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        NioSocketChannel nioSocketChannel = this;
        return nioSocketChannel.shutdownOutput(nioSocketChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture shutdownOutput(ChannelPromise promise) {
        void var1_1;
        NioEventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)((Object)this.unsafe())).shutdownOutput(promise);
        } else {
            void var2_2;
            var2_2.execute(new Runnable(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ NioSocketChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    ((AbstractChannel.AbstractUnsafe)((Object)this.this$0.unsafe())).shutdownOutput(this.val$promise);
                }
            });
        }
        return var1_1;
    }

    @Override
    public ChannelFuture shutdownInput() {
        NioSocketChannel nioSocketChannel = this;
        return nioSocketChannel.shutdownInput(nioSocketChannel.newPromise());
    }

    @Override
    protected boolean isInputShutdown0() {
        return this.isInputShutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture shutdownInput(ChannelPromise promise) {
        void var1_1;
        NioEventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            this.shutdownInput0(promise);
        } else {
            void var2_2;
            var2_2.execute(new Runnable(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ NioSocketChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    NioSocketChannel.access$100(this.this$0, this.val$promise);
                }
            });
        }
        return var1_1;
    }

    @Override
    public ChannelFuture shutdown() {
        NioSocketChannel nioSocketChannel = this;
        return nioSocketChannel.shutdown(nioSocketChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture shutdown(ChannelPromise promise) {
        void var1_1;
        ChannelFuture shutdownOutputFuture = this.shutdownOutput();
        if (shutdownOutputFuture.isDone()) {
            this.shutdownOutputDone(shutdownOutputFuture, promise);
        } else {
            void var2_2;
            var2_2.addListener(new ChannelFutureListener(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ NioSocketChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture shutdownOutputFuture) throws Exception {
                    void var1_1;
                    NioSocketChannel.access$200(this.this$0, (ChannelFuture)var1_1, this.val$promise);
                }
            });
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownOutputDone(ChannelFuture shutdownOutputFuture, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        void var3_3;
        ChannelFuture shutdownInputFuture = this.shutdownInput();
        if (shutdownInputFuture.isDone()) {
            NioSocketChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
            return;
        }
        var3_3.addListener(new ChannelFutureListener(this, (ChannelFuture)var1_1, (ChannelPromise)var2_2){
            final /* synthetic */ ChannelFuture val$shutdownOutputFuture;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ NioSocketChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$shutdownOutputFuture = channelFuture;
                this.val$promise = channelPromise;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture shutdownInputFuture) throws Exception {
                void var1_1;
                NioSocketChannel.access$300(this.val$shutdownOutputFuture, (ChannelFuture)var1_1, this.val$promise);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void shutdownDone(ChannelFuture shutdownOutputFuture, ChannelFuture shutdownInputFuture, ChannelPromise promise) {
        void var2_2;
        Throwable shutdownOutputCause = shutdownOutputFuture.cause();
        Throwable shutdownInputCause = shutdownInputFuture.cause();
        if (shutdownOutputCause != null) {
            Throwable throwable;
            if (shutdownInputCause != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", shutdownInputCause);
            }
            promise.setFailure(throwable);
            return;
        }
        if (shutdownInputCause != null) {
            void var1_1;
            promise.setFailure((Throwable)var1_1);
            return;
        }
        var2_2.setSuccess();
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownInput0(ChannelPromise promise) {
        try {
            this.shutdownInput0();
            promise.setSuccess();
            return;
        }
        catch (Throwable t) {
            void var2_2;
            void var1_1;
            var1_1.setFailure((Throwable)var2_2);
            return;
        }
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private void shutdownInput0() throws Exception {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownInput();
            return;
        }
        this.javaChannel().socket().shutdownInput();
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        this.doBind0((SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void doBind0(SocketAddress localAddress) throws Exception {
        void var1_1;
        if (PlatformDependent.javaVersion() >= 7) {
            SocketUtils.bind((java.nio.channels.SocketChannel)this.javaChannel(), (SocketAddress)localAddress);
            return;
        }
        SocketUtils.bind((Socket)this.javaChannel().socket(), (SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (localAddress != null) {
            this.doBind0(localAddress);
        }
        boolean success = false;
        try {
            void var1_2;
            boolean connected = SocketUtils.connect((java.nio.channels.SocketChannel)this.javaChannel(), (SocketAddress)remoteAddress);
            if (!connected) {
                this.selectionKey().interestOps(8);
            }
            success = true;
            return (boolean)var1_2;
        }
        catch (Throwable throwable) {
            void var2_5;
            if (var2_5 == false) {
                this.doClose();
            }
            throw throwable;
        }
    }

    @Override
    protected void doFinishConnect() throws Exception {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        this.javaChannel().close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int doReadBytes(ByteBuf byteBuf) throws Exception {
        void var2_2;
        void var1_1;
        RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
        allocHandle.attemptedBytesRead(byteBuf.writableBytes());
        return var1_1.writeBytes((ScatteringByteChannel)this.javaChannel(), var2_2.attemptedBytesRead());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int doWriteBytes(ByteBuf buf) throws Exception {
        void var2_2;
        void var1_1;
        int expectedWrittenBytes = buf.readableBytes();
        return var1_1.readBytes((GatheringByteChannel)this.javaChannel(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long doWriteFileRegion(FileRegion region) throws Exception {
        void var2_2;
        void var1_1;
        long position = region.transferred();
        return var1_1.transferTo(this.javaChannel(), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void adjustMaxBytesPerGatheringWrite(int attempted, int written, int oldMaxBytesPerGatheringWrite) {
        void var2_2;
        if (attempted == written) {
            void var3_3;
            if (attempted << 1 > var3_3) {
                ((NioSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(attempted << 1);
                return;
            }
        } else if (attempted > 4096 && var2_2 < attempted >>> 1) {
            void var1_1;
            ((NioSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite((int)(var1_1 >>> 1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        void var3_3;
        java.nio.channels.SocketChannel ch = this.javaChannel();
        int writeSpinCount = this.config().getWriteSpinCount();
        do {
            if (in.isEmpty()) {
                this.clearOpWrite();
                return;
            }
            int maxBytesPerGatheringWrite = ((NioSocketChannelConfig)this.config).getMaxBytesPerGatheringWrite();
            ByteBuffer[] nioBuffers = in.nioBuffers(1024, maxBytesPerGatheringWrite);
            int nioBufferCnt = in.nioBufferCount();
            switch (nioBufferCnt) {
                case 0: {
                    writeSpinCount -= this.doWrite0(in);
                    break;
                }
                case 1: {
                    ByteBuffer buffer = nioBuffers[0];
                    int attemptedBytes = buffer.remaining();
                    int localWrittenBytes = ch.write(buffer);
                    if (localWrittenBytes <= 0) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite(attemptedBytes, localWrittenBytes, maxBytesPerGatheringWrite);
                    in.removeBytes(localWrittenBytes);
                    --writeSpinCount;
                    break;
                }
                default: {
                    long attemptedBytes = in.nioBufferSize();
                    long localWrittenBytes = ch.write(nioBuffers, 0, nioBufferCnt);
                    if (localWrittenBytes <= 0L) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite((int)attemptedBytes, (int)localWrittenBytes, maxBytesPerGatheringWrite);
                    in.removeBytes(localWrittenBytes);
                    --writeSpinCount;
                }
            }
        } while (writeSpinCount > 0);
        this.incompleteWrite(var3_3 < 0);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioSocketChannelUnsafe();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(NioSocketChannel x0, ChannelPromise x1) {
        void var1_1;
        x0.shutdownInput0((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(NioSocketChannel x0, ChannelFuture x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        x0.shutdownOutputDone((ChannelFuture)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(ChannelFuture x0, ChannelFuture x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        NioSocketChannel.shutdownDone(x0, (ChannelFuture)var1_1, (ChannelPromise)var2_2);
    }

    private final class NioSocketChannelConfig
    extends DefaultSocketChannelConfig {
        private volatile int maxBytesPerGatheringWrite;

        /*
         * WARNING - void declaration
         */
        private NioSocketChannelConfig(NioSocketChannel channel, Socket javaSocket) {
            void var3_3;
            void var2_2;
            super((SocketChannel)var2_2, (Socket)var3_3);
            this.maxBytesPerGatheringWrite = Integer.MAX_VALUE;
            this.calculateMaxBytesPerGatheringWrite();
        }

        @Override
        protected final void autoReadCleared() {
            NioSocketChannel.this.clearReadPending();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioSocketChannelConfig setSendBufferSize(int sendBufferSize) {
            void var1_1;
            super.setSendBufferSize((int)var1_1);
            this.calculateMaxBytesPerGatheringWrite();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> boolean setOption(ChannelOption<T> option, T value) {
            void var2_2;
            void var1_1;
            if (PlatformDependent.javaVersion() >= 7 && option instanceof NioChannelOption) {
                return NioChannelOption.setOption(this.jdkChannel(), (NioChannelOption)option, value);
            }
            return super.setOption(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T getOption(ChannelOption<T> option) {
            void var1_1;
            if (PlatformDependent.javaVersion() >= 7 && option instanceof NioChannelOption) {
                return NioChannelOption.getOption(this.jdkChannel(), (NioChannelOption)option);
            }
            return super.getOption(var1_1);
        }

        @Override
        public final Map<ChannelOption<?>, Object> getOptions() {
            if (PlatformDependent.javaVersion() >= 7) {
                NioSocketChannelConfig nioSocketChannelConfig = this;
                return nioSocketChannelConfig.getOptions(super.getOptions(), NioChannelOption.getOptions(this.jdkChannel()));
            }
            return super.getOptions();
        }

        /*
         * WARNING - void declaration
         */
        final void setMaxBytesPerGatheringWrite(int maxBytesPerGatheringWrite) {
            void var1_1;
            this.maxBytesPerGatheringWrite = var1_1;
        }

        final int getMaxBytesPerGatheringWrite() {
            return this.maxBytesPerGatheringWrite;
        }

        /*
         * WARNING - void declaration
         */
        private void calculateMaxBytesPerGatheringWrite() {
            int newSendBufferSize = this.getSendBufferSize() << 1;
            if (newSendBufferSize > 0) {
                void var1_1;
                this.setMaxBytesPerGatheringWrite((int)var1_1);
            }
        }

        private java.nio.channels.SocketChannel jdkChannel() {
            return ((NioSocketChannel)this.channel).javaChannel();
        }
    }

    private final class NioSocketChannelUnsafe
    extends AbstractNioByteChannel.NioByteUnsafe {
        private NioSocketChannelUnsafe() {
            super(NioSocketChannel.this);
        }

        @Override
        protected final Executor prepareToClose() {
            try {
                if (NioSocketChannel.this.javaChannel().isOpen() && NioSocketChannel.this.config().getSoLinger() > 0) {
                    NioSocketChannel.this.doDeregister();
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable) {}
            return null;
        }
    }
}

