/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.nio.AbstractNioMessageChannel;
import io.netty.channel.socket.DefaultServerSocketChannelConfig;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.ServerSocketChannelConfig;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.nio.SelectorProviderUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.List;
import java.util.Map;

public class NioServerSocketChannel
extends AbstractNioMessageChannel
implements ServerSocketChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerSocketChannel.class);
    private static final Method OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY = SelectorProviderUtil.findOpenMethod("openServerSocketChannel");
    private final ServerSocketChannelConfig config;

    /*
     * WARNING - void declaration
     */
    private static java.nio.channels.ServerSocketChannel newChannel(SelectorProvider provider, InternetProtocolFamily family) {
        try {
            java.nio.channels.ServerSocketChannel channel = (java.nio.channels.ServerSocketChannel)SelectorProviderUtil.newChannel(OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY, provider, family);
            if (channel == null) {
                SelectorProvider selectorProvider;
                return selectorProvider.openServerSocketChannel();
            }
            return channel;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException("Failed to open a socket.", (Throwable)var1_2);
        }
    }

    public NioServerSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    /*
     * WARNING - void declaration
     */
    public NioServerSocketChannel(SelectorProvider provider) {
        this((SelectorProvider)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NioServerSocketChannel(SelectorProvider provider, InternetProtocolFamily family) {
        this(NioServerSocketChannel.newChannel((SelectorProvider)var1_1, (InternetProtocolFamily)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NioServerSocketChannel(java.nio.channels.ServerSocketChannel channel) {
        super(null, (SelectableChannel)var1_1, 16);
        void var1_1;
        NioServerSocketChannel nioServerSocketChannel = this;
        this.config = nioServerSocketChannel.new NioServerSocketChannelConfig(nioServerSocketChannel, this.javaChannel().socket());
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this.javaChannel().socket().isBound();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return null;
    }

    @Override
    protected java.nio.channels.ServerSocketChannel javaChannel() {
        return (java.nio.channels.ServerSocketChannel)super.javaChannel();
    }

    @Override
    protected SocketAddress localAddress0() {
        return SocketUtils.localSocketAddress((ServerSocket)this.javaChannel().socket());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    protected void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().bind(localAddress, this.config.getBacklog());
            return;
        }
        this.javaChannel().socket().bind((SocketAddress)var1_1, this.config.getBacklog());
    }

    @Override
    protected void doClose() throws Exception {
        this.javaChannel().close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int doReadMessages(List<Object> buf) throws Exception {
        SocketChannel ch = SocketUtils.accept((java.nio.channels.ServerSocketChannel)this.javaChannel());
        try {
            if (ch != null) {
                buf.add(new NioSocketChannel((Channel)this, ch));
                return 1;
            }
        }
        catch (Throwable t) {
            logger.warn("Failed to create a new channel from an accepted socket.", t);
            try {
                void var2_4;
                var2_4.close();
            }
            catch (Throwable t2) {
                void var1_3;
                logger.warn("Failed to close a socket.", (Throwable)var1_3);
            }
        }
        return 0;
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doFinishConnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected void doDisconnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean doWriteMessage(Object msg, ChannelOutboundBuffer in) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final Object filterOutboundMessage(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean closeOnReadError(Throwable cause) {
        void var1_1;
        return super.closeOnReadError((Throwable)var1_1);
    }

    private final class NioServerSocketChannelConfig
    extends DefaultServerSocketChannelConfig {
        /*
         * WARNING - void declaration
         */
        private NioServerSocketChannelConfig(NioServerSocketChannel channel, ServerSocket javaSocket) {
            void var3_3;
            void var2_2;
            super((ServerSocketChannel)var2_2, (ServerSocket)var3_3);
        }

        @Override
        protected final void autoReadCleared() {
            NioServerSocketChannel.this.clearReadPending();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> boolean setOption(ChannelOption<T> option, T value) {
            void var2_2;
            void var1_1;
            if (PlatformDependent.javaVersion() >= 7 && option instanceof NioChannelOption) {
                return NioChannelOption.setOption(this.jdkChannel(), (NioChannelOption)option, value);
            }
            return super.setOption(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T getOption(ChannelOption<T> option) {
            void var1_1;
            if (PlatformDependent.javaVersion() >= 7 && option instanceof NioChannelOption) {
                return NioChannelOption.getOption(this.jdkChannel(), (NioChannelOption)option);
            }
            return super.getOption(var1_1);
        }

        @Override
        public final Map<ChannelOption<?>, Object> getOptions() {
            if (PlatformDependent.javaVersion() >= 7) {
                NioServerSocketChannelConfig nioServerSocketChannelConfig = this;
                return nioServerSocketChannelConfig.getOptions(super.getOptions(), NioChannelOption.getOptions(this.jdkChannel()));
            }
            return super.getOptions();
        }

        private java.nio.channels.ServerSocketChannel jdkChannel() {
            return ((NioServerSocketChannel)this.channel).javaChannel();
        }
    }
}

