/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.ServerChannel;
import io.netty.channel.ServerChannelRecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioMessageChannel;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.NioDomainSocketChannel;
import io.netty.channel.socket.nio.NioDomainSocketUtil;
import io.netty.channel.socket.nio.SelectorProviderUtil;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class NioServerDomainSocketChannel
extends AbstractNioMessageChannel
implements ServerChannel {
    private static final Method OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY = SelectorProviderUtil.findOpenMethod("openServerSocketChannel");
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerDomainSocketChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private final NioDomainServerSocketChannelConfig config;
    private volatile boolean bound;

    /*
     * WARNING - void declaration
     */
    static ServerSocketChannel newChannel(SelectorProvider provider) {
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported with Java 16+");
        }
        try {
            ServerSocketChannel channel = (ServerSocketChannel)SelectorProviderUtil.newDomainSocketChannel(OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY, provider);
            if (channel == null) {
                throw new ChannelException("Failed to open a socket.");
            }
            return channel;
        }
        catch (IOException e) {
            void var0_1;
            throw new ChannelException("Failed to open a socket.", (Throwable)var0_1);
        }
    }

    @Override
    protected final ServerSocketChannel javaChannel() {
        return (ServerSocketChannel)super.javaChannel();
    }

    public NioServerDomainSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    /*
     * WARNING - void declaration
     */
    public NioServerDomainSocketChannel(SelectorProvider provider) {
        this(NioServerDomainSocketChannel.newChannel((SelectorProvider)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public NioServerDomainSocketChannel(ServerSocketChannel channel) {
        super(null, channel, 16);
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported with Java 16+");
        }
        NioServerDomainSocketChannel nioServerDomainSocketChannel = this;
        this.config = nioServerDomainSocketChannel.new NioDomainServerSocketChannelConfig(nioServerDomainSocketChannel);
        try {
            this.bound = channel.getLocalAddress() != null;
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    @Override
    public final ChannelConfig config() {
        return this.config;
    }

    @Override
    public final ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public final boolean isActive() {
        return this.isOpen() && this.bound;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    protected final void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        this.javaChannel().bind((SocketAddress)var1_1, this.config.getBacklog());
        this.bound = true;
    }

    @Override
    protected final void doDisconnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int doReadMessages(List<Object> buf) throws Exception {
        SocketChannel ch = SocketUtils.accept((ServerSocketChannel)this.javaChannel());
        try {
            if (ch != null) {
                buf.add(new NioDomainSocketChannel((Channel)this, ch));
                return 1;
            }
        }
        catch (Throwable t) {
            logger.warn("Failed to create a new channel from an accepted socket.", t);
            try {
                void var2_4;
                var2_4.close();
            }
            catch (Throwable t2) {
                void var1_3;
                logger.warn("Failed to close a socket.", (Throwable)var1_3);
            }
        }
        return 0;
    }

    @Override
    protected final boolean doWriteMessage(Object msg, ChannelOutboundBuffer in) throws Exception {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doClose() throws Exception {
        SocketAddress local = this.localAddress();
        try {
            super.doClose();
        }
        catch (Throwable throwable) {
            this.javaChannel().close();
            if (local != null) {
                void var1_1;
                NioDomainSocketUtil.deleteSocketFile((SocketAddress)var1_1);
            }
            throw throwable;
        }
        this.javaChannel().close();
        if (local != null) {
            NioDomainSocketUtil.deleteSocketFile(local);
            return;
        }
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    protected final SocketAddress localAddress0() {
        try {
            return this.javaChannel().getLocalAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected final SocketAddress remoteAddress0() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean closeOnReadError(Throwable cause) {
        void var1_1;
        return super.closeOnReadError((Throwable)var1_1);
    }

    @Override
    protected final boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final void doFinishConnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    private final class NioDomainServerSocketChannelConfig
    extends DefaultChannelConfig {
        private volatile int backlog;

        /*
         * WARNING - void declaration
         */
        private NioDomainServerSocketChannelConfig(NioServerDomainSocketChannel channel) {
            void var2_2;
            super((Channel)var2_2, new ServerChannelRecvByteBufAllocator());
            this.backlog = NetUtil.SOMAXCONN;
        }

        @Override
        protected final void autoReadCleared() {
            NioServerDomainSocketChannel.this.clearReadPending();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Map<ChannelOption<?>, Object> getOptions() {
            void var1_1;
            ArrayList<ChannelOption> options = new ArrayList<ChannelOption>();
            options.add(ChannelOption.SO_BACKLOG);
            for (ChannelOption opt : NioChannelOption.getOptions(this.jdkChannel())) {
                options.add(opt);
            }
            NioDomainServerSocketChannelConfig nioDomainServerSocketChannelConfig = this;
            return nioDomainServerSocketChannelConfig.getOptions(super.getOptions(), var1_1.toArray(new ChannelOption[0]));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T getOption(ChannelOption<T> option) {
            void var1_1;
            if (option == ChannelOption.SO_BACKLOG) {
                return (T)Integer.valueOf(this.getBacklog());
            }
            if (option instanceof NioChannelOption) {
                return NioChannelOption.getOption(this.jdkChannel(), (NioChannelOption)option);
            }
            return super.getOption(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> boolean setOption(ChannelOption<T> option, T value) {
            if (option != ChannelOption.SO_BACKLOG) {
                void var2_2;
                void var1_1;
                if (option instanceof NioChannelOption) {
                    return NioChannelOption.setOption(this.jdkChannel(), (NioChannelOption)option, value);
                }
                return super.setOption(var1_1, var2_2);
            }
            this.validate(option, value);
            this.setBacklog((Integer)value);
            return true;
        }

        private int getBacklog() {
            return this.backlog;
        }

        /*
         * WARNING - void declaration
         */
        private NioDomainServerSocketChannelConfig setBacklog(int backlog) {
            void var1_1;
            ObjectUtil.checkPositiveOrZero((int)backlog, (String)"backlog");
            this.backlog = var1_1;
            return this;
        }

        private ServerSocketChannel jdkChannel() {
            return ((NioServerDomainSocketChannel)this.channel).javaChannel();
        }
    }
}

