/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.util.internal.SuppressJava6Requirement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.file.Path;

final class NioDomainSocketUtil {
    private static final Method OF_METHOD;
    private static final Method GET_PATH_METHOD;

    /*
     * WARNING - void declaration
     */
    static SocketAddress newUnixDomainSocketAddress(String path) {
        if (OF_METHOD == null) {
            throw new IllegalStateException();
        }
        try {
            return (SocketAddress)OF_METHOD.invoke(null, path);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            void var0_2;
            throw new IllegalStateException((Throwable)var0_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Guarded by version check")
    static void deleteSocketFile(SocketAddress address) {
        if (GET_PATH_METHOD == null) {
            throw new IllegalStateException();
        }
        try {
            Path path = (Path)GET_PATH_METHOD.invoke((Object)address, new Object[0]);
            if (path != null) {
                path.toFile().delete();
            }
            return;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            void var0_2;
            throw new IllegalStateException((Throwable)var0_2);
        }
    }

    private NioDomainSocketUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1;
        void var0_1;
        Method getPathMethod;
        Method ofMethod;
        try {
            Class<?> clazz = Class.forName("java.net.UnixDomainSocketAddress");
            ofMethod = clazz.getMethod("of", String.class);
            getPathMethod = clazz.getMethod("getPath", new Class[0]);
        }
        catch (Throwable throwable) {
            ofMethod = null;
            getPathMethod = null;
        }
        OF_METHOD = var0_1;
        GET_PATH_METHOD = var1;
    }
}

