/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.FileRegion;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.AbstractNioByteChannel;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.NioEventLoop;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.socket.DuplexChannelConfig;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.SelectorProviderUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Map;

public final class NioDomainSocketChannel
extends AbstractNioByteChannel
implements DuplexChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioDomainSocketChannel.class);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final Method OPEN_SOCKET_CHANNEL_WITH_FAMILY = SelectorProviderUtil.findOpenMethod("openSocketChannel");
    private final ChannelConfig config;
    private volatile boolean isInputShutdown;
    private volatile boolean isOutputShutdown;

    /*
     * WARNING - void declaration
     */
    private static SocketChannel newChannel(SelectorProvider provider) {
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported on java 16+");
        }
        try {
            SocketChannel channel = (SocketChannel)SelectorProviderUtil.newDomainSocketChannel(OPEN_SOCKET_CHANNEL_WITH_FAMILY, provider);
            if (channel == null) {
                throw new ChannelException("Failed to open a socket.");
            }
            return channel;
        }
        catch (IOException e) {
            void var0_1;
            throw new ChannelException("Failed to open a socket.", (Throwable)var0_1);
        }
    }

    public NioDomainSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    /*
     * WARNING - void declaration
     */
    public NioDomainSocketChannel(SelectorProvider provider) {
        this(NioDomainSocketChannel.newChannel((SelectorProvider)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NioDomainSocketChannel(SocketChannel socket) {
        this(null, (SocketChannel)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NioDomainSocketChannel(Channel parent, SocketChannel socket) {
        super((Channel)var1_1, socket);
        void var2_2;
        void var1_1;
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported on java 16+");
        }
        NioDomainSocketChannel nioDomainSocketChannel = this;
        this.config = nioDomainSocketChannel.new NioDomainSocketChannelConfig(nioDomainSocketChannel, (SocketChannel)var2_2);
    }

    @Override
    public final ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public final ChannelConfig config() {
        return this.config;
    }

    @Override
    protected final SocketChannel javaChannel() {
        return (SocketChannel)super.javaChannel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isActive() {
        void var1_1;
        SocketChannel ch = this.javaChannel();
        return ch.isOpen() && var1_1.isConnected();
    }

    @Override
    public final boolean isOutputShutdown() {
        return this.isOutputShutdown || !this.isActive();
    }

    @Override
    public final boolean isInputShutdown() {
        return this.isInputShutdown || !this.isActive();
    }

    @Override
    public final boolean isShutdown() {
        return this.isInputShutdown() && this.isOutputShutdown() || !this.isActive();
    }

    @Override
    @SuppressJava6Requirement(reason="guarded by version check")
    protected final void doShutdownOutput() throws Exception {
        this.javaChannel().shutdownOutput();
        this.isOutputShutdown = true;
    }

    @Override
    public final ChannelFuture shutdownOutput() {
        NioDomainSocketChannel nioDomainSocketChannel = this;
        return nioDomainSocketChannel.shutdownOutput(nioDomainSocketChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture shutdownOutput(ChannelPromise promise) {
        void var1_1;
        NioEventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)((Object)this.unsafe())).shutdownOutput(promise);
        } else {
            void var2_2;
            var2_2.execute(new Runnable(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ NioDomainSocketChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    ((AbstractChannel.AbstractUnsafe)((Object)this.this$0.unsafe())).shutdownOutput(this.val$promise);
                }
            });
        }
        return var1_1;
    }

    @Override
    public final ChannelFuture shutdownInput() {
        NioDomainSocketChannel nioDomainSocketChannel = this;
        return nioDomainSocketChannel.shutdownInput(nioDomainSocketChannel.newPromise());
    }

    @Override
    protected final boolean isInputShutdown0() {
        return this.isInputShutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture shutdownInput(ChannelPromise promise) {
        void var1_1;
        NioEventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            this.shutdownInput0(promise);
        } else {
            void var2_2;
            var2_2.execute(new Runnable(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ NioDomainSocketChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    NioDomainSocketChannel.access$100(this.this$0, this.val$promise);
                }
            });
        }
        return var1_1;
    }

    @Override
    public final ChannelFuture shutdown() {
        NioDomainSocketChannel nioDomainSocketChannel = this;
        return nioDomainSocketChannel.shutdown(nioDomainSocketChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture shutdown(ChannelPromise promise) {
        void var1_1;
        ChannelFuture shutdownOutputFuture = this.shutdownOutput();
        if (shutdownOutputFuture.isDone()) {
            this.shutdownOutputDone(shutdownOutputFuture, promise);
        } else {
            void var2_2;
            var2_2.addListener(new ChannelFutureListener(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ NioDomainSocketChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture shutdownOutputFuture) throws Exception {
                    void var1_1;
                    NioDomainSocketChannel.access$200(this.this$0, (ChannelFuture)var1_1, this.val$promise);
                }
            });
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownOutputDone(ChannelFuture shutdownOutputFuture, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        void var3_3;
        ChannelFuture shutdownInputFuture = this.shutdownInput();
        if (shutdownInputFuture.isDone()) {
            NioDomainSocketChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
            return;
        }
        var3_3.addListener(new ChannelFutureListener(this, (ChannelFuture)var1_1, (ChannelPromise)var2_2){
            final /* synthetic */ ChannelFuture val$shutdownOutputFuture;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ NioDomainSocketChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$shutdownOutputFuture = channelFuture;
                this.val$promise = channelPromise;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture shutdownInputFuture) throws Exception {
                void var1_1;
                NioDomainSocketChannel.access$300(this.val$shutdownOutputFuture, (ChannelFuture)var1_1, this.val$promise);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void shutdownDone(ChannelFuture shutdownOutputFuture, ChannelFuture shutdownInputFuture, ChannelPromise promise) {
        void var2_2;
        Throwable shutdownOutputCause = shutdownOutputFuture.cause();
        Throwable shutdownInputCause = shutdownInputFuture.cause();
        if (shutdownOutputCause != null) {
            Throwable throwable;
            if (shutdownInputCause != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", shutdownInputCause);
            }
            promise.setFailure(throwable);
            return;
        }
        if (shutdownInputCause != null) {
            void var1_1;
            promise.setFailure((Throwable)var1_1);
            return;
        }
        var2_2.setSuccess();
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownInput0(ChannelPromise promise) {
        try {
            this.shutdownInput0();
            promise.setSuccess();
            return;
        }
        catch (Throwable t) {
            void var2_2;
            void var1_1;
            var1_1.setFailure((Throwable)var2_2);
            return;
        }
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private void shutdownInput0() throws Exception {
        this.javaChannel().shutdownInput();
        this.isInputShutdown = true;
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    protected final SocketAddress localAddress0() {
        try {
            return this.javaChannel().getLocalAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    protected final SocketAddress remoteAddress0() {
        try {
            return this.javaChannel().getRemoteAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        SocketUtils.bind((SocketChannel)this.javaChannel(), (SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (localAddress != null) {
            this.doBind(localAddress);
        }
        boolean success = false;
        try {
            void var1_2;
            boolean connected = SocketUtils.connect((SocketChannel)this.javaChannel(), (SocketAddress)remoteAddress);
            if (!connected) {
                this.selectionKey().interestOps(8);
            }
            success = true;
            return (boolean)var1_2;
        }
        catch (Throwable throwable) {
            void var2_5;
            if (var2_5 == false) {
                this.doClose();
            }
            throw throwable;
        }
    }

    @Override
    protected final void doFinishConnect() throws Exception {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    @Override
    protected final void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected final void doClose() throws Exception {
        try {
            super.doClose();
            return;
        }
        finally {
            this.javaChannel().close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int doReadBytes(ByteBuf byteBuf) throws Exception {
        void var2_2;
        void var1_1;
        RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
        allocHandle.attemptedBytesRead(byteBuf.writableBytes());
        return var1_1.writeBytes((ScatteringByteChannel)this.javaChannel(), var2_2.attemptedBytesRead());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int doWriteBytes(ByteBuf buf) throws Exception {
        void var2_2;
        void var1_1;
        int expectedWrittenBytes = buf.readableBytes();
        return var1_1.readBytes((GatheringByteChannel)this.javaChannel(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final long doWriteFileRegion(FileRegion region) throws Exception {
        void var2_2;
        void var1_1;
        long position = region.transferred();
        return var1_1.transferTo(this.javaChannel(), (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void adjustMaxBytesPerGatheringWrite(int attempted, int written, int oldMaxBytesPerGatheringWrite) {
        void var2_2;
        if (attempted == written) {
            void var3_3;
            if (attempted << 1 > var3_3) {
                ((NioDomainSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(attempted << 1);
                return;
            }
        } else if (attempted > 4096 && var2_2 < attempted >>> 1) {
            void var1_1;
            ((NioDomainSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite((int)(var1_1 >>> 1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doWrite(ChannelOutboundBuffer in) throws Exception {
        void var3_3;
        SocketChannel ch = this.javaChannel();
        int writeSpinCount = this.config().getWriteSpinCount();
        do {
            if (in.isEmpty()) {
                this.clearOpWrite();
                return;
            }
            int maxBytesPerGatheringWrite = ((NioDomainSocketChannelConfig)this.config).getMaxBytesPerGatheringWrite();
            ByteBuffer[] nioBuffers = in.nioBuffers(1024, maxBytesPerGatheringWrite);
            int nioBufferCnt = in.nioBufferCount();
            switch (nioBufferCnt) {
                case 0: {
                    writeSpinCount -= this.doWrite0(in);
                    break;
                }
                case 1: {
                    ByteBuffer buffer = nioBuffers[0];
                    int attemptedBytes = buffer.remaining();
                    int localWrittenBytes = ch.write(buffer);
                    if (localWrittenBytes <= 0) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite(attemptedBytes, localWrittenBytes, maxBytesPerGatheringWrite);
                    in.removeBytes(localWrittenBytes);
                    --writeSpinCount;
                    break;
                }
                default: {
                    long attemptedBytes = in.nioBufferSize();
                    long localWrittenBytes = ch.write(nioBuffers, 0, nioBufferCnt);
                    if (localWrittenBytes <= 0L) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite((int)attemptedBytes, (int)localWrittenBytes, maxBytesPerGatheringWrite);
                    in.removeBytes(localWrittenBytes);
                    --writeSpinCount;
                }
            }
        } while (writeSpinCount > 0);
        this.incompleteWrite(var3_3 < 0);
    }

    @Override
    protected final AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioSocketChannelUnsafe();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(NioDomainSocketChannel x0, ChannelPromise x1) {
        void var1_1;
        x0.shutdownInput0((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(NioDomainSocketChannel x0, ChannelFuture x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        x0.shutdownOutputDone((ChannelFuture)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(ChannelFuture x0, ChannelFuture x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        NioDomainSocketChannel.shutdownDone(x0, (ChannelFuture)var1_1, (ChannelPromise)var2_2);
    }

    private final class NioDomainSocketChannelConfig
    extends DefaultChannelConfig
    implements DuplexChannelConfig {
        private volatile boolean allowHalfClosure;
        private volatile int maxBytesPerGatheringWrite;
        private final SocketChannel javaChannel;

        /*
         * WARNING - void declaration
         */
        private NioDomainSocketChannelConfig(NioDomainSocketChannel channel, SocketChannel javaChannel) {
            void var3_3;
            void var2_2;
            super((Channel)var2_2);
            this.maxBytesPerGatheringWrite = Integer.MAX_VALUE;
            this.javaChannel = var3_3;
            this.calculateMaxBytesPerGatheringWrite();
        }

        @Override
        public final boolean isAllowHalfClosure() {
            return this.allowHalfClosure;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioDomainSocketChannelConfig setAllowHalfClosure(boolean allowHalfClosure) {
            void var1_1;
            this.allowHalfClosure = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Map<ChannelOption<?>, Object> getOptions() {
            void var1_1;
            ArrayList<ChannelOption> options = new ArrayList<ChannelOption>();
            options.add(ChannelOption.SO_RCVBUF);
            options.add(ChannelOption.SO_SNDBUF);
            for (ChannelOption opt : NioChannelOption.getOptions(this.jdkChannel())) {
                options.add(opt);
            }
            NioDomainSocketChannelConfig nioDomainSocketChannelConfig = this;
            return nioDomainSocketChannelConfig.getOptions(super.getOptions(), var1_1.toArray(new ChannelOption[0]));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T getOption(ChannelOption<T> option) {
            void var1_1;
            if (option == ChannelOption.SO_RCVBUF) {
                return (T)Integer.valueOf(this.getReceiveBufferSize());
            }
            if (option == ChannelOption.SO_SNDBUF) {
                return (T)Integer.valueOf(this.getSendBufferSize());
            }
            if (option instanceof NioChannelOption) {
                return NioChannelOption.getOption(this.jdkChannel(), (NioChannelOption)option);
            }
            return super.getOption(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> boolean setOption(ChannelOption<T> option, T value) {
            if (option == ChannelOption.SO_RCVBUF) {
                this.validate(option, value);
                this.setReceiveBufferSize((Integer)value);
            } else if (option == ChannelOption.SO_SNDBUF) {
                this.validate(option, value);
                this.setSendBufferSize((Integer)value);
            } else {
                void var2_2;
                void var1_1;
                if (option instanceof NioChannelOption) {
                    return NioChannelOption.setOption(this.jdkChannel(), (NioChannelOption)option, value);
                }
                return super.setOption(var1_1, var2_2);
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressJava6Requirement(reason="Usage guarded by java version check")
        private int getReceiveBufferSize() {
            try {
                return this.javaChannel.getOption(StandardSocketOptions.SO_RCVBUF);
            }
            catch (IOException e) {
                void var1_1;
                throw new ChannelException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @SuppressJava6Requirement(reason="Usage guarded by java version check")
        private NioDomainSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
            try {
                this.javaChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)receiveBufferSize);
            }
            catch (IOException e) {
                void var1_2;
                throw new ChannelException((Throwable)var1_2);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressJava6Requirement(reason="Usage guarded by java version check")
        private int getSendBufferSize() {
            try {
                return this.javaChannel.getOption(StandardSocketOptions.SO_SNDBUF);
            }
            catch (IOException e) {
                void var1_1;
                throw new ChannelException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @SuppressJava6Requirement(reason="Usage guarded by java version check")
        private NioDomainSocketChannelConfig setSendBufferSize(int sendBufferSize) {
            try {
                this.javaChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)sendBufferSize);
            }
            catch (IOException e) {
                void var1_2;
                throw new ChannelException((Throwable)var1_2);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioDomainSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
            void var1_1;
            super.setConnectTimeoutMillis((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        public final NioDomainSocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
            void var1_1;
            super.setMaxMessagesPerRead((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioDomainSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
            void var1_1;
            super.setWriteSpinCount((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioDomainSocketChannelConfig setAllocator(ByteBufAllocator allocator) {
            void var1_1;
            super.setAllocator((ByteBufAllocator)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioDomainSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
            void var1_1;
            super.setRecvByteBufAllocator((RecvByteBufAllocator)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioDomainSocketChannelConfig setAutoRead(boolean autoRead) {
            void var1_1;
            super.setAutoRead((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioDomainSocketChannelConfig setAutoClose(boolean autoClose) {
            void var1_1;
            super.setAutoClose((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioDomainSocketChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
            void var1_1;
            super.setWriteBufferHighWaterMark((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioDomainSocketChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
            void var1_1;
            super.setWriteBufferLowWaterMark((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioDomainSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
            void var1_1;
            super.setWriteBufferWaterMark((WriteBufferWaterMark)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NioDomainSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
            void var1_1;
            super.setMessageSizeEstimator((MessageSizeEstimator)var1_1);
            return this;
        }

        @Override
        protected final void autoReadCleared() {
            NioDomainSocketChannel.this.clearReadPending();
        }

        /*
         * WARNING - void declaration
         */
        final void setMaxBytesPerGatheringWrite(int maxBytesPerGatheringWrite) {
            void var1_1;
            this.maxBytesPerGatheringWrite = var1_1;
        }

        final int getMaxBytesPerGatheringWrite() {
            return this.maxBytesPerGatheringWrite;
        }

        /*
         * WARNING - void declaration
         */
        private void calculateMaxBytesPerGatheringWrite() {
            int newSendBufferSize = this.getSendBufferSize() << 1;
            if (newSendBufferSize > 0) {
                void var1_1;
                this.setMaxBytesPerGatheringWrite((int)var1_1);
            }
        }

        private SocketChannel jdkChannel() {
            return this.javaChannel;
        }
    }

    private final class NioSocketChannelUnsafe
    extends AbstractNioByteChannel.NioByteUnsafe {
        private NioSocketChannelUnsafe() {
            super(NioDomainSocketChannel.this);
        }
    }
}

