/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramChannelConfig;
import io.netty.channel.socket.DefaultDatagramChannelConfig;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Map;

class NioDatagramChannelConfig
extends DefaultDatagramChannelConfig {
    private static final Object IP_MULTICAST_TTL;
    private static final Object IP_MULTICAST_IF;
    private static final Object IP_MULTICAST_LOOP;
    private static final Method GET_OPTION;
    private static final Method SET_OPTION;
    private final java.nio.channels.DatagramChannel javaChannel;

    /*
     * WARNING - void declaration
     */
    NioDatagramChannelConfig(NioDatagramChannel channel, java.nio.channels.DatagramChannel javaChannel) {
        super((DatagramChannel)var1_1, javaChannel.socket());
        void var2_2;
        void var1_1;
        this.javaChannel = var2_2;
    }

    @Override
    public int getTimeToLive() {
        return (Integer)this.getOption0(IP_MULTICAST_TTL);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DatagramChannelConfig setTimeToLive(int ttl) {
        void var1_1;
        this.setOption0(IP_MULTICAST_TTL, (int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InetAddress getInterface() {
        Enumeration addresses;
        NetworkInterface inf = ((DefaultDatagramChannelConfig)this).getNetworkInterface();
        if (inf != null && (addresses = SocketUtils.addressesFromNetworkInterface((NetworkInterface)inf)).hasMoreElements()) {
            void var1_1;
            return (InetAddress)var1_1.nextElement();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DatagramChannelConfig setInterface(InetAddress interfaceAddress) {
        try {
            ((DefaultDatagramChannelConfig)this).setNetworkInterface(NetworkInterface.getByInetAddress(interfaceAddress));
        }
        catch (SocketException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
        return this;
    }

    @Override
    public NetworkInterface getNetworkInterface() {
        return (NetworkInterface)this.getOption0(IP_MULTICAST_IF);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DatagramChannelConfig setNetworkInterface(NetworkInterface networkInterface) {
        void var1_1;
        this.setOption0(IP_MULTICAST_IF, var1_1);
        return this;
    }

    @Override
    public boolean isLoopbackModeDisabled() {
        return (Boolean)this.getOption0(IP_MULTICAST_LOOP);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DatagramChannelConfig setLoopbackModeDisabled(boolean loopbackModeDisabled) {
        void var1_1;
        this.setOption0(IP_MULTICAST_LOOP, (boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DatagramChannelConfig setAutoRead(boolean autoRead) {
        void var1_1;
        super.setAutoRead((boolean)var1_1);
        return this;
    }

    @Override
    protected void autoReadCleared() {
        ((NioDatagramChannel)this.channel).clearReadPending0();
    }

    /*
     * WARNING - void declaration
     */
    private Object getOption0(Object option) {
        if (GET_OPTION == null) {
            throw new UnsupportedOperationException();
        }
        try {
            return GET_OPTION.invoke((Object)this.javaChannel, option);
        }
        catch (Exception e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setOption0(Object option, Object value) {
        if (SET_OPTION == null) {
            throw new UnsupportedOperationException();
        }
        try {
            void var2_3;
            SET_OPTION.invoke((Object)this.javaChannel, option, var2_3);
            return;
        }
        catch (Exception e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        void var2_2;
        void var1_1;
        if (PlatformDependent.javaVersion() >= 7 && option instanceof NioChannelOption) {
            return NioChannelOption.setOption(this.javaChannel, (NioChannelOption)option, value);
        }
        return super.setOption(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getOption(ChannelOption<T> option) {
        void var1_1;
        if (PlatformDependent.javaVersion() >= 7 && option instanceof NioChannelOption) {
            return NioChannelOption.getOption(this.javaChannel, (NioChannelOption)option);
        }
        return super.getOption(var1_1);
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        if (PlatformDependent.javaVersion() >= 7) {
            NioDatagramChannelConfig nioDatagramChannelConfig = this;
            return nioDatagramChannelConfig.getOptions(super.getOptions(), NioChannelOption.getOptions(this.javaChannel));
        }
        return super.getOptions();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_8;
        ClassLoader classLoader = PlatformDependent.getClassLoader(java.nio.channels.DatagramChannel.class);
        Class<?> socketOptionType = null;
        try {
            socketOptionType = Class.forName("java.net.SocketOption", true, classLoader);
        }
        catch (Exception exception) {}
        Class<?> stdSocketOptionType = null;
        try {
            stdSocketOptionType = Class.forName("java.net.StandardSocketOptions", true, classLoader);
        }
        catch (Exception exception) {}
        Object ipMulticastTtl = null;
        Object ipMulticastIf = null;
        Object ipMulticastLoop = null;
        Method getOption = null;
        Method setOption = null;
        if (socketOptionType != null) {
            try {
                ipMulticastTtl = stdSocketOptionType.getDeclaredField("IP_MULTICAST_TTL").get(null);
            }
            catch (Exception e) {
                throw new Error("cannot locate the IP_MULTICAST_TTL field", e);
            }
            try {
                ipMulticastIf = e.getDeclaredField("IP_MULTICAST_IF").get(null);
            }
            catch (Exception e) {
                throw new Error("cannot locate the IP_MULTICAST_IF field", e);
            }
            try {
                ipMulticastLoop = e.getDeclaredField("IP_MULTICAST_LOOP").get(null);
            }
            catch (Exception e) {
                throw new Error("cannot locate the IP_MULTICAST_LOOP field", e);
            }
            Class<?> networkChannelClass = null;
            try {
                networkChannelClass = Class.forName("java.nio.channels.NetworkChannel", true, classLoader);
            }
            catch (Throwable throwable) {}
            if (networkChannelClass == null) {
                getOption = null;
                setOption = null;
            } else {
                try {
                    getOption = networkChannelClass.getDeclaredMethod("getOption", socketOptionType);
                }
                catch (Exception e) {
                    throw new Error("cannot locate the getOption() method", e);
                }
                try {
                    void var1_3;
                    void var2_4;
                    setOption = var2_4.getDeclaredMethod("setOption", new Class[]{var1_3, Object.class});
                }
                catch (Exception e) {
                    void var0_2;
                    throw new Error("cannot locate the setOption() method", (Throwable)var0_2);
                }
            }
        }
        IP_MULTICAST_TTL = var3_8;
        IP_MULTICAST_IF = ipMulticastIf;
        IP_MULTICAST_LOOP = ipMulticastLoop;
        GET_OPTION = getOption;
        SET_OPTION = setOption;
    }
}

