/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioMessageChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramChannelConfig;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannelConfig;
import io.netty.channel.socket.nio.ProtocolFamilyConverter;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SuppressJava6Requirement;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.MembershipKey;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class NioDatagramChannel
extends AbstractNioMessageChannel
implements DatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true, 16);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(SocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private final DatagramChannelConfig config;
    private Map<InetAddress, List<MembershipKey>> memberships;

    /*
     * WARNING - void declaration
     */
    private static java.nio.channels.DatagramChannel newSocket(SelectorProvider provider) {
        try {
            return provider.openDatagramChannel();
        }
        catch (IOException e) {
            void var0_1;
            throw new ChannelException("Failed to open a socket.", (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private static java.nio.channels.DatagramChannel newSocket(SelectorProvider provider, InternetProtocolFamily ipFamily) {
        if (ipFamily == null) {
            return NioDatagramChannel.newSocket(provider);
        }
        NioDatagramChannel.checkJavaVersion();
        try {
            void var1_2;
            return provider.openDatagramChannel(ProtocolFamilyConverter.convert((InternetProtocolFamily)var1_2));
        }
        catch (IOException e) {
            void var0_1;
            throw new ChannelException("Failed to open a socket.", (Throwable)var0_1);
        }
    }

    private static void checkJavaVersion() {
        if (PlatformDependent.javaVersion() < 7) {
            throw new UnsupportedOperationException("Only supported on java 7+.");
        }
    }

    public NioDatagramChannel() {
        this(NioDatagramChannel.newSocket(DEFAULT_SELECTOR_PROVIDER));
    }

    /*
     * WARNING - void declaration
     */
    public NioDatagramChannel(SelectorProvider provider) {
        this(NioDatagramChannel.newSocket((SelectorProvider)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NioDatagramChannel(InternetProtocolFamily ipFamily) {
        this(NioDatagramChannel.newSocket(DEFAULT_SELECTOR_PROVIDER, (InternetProtocolFamily)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NioDatagramChannel(SelectorProvider provider, InternetProtocolFamily ipFamily) {
        this(NioDatagramChannel.newSocket((SelectorProvider)var1_1, (InternetProtocolFamily)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NioDatagramChannel(java.nio.channels.DatagramChannel socket) {
        super(null, socket, 1);
        void var1_1;
        this.config = new NioDatagramChannelConfig(this, (java.nio.channels.DatagramChannel)var1_1);
    }

    @Override
    public final ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public final DatagramChannelConfig config() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isActive() {
        void var1_1;
        java.nio.channels.DatagramChannel ch = this.javaChannel();
        return ch.isOpen() && (this.config.getOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) != false && this.isRegistered() || var1_1.socket().isBound());
    }

    @Override
    public final boolean isConnected() {
        return this.javaChannel().isConnected();
    }

    @Override
    protected final java.nio.channels.DatagramChannel javaChannel() {
        return (java.nio.channels.DatagramChannel)super.javaChannel();
    }

    @Override
    protected final SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    protected final SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        this.doBind0((SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void doBind0(SocketAddress localAddress) throws Exception {
        void var1_1;
        if (PlatformDependent.javaVersion() >= 7) {
            SocketUtils.bind((java.nio.channels.DatagramChannel)this.javaChannel(), (SocketAddress)localAddress);
            return;
        }
        this.javaChannel().socket().bind((SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (localAddress != null) {
            this.doBind0(localAddress);
        }
        boolean success = false;
        try {
            void var1_1;
            this.javaChannel().connect((SocketAddress)var1_1);
            success = true;
            return true;
        }
        catch (Throwable throwable) {
            void var2_4;
            if (var2_4 == false) {
                this.doClose();
            }
            throw throwable;
        }
    }

    @Override
    protected final void doFinishConnect() throws Exception {
        throw new Error();
    }

    @Override
    protected final void doDisconnect() throws Exception {
        this.javaChannel().disconnect();
    }

    @Override
    protected final void doClose() throws Exception {
        this.javaChannel().close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int doReadMessages(List<Object> buf) throws Exception {
        int pos;
        ByteBuffer nioData;
        boolean free;
        ByteBuf data;
        RecvByteBufAllocator.Handle allocHandle;
        block6: {
            java.nio.channels.DatagramChannel ch = this.javaChannel();
            DatagramChannelConfig config = this.config();
            allocHandle = this.unsafe().recvBufAllocHandle();
            data = allocHandle.allocate(config.getAllocator());
            allocHandle.attemptedBytesRead(data.writableBytes());
            free = true;
            ByteBuf byteBuf = data;
            nioData = byteBuf.internalNioBuffer(byteBuf.writerIndex(), data.writableBytes());
            pos = nioData.position();
            InetSocketAddress remoteAddress = (InetSocketAddress)ch.receive(nioData);
            if (remoteAddress != null) break block6;
            data.release();
            return 0;
        }
        try {
            void var2_3;
            void var1_1;
            allocHandle.lastBytesRead(nioData.position() - pos);
            ByteBuf byteBuf = data;
            var1_1.add(new DatagramPacket(byteBuf.writerIndex(byteBuf.writerIndex() + allocHandle.lastBytesRead()), this.localAddress(), (InetSocketAddress)var2_3));
            free = false;
            return 1;
        }
        catch (Throwable throwable) {
            block7: {
                try {
                    Throwable throwable2 = throwable;
                    PlatformDependent.throwException((Throwable)throwable);
                    if (!free) break block7;
                }
                catch (Throwable throwable3) {
                    if (free) {
                        void var3_4;
                        var3_4.release();
                    }
                    throw throwable3;
                }
                data.release();
            }
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean doWriteMessage(Object msg, ChannelOutboundBuffer in) throws Exception {
        void var1_2;
        void var2_3;
        ByteBuffer byteBuffer;
        ByteBuf data;
        SocketAddress remoteAddress;
        if (msg instanceof AddressedEnvelope) {
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            remoteAddress = (SocketAddress)envelope.recipient();
            data = (ByteBuf)envelope.content();
        } else {
            data = (ByteBuf)remoteAddress;
            remoteAddress = null;
        }
        int dataLen = data.readableBytes();
        if (dataLen == 0) {
            return true;
        }
        if (data.nioBufferCount() == 1) {
            ByteBuf byteBuf = data;
            byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), dataLen);
        } else {
            void var3_5;
            ByteBuf byteBuf = data;
            byteBuffer = byteBuf.nioBuffer(byteBuf.readerIndex(), (int)var3_5);
        }
        ByteBuffer nioData = byteBuffer;
        int writtenBytes = remoteAddress != null ? this.javaChannel().send(nioData, remoteAddress) : this.javaChannel().write((ByteBuffer)var2_3);
        return var1_2 > 0;
    }

    private static void checkUnresolved(AddressedEnvelope<?, ?> envelope) {
        AddressedEnvelope<?, ?> addressedEnvelope;
        if (envelope.recipient() instanceof InetSocketAddress && ((InetSocketAddress)addressedEnvelope.recipient()).isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final Object filterOutboundMessage(Object msg) {
        void var1_1;
        ByteBuf content;
        if (msg instanceof DatagramPacket) {
            DatagramPacket p = (DatagramPacket)msg;
            NioDatagramChannel.checkUnresolved(p);
            content = (ByteBuf)p.content();
            if (NioDatagramChannel.isSingleDirectBuffer(content)) {
                return p;
            }
            return new DatagramPacket(this.newDirectBuffer(p, content), (InetSocketAddress)p.recipient());
        }
        if (content instanceof ByteBuf) {
            ByteBuf buf = content;
            if (NioDatagramChannel.isSingleDirectBuffer(buf)) {
                return buf;
            }
            return this.newDirectBuffer(buf);
        }
        if (content instanceof AddressedEnvelope) {
            AddressedEnvelope e = (AddressedEnvelope)content;
            NioDatagramChannel.checkUnresolved(e);
            if (e.content() instanceof ByteBuf) {
                void var2_4;
                content = (ByteBuf)e.content();
                if (NioDatagramChannel.isSingleDirectBuffer(content)) {
                    return e;
                }
                return new DefaultAddressedEnvelope(this.newDirectBuffer(e, (ByteBuf)var1_1), var2_4.recipient());
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)var1_1) + EXPECTED_TYPES);
    }

    private static boolean isSingleDirectBuffer(ByteBuf buf) {
        ByteBuf byteBuf;
        return buf.isDirect() && byteBuf.nioBufferCount() == 1;
    }

    @Override
    protected final boolean continueOnWriteError() {
        return true;
    }

    @Override
    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture joinGroup(InetAddress multicastAddress) {
        void var1_1;
        return this.joinGroup((InetAddress)var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture joinGroup(InetAddress multicastAddress, ChannelPromise promise) {
        try {
            void var1_1;
            NetworkInterface iface = this.config.getNetworkInterface();
            if (iface == null) {
                iface = NetworkInterface.getByInetAddress(this.localAddress().getAddress());
            }
            return this.joinGroup((InetAddress)var1_1, iface, null, promise);
        }
        catch (SocketException e) {
            void var2_2;
            void var3_4;
            promise.setFailure((Throwable)var3_4);
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        void var2_2;
        void var1_1;
        return this.joinGroup((InetSocketAddress)var1_1, (NetworkInterface)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.joinGroup(var1_1.getAddress(), (NetworkInterface)var2_2, null, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.joinGroup((InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public final ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        NioDatagramChannel.checkJavaVersion();
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        try {
            NioDatagramChannel nioDatagramChannel;
            MembershipKey key;
            key = source == null ? this.javaChannel().join(multicastAddress, networkInterface) : this.javaChannel().join(multicastAddress, (NetworkInterface)((Object)key), (InetAddress)((Object)nioDatagramChannel));
            nioDatagramChannel = this;
            synchronized (nioDatagramChannel) {
                List<MembershipKey> keys = null;
                if (this.memberships == null) {
                    this.memberships = new HashMap<InetAddress, List<MembershipKey>>();
                } else {
                    keys = this.memberships.get(multicastAddress);
                }
                if (keys == null) {
                    void var1_1;
                    keys = new ArrayList<MembershipKey>();
                    this.memberships.put((InetAddress)var1_1, keys);
                }
                keys.add(key);
            }
            promise.setSuccess();
        }
        catch (Throwable e) {
            void var2_4;
            promise.setFailure((Throwable)var2_4);
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture leaveGroup(InetAddress multicastAddress) {
        void var1_1;
        return this.leaveGroup((InetAddress)var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture leaveGroup(InetAddress multicastAddress, ChannelPromise promise) {
        try {
            return this.leaveGroup(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, promise);
        }
        catch (SocketException e) {
            void var2_3;
            void var1_2;
            promise.setFailure((Throwable)var1_2);
            return var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        void var2_2;
        void var1_1;
        return this.leaveGroup((InetSocketAddress)var1_1, (NetworkInterface)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.leaveGroup(var1_1.getAddress(), (NetworkInterface)var2_2, null, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.leaveGroup((InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public final ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        NioDatagramChannel.checkJavaVersion();
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        NioDatagramChannel nioDatagramChannel = this;
        synchronized (nioDatagramChannel) {
            List<MembershipKey> keys;
            if (this.memberships != null && (keys = this.memberships.get(multicastAddress)) != null) {
                Iterator<MembershipKey> keyIt = keys.iterator();
                while (keyIt.hasNext()) {
                    MembershipKey key = keyIt.next();
                    if (!networkInterface.equals(key.networkInterface()) || (source != null || key.sourceAddress() != null) && (source == null || !source.equals(key.sourceAddress()))) continue;
                    key.drop();
                    keyIt.remove();
                }
                if (keys.isEmpty()) {
                    void var1_1;
                    this.memberships.remove(var1_1);
                }
            }
        }
        promise.setSuccess();
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.block((InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, this.newPromise());
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public final ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock, ChannelPromise promise) {
        NioDatagramChannel.checkJavaVersion();
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)sourceToBlock, (String)"sourceToBlock");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        NioDatagramChannel nioDatagramChannel = this;
        synchronized (nioDatagramChannel) {
            if (this.memberships != null) {
                Object object;
                object = this.memberships.get(object);
                object = object.iterator();
                while (object.hasNext()) {
                    MembershipKey key = (MembershipKey)object.next();
                    if (!networkInterface.equals(key.networkInterface())) continue;
                    try {
                        key.block(sourceToBlock);
                    }
                    catch (IOException e) {
                        promise.setFailure(e);
                    }
                }
            }
        }
        promise.setSuccess();
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock) {
        void var2_2;
        void var1_1;
        return this.block((InetAddress)var1_1, (InetAddress)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock, ChannelPromise promise) {
        try {
            void var2_3;
            return this.block(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), (InetAddress)var2_3, promise);
        }
        catch (SocketException e) {
            void var3_4;
            void var1_2;
            promise.setFailure((Throwable)var1_2);
            return var3_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    protected final void setReadPending(boolean readPending) {
        void var1_1;
        super.setReadPending((boolean)var1_1);
    }

    final void clearReadPending0() {
        this.clearReadPending();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean closeOnReadError(Throwable cause) {
        void var1_1;
        if (cause instanceof SocketException) {
            return false;
        }
        return super.closeOnReadError((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean continueReading(RecvByteBufAllocator.Handle allocHandle) {
        void var1_1;
        if (allocHandle instanceof RecvByteBufAllocator.ExtendedHandle) {
            return ((RecvByteBufAllocator.ExtendedHandle)allocHandle).continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER);
        }
        return var1_1.continueReading();
    }
}

