/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.util.internal.SuppressJava6Requirement;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.Channel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

@SuppressJava6Requirement(reason="Usage explicit by the user")
public final class NioChannelOption<T>
extends ChannelOption<T> {
    private final SocketOption<T> option;

    /*
     * WARNING - void declaration
     */
    private NioChannelOption(SocketOption<T> option) {
        super(option.name());
        void var1_1;
        this.option = var1_1;
    }

    public static <T> ChannelOption<T> of(SocketOption<T> option) {
        SocketOption<T> socketOption;
        return new NioChannelOption<T>(socketOption);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    static <T> boolean setOption(Channel jdkChannel, NioChannelOption<T> option, T value) {
        Channel channel = (NetworkChannel)jdkChannel;
        if (!channel.supportedOptions().contains(option.option)) {
            return false;
        }
        if (channel instanceof ServerSocketChannel && option.option == StandardSocketOptions.IP_TOS) {
            return false;
        }
        try {
            void var2_3;
            void var1_2;
            channel.setOption(var1_2.option, var2_3);
            return true;
        }
        catch (IOException e) {
            void var0_1;
            throw new ChannelException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    static <T> T getOption(Channel jdkChannel, NioChannelOption<T> option) {
        Channel channel = (NetworkChannel)jdkChannel;
        if (!channel.supportedOptions().contains(option.option)) {
            return null;
        }
        if (channel instanceof ServerSocketChannel && option.option == StandardSocketOptions.IP_TOS) {
            return null;
        }
        try {
            void var1_2;
            return channel.getOption(var1_2.option);
        }
        catch (IOException e) {
            void var0_1;
            throw new ChannelException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    static ChannelOption[] getOptions(Channel jdkChannel) {
        ChannelOption[] channelOptionArray;
        Iterator iterator;
        ChannelOption[] extraOpts;
        ChannelOption[] channel = (NetworkChannel)jdkChannel;
        Set<SocketOption<?>> supportedOpts = channel.supportedOptions();
        if (channel instanceof ServerSocketChannel) {
            extraOpts = new ArrayList(supportedOpts.size());
            for (SocketOption<?> opt : supportedOpts) {
                if (opt == StandardSocketOptions.IP_TOS) continue;
                extraOpts.add(new NioChannelOption(iterator));
            }
            return extraOpts.toArray(new ChannelOption[0]);
        }
        extraOpts = new ChannelOption[iterator.size()];
        int i = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            SocketOption opt = (SocketOption)iterator.next();
            extraOpts[i++] = new NioChannelOption(var3_4);
        }
        return channelOptionArray;
    }
}

