/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket;

import io.netty.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;

public enum InternetProtocolFamily {
    IPv4(Inet4Address.class, 1),
    IPv6(Inet6Address.class, 2);

    private final Class<? extends InetAddress> addressType;
    private final int addressNumber;

    /*
     * WARNING - void declaration
     */
    private InternetProtocolFamily(Class<? extends InetAddress> addressType, int addressNumber) {
        void var3_3;
        this.addressType = var3_3;
        this.addressNumber = addressNumber;
    }

    public final Class<? extends InetAddress> addressType() {
        return this.addressType;
    }

    public final int addressNumber() {
        return this.addressNumber;
    }

    public final InetAddress localhost() {
        switch (this) {
            case IPv4: {
                return NetUtil.LOCALHOST4;
            }
            case IPv6: {
                return NetUtil.LOCALHOST6;
            }
        }
        throw new IllegalStateException("Unsupported family " + (Object)((Object)this));
    }

    public static InternetProtocolFamily of(InetAddress address) {
        InetAddress inetAddress;
        if (address instanceof Inet4Address) {
            return IPv4;
        }
        if (address instanceof Inet6Address) {
            return IPv6;
        }
        throw new IllegalArgumentException("address " + inetAddress + " not supported");
    }
}

