/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ServerChannelRecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.ServerSocketChannelConfig;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Map;

public class DefaultServerSocketChannelConfig
extends DefaultChannelConfig
implements ServerSocketChannelConfig {
    protected final ServerSocket javaSocket;
    private volatile int backlog = NetUtil.SOMAXCONN;

    /*
     * WARNING - void declaration
     */
    public DefaultServerSocketChannelConfig(ServerSocketChannel channel, ServerSocket javaSocket) {
        super((Channel)var1_1, new ServerChannelRecvByteBufAllocator());
        void var2_2;
        void var1_1;
        this.javaSocket = (ServerSocket)ObjectUtil.checkNotNull((Object)var2_2, (String)"javaSocket");
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        DefaultServerSocketChannelConfig defaultServerSocketChannelConfig = this;
        return defaultServerSocketChannelConfig.getOptions(super.getOptions(), ChannelOption.SO_RCVBUF, ChannelOption.SO_REUSEADDR, ChannelOption.SO_BACKLOG);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getOption(ChannelOption<T> option) {
        void var1_1;
        if (option == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (option == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (option == ChannelOption.SO_BACKLOG) {
            return (T)Integer.valueOf(this.getBacklog());
        }
        return super.getOption(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)value);
        } else if (option == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)value);
        } else if (option == ChannelOption.SO_BACKLOG) {
            this.setBacklog((Integer)value);
        } else {
            void var2_2;
            void var1_1;
            return super.setOption(var1_1, var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isReuseAddress() {
        try {
            return this.javaSocket.getReuseAddress();
        }
        catch (SocketException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setReuseAddress(boolean reuseAddress) {
        try {
            this.javaSocket.setReuseAddress(reuseAddress);
        }
        catch (SocketException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getReceiveBufferSize() {
        try {
            return this.javaSocket.getReceiveBufferSize();
        }
        catch (SocketException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.javaSocket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (SocketException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.javaSocket.setPerformancePreferences((int)var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    @Override
    public int getBacklog() {
        return this.backlog;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setBacklog(int backlog) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)backlog, (String)"backlog");
        this.backlog = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        void var1_1;
        super.setConnectTimeoutMillis((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public ServerSocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        void var1_1;
        super.setMaxMessagesPerRead((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        void var1_1;
        super.setWriteSpinCount((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setAllocator(ByteBufAllocator allocator) {
        void var1_1;
        super.setAllocator((ByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        void var1_1;
        super.setRecvByteBufAllocator((RecvByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setAutoRead(boolean autoRead) {
        void var1_1;
        super.setAutoRead((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        void var1_1;
        super.setWriteBufferHighWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        void var1_1;
        super.setWriteBufferLowWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        void var1_1;
        super.setWriteBufferWaterMark((WriteBufferWaterMark)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        void var1_1;
        super.setMessageSizeEstimator((MessageSizeEstimator)var1_1);
        return this;
    }
}

