/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Deque;
import java.util.concurrent.Callable;

public class SimpleChannelPool
implements ChannelPool {
    private static final AttributeKey<SimpleChannelPool> POOL_KEY = AttributeKey.newInstance((String)"io.netty.channel.pool.SimpleChannelPool");
    private final Deque<Channel> deque = PlatformDependent.newConcurrentDeque();
    private final ChannelPoolHandler handler;
    private final ChannelHealthChecker healthCheck;
    private final Bootstrap bootstrap;
    private final boolean releaseHealthCheck;
    private final boolean lastRecentUsed;

    /*
     * WARNING - void declaration
     */
    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler) {
        this((Bootstrap)var1_1, (ChannelPoolHandler)var2_2, ChannelHealthChecker.ACTIVE);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck) {
        this((Bootstrap)var1_1, (ChannelPoolHandler)var2_2, (ChannelHealthChecker)var3_3, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck, boolean releaseHealthCheck) {
        this((Bootstrap)var1_1, (ChannelPoolHandler)var2_2, (ChannelHealthChecker)var3_3, releaseHealthCheck, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck, boolean releaseHealthCheck, boolean lastRecentUsed) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.handler = (ChannelPoolHandler)ObjectUtil.checkNotNull((Object)handler, (String)"handler");
        this.healthCheck = (ChannelHealthChecker)ObjectUtil.checkNotNull((Object)var3_3, (String)"healthCheck");
        this.releaseHealthCheck = releaseHealthCheck;
        this.bootstrap = ((Bootstrap)ObjectUtil.checkNotNull((Object)var1_1, (String)"bootstrap")).clone();
        this.bootstrap.handler(new ChannelInitializer<Channel>(this, (ChannelPoolHandler)var2_2){
            final /* synthetic */ ChannelPoolHandler val$handler;
            final /* synthetic */ SimpleChannelPool this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$handler = channelPoolHandler;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void initChannel(Channel ch) throws Exception {
                void var1_1;
                assert (ch.eventLoop().inEventLoop());
                this.val$handler.channelCreated((Channel)var1_1);
            }
        });
        this.lastRecentUsed = lastRecentUsed;
    }

    protected Bootstrap bootstrap() {
        return this.bootstrap;
    }

    protected ChannelPoolHandler handler() {
        return this.handler;
    }

    protected ChannelHealthChecker healthChecker() {
        return this.healthCheck;
    }

    protected boolean releaseHealthCheck() {
        return this.releaseHealthCheck;
    }

    @Override
    public final Future<Channel> acquire() {
        SimpleChannelPool simpleChannelPool = this;
        return simpleChannelPool.acquire((Promise<Channel>)simpleChannelPool.bootstrap.config().group().next().newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future<Channel> acquire(Promise<Channel> promise) {
        void var1_1;
        return this.acquireHealthyFromPoolOrNew((Promise<Channel>)((Promise)ObjectUtil.checkNotNull((Object)var1_1, (String)"promise")));
    }

    /*
     * WARNING - void declaration
     */
    private Future<Channel> acquireHealthyFromPoolOrNew(Promise<Channel> promise) {
        void var1_1;
        try {
            ChannelFuture f;
            Channel ch = this.pollChannel();
            if (ch == null) {
                Bootstrap bs = this.bootstrap.clone();
                bs.attr(POOL_KEY, this);
                f = this.connectChannel(bs);
                if (f.isDone()) {
                    this.notifyConnect(f, promise);
                } else {
                    f.addListener(new ChannelFutureListener(this, promise){
                        final /* synthetic */ Promise val$promise;
                        final /* synthetic */ SimpleChannelPool this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$promise = promise;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void operationComplete(ChannelFuture future) throws Exception {
                            void var1_1;
                            SimpleChannelPool.access$000(this.this$0, (ChannelFuture)var1_1, this.val$promise);
                        }
                    });
                }
            } else {
                EventLoop loop = f.eventLoop();
                if (loop.inEventLoop()) {
                    this.doHealthCheck((Channel)((Object)f), promise);
                } else {
                    void var3_5;
                    var3_5.execute(new Runnable(this, (Channel)((Object)f), promise){
                        final /* synthetic */ Channel val$ch;
                        final /* synthetic */ Promise val$promise;
                        final /* synthetic */ SimpleChannelPool this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$ch = channel;
                            this.val$promise = promise;
                        }

                        @Override
                        public void run() {
                            SimpleChannelPool.access$100(this.this$0, this.val$ch, this.val$promise);
                        }
                    });
                }
            }
        }
        catch (Throwable cause) {
            void var2_3;
            promise.tryFailure((Throwable)var2_3);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void notifyConnect(ChannelFuture future, Promise<Channel> promise) {
        Channel channel = null;
        try {
            block4: {
                block3: {
                    block2: {
                        if (!future.isSuccess()) break block2;
                        channel = future.channel();
                        this.handler.channelAcquired(channel);
                        if (promise.trySuccess((Object)channel)) break block3;
                        break block4;
                    }
                    promise.tryFailure(future.cause());
                }
                return;
            }
            this.release(channel);
        }
        catch (Throwable cause) {
            void var2_3;
            void var1_2;
            void var3_4;
            this.closeAndFail((Channel)var3_4, (Throwable)var1_2, (Promise<?>)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doHealthCheck(Channel channel, Promise<Channel> promise) {
        try {
            assert (channel.eventLoop().inEventLoop());
            Future<Boolean> f = this.healthCheck.isHealthy(channel);
            if (!f.isDone()) {
                f.addListener((GenericFutureListener)new FutureListener<Boolean>(this, channel, promise){
                    final /* synthetic */ Channel val$channel;
                    final /* synthetic */ Promise val$promise;
                    final /* synthetic */ SimpleChannelPool this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$channel = channel;
                        this.val$promise = promise;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void operationComplete(Future<Boolean> future) {
                        void var1_1;
                        SimpleChannelPool.access$200(this.this$0, (Future)var1_1, this.val$channel, this.val$promise);
                    }
                });
                return;
            }
            this.notifyHealthCheck(f, channel, promise);
        }
        catch (Throwable cause) {
            void var2_2;
            void var3_4;
            void var1_1;
            this.closeAndFail((Channel)var1_1, (Throwable)var3_4, (Promise<?>)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyHealthCheck(Future<Boolean> future, Channel channel, Promise<Channel> promise) {
        try {
            assert (channel.eventLoop().inEventLoop());
            if (!future.isSuccess() || !((Boolean)future.getNow()).booleanValue()) {
                this.closeChannel(channel);
                this.acquireHealthyFromPoolOrNew(promise);
                return;
            }
            channel.attr(POOL_KEY).set((Object)this);
            this.handler.channelAcquired(channel);
            promise.setSuccess((Object)channel);
        }
        catch (Throwable cause) {
            void var3_4;
            void var1_2;
            void var2_3;
            this.closeAndFail((Channel)var2_3, (Throwable)var1_2, (Promise<?>)var3_4);
        }
    }

    protected ChannelFuture connectChannel(Bootstrap bs) {
        return bs.connect();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Future<Void> release(Channel channel) {
        void var1_1;
        void v0 = var1_1;
        return this.release((Channel)v0, (Promise<Void>)v0.eventLoop().newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future<Void> release(Channel channel, Promise<Void> promise) {
        void var2_2;
        try {
            ObjectUtil.checkNotNull((Object)channel, (String)"channel");
            ObjectUtil.checkNotNull(promise, (String)"promise");
            EventLoop loop = channel.eventLoop();
            if (loop.inEventLoop()) {
                this.doReleaseChannel(channel, promise);
            } else {
                loop.execute(new Runnable(this, channel, promise){
                    final /* synthetic */ Channel val$channel;
                    final /* synthetic */ Promise val$promise;
                    final /* synthetic */ SimpleChannelPool this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$channel = channel;
                        this.val$promise = promise;
                    }

                    @Override
                    public void run() {
                        SimpleChannelPool.access$300(this.this$0, this.val$channel, this.val$promise);
                    }
                });
            }
        }
        catch (Throwable cause) {
            void var3_4;
            void var1_1;
            this.closeAndFail((Channel)var1_1, (Throwable)var3_4, promise);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void doReleaseChannel(Channel channel, Promise<Void> promise) {
        block5: {
            try {
                assert (channel.eventLoop().inEventLoop());
                if (channel.attr(POOL_KEY).getAndSet(null) != this) {
                    this.closeAndFail(channel, new IllegalArgumentException("Channel " + channel + " was not acquired from this ChannelPool"), promise);
                    break block5;
                }
                if (this.releaseHealthCheck) {
                    this.doHealthCheckOnRelease(channel, promise);
                    break block5;
                }
                this.releaseAndOffer(channel, promise);
                return;
            }
            catch (Throwable cause) {
                void var2_2;
                void var3_3;
                void var1_1;
                this.closeAndFail((Channel)var1_1, (Throwable)var3_3, (Promise<?>)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doHealthCheckOnRelease(Channel channel, Promise<Void> promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        Future<Boolean> f = this.healthCheck.isHealthy(channel);
        if (f.isDone()) {
            this.releaseAndOfferIfHealthy(channel, promise, f);
            return;
        }
        f.addListener((GenericFutureListener)new FutureListener<Boolean>(this, (Channel)var1_1, (Promise)var2_2, (Future)var3_3){
            final /* synthetic */ Channel val$channel;
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ Future val$f;
            final /* synthetic */ SimpleChannelPool this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$channel = channel;
                this.val$promise = promise;
                this.val$f = future;
            }

            public void operationComplete(Future<Boolean> future) throws Exception {
                SimpleChannelPool.access$400(this.this$0, this.val$channel, this.val$promise, this.val$f);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void releaseAndOfferIfHealthy(Channel channel, Promise<Void> promise, Future<Boolean> future) {
        try {
            if (!((Boolean)future.getNow()).booleanValue()) {
                this.handler.channelReleased(channel);
                promise.setSuccess(null);
                return;
            }
            this.releaseAndOffer(channel, promise);
        }
        catch (Throwable cause) {
            void var2_2;
            void var3_4;
            void var1_1;
            this.closeAndFail((Channel)var1_1, (Throwable)var3_4, (Promise<?>)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void releaseAndOffer(Channel channel, Promise<Void> promise) throws Exception {
        void var2_2;
        void var1_1;
        if (this.offerChannel(channel)) {
            this.handler.channelReleased(channel);
            promise.setSuccess(null);
            return;
        }
        this.closeAndFail((Channel)var1_1, new ChannelPoolFullException(), (Promise<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void closeChannel(Channel channel) throws Exception {
        void var1_1;
        channel.attr(POOL_KEY).getAndSet(null);
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    private void closeAndFail(Channel channel, Throwable cause, Promise<?> promise) {
        void var2_3;
        void var3_4;
        if (channel != null) {
            try {
                this.closeChannel(channel);
            }
            catch (Throwable t) {
                void var1_2;
                promise.tryFailure((Throwable)var1_2);
            }
        }
        var3_4.tryFailure((Throwable)var2_3);
    }

    protected Channel pollChannel() {
        if (this.lastRecentUsed) {
            return this.deque.pollLast();
        }
        return this.deque.pollFirst();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean offerChannel(Channel channel) {
        void var1_1;
        return this.deque.offer((Channel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        Channel channel;
        while ((channel = this.pollChannel()) != null) {
            void var1_1;
            var1_1.close().awaitUninterruptibly();
        }
    }

    public Future<Void> closeAsync() {
        return GlobalEventExecutor.INSTANCE.submit((Callable)new Callable<Void>(this){
            final /* synthetic */ SimpleChannelPool this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public Void call() throws Exception {
                this.this$0.close();
                return null;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(SimpleChannelPool x0, ChannelFuture x1, Promise x2) {
        void var2_2;
        void var1_1;
        x0.notifyConnect((ChannelFuture)var1_1, (Promise<Channel>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(SimpleChannelPool x0, Channel x1, Promise x2) {
        void var2_2;
        void var1_1;
        x0.doHealthCheck((Channel)var1_1, (Promise<Channel>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(SimpleChannelPool x0, Future x1, Channel x2, Promise x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.notifyHealthCheck((Future<Boolean>)var1_1, (Channel)var2_2, (Promise<Channel>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(SimpleChannelPool x0, Channel x1, Promise x2) {
        void var2_2;
        void var1_1;
        x0.doReleaseChannel((Channel)var1_1, (Promise<Void>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(SimpleChannelPool x0, Channel x1, Promise x2, Future x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.releaseAndOfferIfHealthy((Channel)var1_1, (Promise<Void>)var2_2, (Future<Boolean>)var3_3);
    }

    private static final class ChannelPoolFullException
    extends IllegalStateException {
        private ChannelPoolFullException() {
            super("ChannelPool full");
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }
}

