/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class FixedChannelPool
extends SimpleChannelPool {
    private final EventExecutor executor;
    private final long acquireTimeoutNanos;
    private final Runnable timeoutTask;
    private final Queue<AcquireTask> pendingAcquireQueue = new ArrayDeque<AcquireTask>();
    private final int maxConnections;
    private final int maxPendingAcquires;
    private final AtomicInteger acquiredChannelCount = new AtomicInteger();
    private int pendingAcquireCount;
    private boolean closed;

    /*
     * WARNING - void declaration
     */
    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, int maxConnections) {
        this((Bootstrap)var1_1, (ChannelPoolHandler)var2_2, (int)var3_3, Integer.MAX_VALUE);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, int maxConnections, int maxPendingAcquires) {
        this((Bootstrap)var1_1, (ChannelPoolHandler)var2_2, ChannelHealthChecker.ACTIVE, null, -1L, (int)var3_3, maxPendingAcquires);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck, AcquireTimeoutAction action, long acquireTimeoutMillis, int maxConnections, int maxPendingAcquires) {
        this((Bootstrap)var1_1, (ChannelPoolHandler)var2_2, (ChannelHealthChecker)var3_3, action, acquireTimeoutMillis, maxConnections, maxPendingAcquires, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck, AcquireTimeoutAction action, long acquireTimeoutMillis, int maxConnections, int maxPendingAcquires, boolean releaseHealthCheck) {
        this((Bootstrap)var1_1, (ChannelPoolHandler)var2_2, (ChannelHealthChecker)var3_3, action, acquireTimeoutMillis, maxConnections, maxPendingAcquires, releaseHealthCheck, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck, AcquireTimeoutAction action, long acquireTimeoutMillis, int maxConnections, int maxPendingAcquires, boolean releaseHealthCheck, boolean lastRecentUsed) {
        super(bootstrap, (ChannelPoolHandler)var2_2, (ChannelHealthChecker)var3_3, releaseHealthCheck, lastRecentUsed);
        void var1_1;
        void var3_3;
        void var2_2;
        ObjectUtil.checkPositive((int)maxConnections, (String)"maxConnections");
        ObjectUtil.checkPositive((int)maxPendingAcquires, (String)"maxPendingAcquires");
        if (action == null && acquireTimeoutMillis == -1L) {
            this.timeoutTask = null;
            this.acquireTimeoutNanos = -1L;
        } else {
            if (action == null && acquireTimeoutMillis != -1L) {
                throw new NullPointerException("action");
            }
            if (action != null && acquireTimeoutMillis < 0L) {
                throw new IllegalArgumentException("acquireTimeoutMillis: " + acquireTimeoutMillis + " (expected: >= 0)");
            }
            this.acquireTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(acquireTimeoutMillis);
            switch (action) {
                case FAIL: {
                    this.timeoutTask = new TimeoutTask(){
                        {
                            void var1_1;
                        }

                        @Override
                        public void onTimeout(AcquireTask task) {
                            task.promise.setFailure((Throwable)new AcquireTimeoutException());
                        }
                    };
                    break;
                }
                case NEW: {
                    this.timeoutTask = new TimeoutTask(){
                        {
                            void var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public void onTimeout(AcquireTask task) {
                            void var1_1;
                            task.acquired();
                            FixedChannelPool.access$201(FixedChannelPool.this, var1_1.promise);
                        }
                    };
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        this.executor = var1_1.config().group().next();
        this.maxConnections = maxConnections;
        this.maxPendingAcquires = maxPendingAcquires;
    }

    public int acquiredChannelCount() {
        return this.acquiredChannelCount.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future<Channel> acquire(Promise<Channel> promise) {
        void var1_1;
        try {
            if (this.executor.inEventLoop()) {
                this.acquire0(promise);
            } else {
                this.executor.execute(new Runnable(this, promise){
                    final /* synthetic */ Promise val$promise;
                    final /* synthetic */ FixedChannelPool this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$promise = promise;
                    }

                    @Override
                    public void run() {
                        FixedChannelPool.access$300(this.this$0, this.val$promise);
                    }
                });
            }
        }
        catch (Throwable cause) {
            void var2_2;
            promise.tryFailure((Throwable)var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void acquire0(Promise<Channel> promise) {
        try {
            void var3_5;
            assert (this.executor.inEventLoop());
            if (this.closed) {
                promise.setFailure((Throwable)new IllegalStateException("FixedChannelPool was closed"));
                return;
            }
            if (this.acquiredChannelCount.get() < this.maxConnections) {
                assert (this.acquiredChannelCount.get() >= 0);
            } else {
                AcquireTask task;
                if (this.pendingAcquireCount < this.maxPendingAcquires && this.pendingAcquireQueue.offer(task = new AcquireTask(promise))) {
                    ++this.pendingAcquireCount;
                    if (this.timeoutTask != null) {
                        task.timeoutFuture = this.executor.schedule(this.timeoutTask, this.acquireTimeoutNanos, TimeUnit.NANOSECONDS);
                    }
                } else {
                    this.tooManyOutstanding(promise);
                }
                assert (this.pendingAcquireCount > 0);
                return;
            }
            Promise p = this.executor.newPromise();
            AcquireListener l = new AcquireListener(promise);
            l.acquired();
            p.addListener((GenericFutureListener)var3_5);
            super.acquire((Promise<Channel>)p);
        }
        catch (Throwable cause) {
            void var2_4;
            void var1_1;
            var1_1.tryFailure((Throwable)var2_4);
        }
    }

    private void tooManyOutstanding(Promise<?> promise) {
        promise.setFailure((Throwable)new IllegalStateException("Too many outstanding acquire operations"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future<Void> release(Channel channel, Promise<Void> promise) {
        void var2_2;
        void var1_1;
        void var3_3;
        ObjectUtil.checkNotNull(promise, (String)"promise");
        Promise p = this.executor.newPromise();
        super.release(channel, (Promise<Void>)var3_3.addListener((GenericFutureListener)new FutureListener<Void>(this, (Channel)var1_1, promise){
            final /* synthetic */ Channel val$channel;
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ FixedChannelPool this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$channel = channel;
                this.val$promise = promise;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(Future<Void> future) {
                try {
                    assert (this.this$0.executor.inEventLoop());
                    if (this.this$0.closed) {
                        this.val$channel.close();
                        this.val$promise.setFailure((Throwable)new IllegalStateException("FixedChannelPool was closed"));
                        return;
                    }
                    if (!future.isSuccess()) {
                        void var1_1;
                        Throwable throwable = future.cause();
                        if (!(throwable instanceof IllegalArgumentException)) {
                            this.this$0.decrementAndRunTaskQueue();
                        }
                        this.val$promise.setFailure(var1_1.cause());
                        return;
                    }
                    this.this$0.decrementAndRunTaskQueue();
                    this.val$promise.setSuccess(null);
                }
                catch (Throwable cause) {
                    void var2_3;
                    this.val$promise.tryFailure((Throwable)var2_3);
                }
            }
        }));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void decrementAndRunTaskQueue() {
        void var1_1;
        int currentCount = this.acquiredChannelCount.decrementAndGet();
        assert (var1_1 >= 0);
        this.runTaskQueue();
    }

    /*
     * WARNING - void declaration
     */
    private void runTaskQueue() {
        AcquireTask task;
        while (this.acquiredChannelCount.get() < this.maxConnections && (task = this.pendingAcquireQueue.poll()) != null) {
            void var1_1;
            ScheduledFuture<?> timeoutFuture = task.timeoutFuture;
            if (timeoutFuture != null) {
                void var2_2;
                var2_2.cancel(false);
            }
            --this.pendingAcquireCount;
            task.acquired();
            super.acquire(var1_1.promise);
        }
        assert (this.pendingAcquireCount >= 0);
        assert (this.acquiredChannelCount.get() >= 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        try {
            ((SimpleChannelPool)this).closeAsync().await();
            return;
        }
        catch (InterruptedException e) {
            void var1_1;
            Thread.currentThread().interrupt();
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future<Void> closeAsync() {
        void var1_1;
        if (this.executor.inEventLoop()) {
            return this.close0();
        }
        Promise closeComplete = this.executor.newPromise();
        this.executor.execute(new Runnable(this, closeComplete){
            final /* synthetic */ Promise val$closeComplete;
            final /* synthetic */ FixedChannelPool this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$closeComplete = promise;
            }

            @Override
            public void run() {
                this.this$0.close0().addListener((GenericFutureListener)new FutureListener<Void>(this){
                    final /* synthetic */ 5 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void operationComplete(Future<Void> f) throws Exception {
                        void var1_1;
                        if (f.isSuccess()) {
                            this.this$1.val$closeComplete.setSuccess(null);
                            return;
                        }
                        this.this$1.val$closeComplete.setFailure(var1_1.cause());
                    }
                });
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Future<Void> close0() {
        assert (this.executor.inEventLoop());
        if (!this.closed) {
            AcquireTask task;
            this.closed = true;
            while ((task = this.pendingAcquireQueue.poll()) != null) {
                void var1_1;
                ScheduledFuture<?> f = task.timeoutFuture;
                if (f != null) {
                    void var2_2;
                    var2_2.cancel(false);
                }
                var1_1.promise.setFailure((Throwable)new ClosedChannelException());
            }
            this.acquiredChannelCount.set(0);
            this.pendingAcquireCount = 0;
            return GlobalEventExecutor.INSTANCE.submit((Callable)new Callable<Void>(this){
                final /* synthetic */ FixedChannelPool this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public Void call() throws Exception {
                    FixedChannelPool.super.close();
                    return null;
                }
            });
        }
        return GlobalEventExecutor.INSTANCE.newSucceededFuture(null);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Future access$201(FixedChannelPool x0, Promise x1) {
        void var1_1;
        return super.acquire((Promise<Channel>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(FixedChannelPool x0, Promise x1) {
        void var1_1;
        x0.acquire0((Promise<Channel>)var1_1);
    }

    private static final class AcquireTimeoutException
    extends TimeoutException {
        private AcquireTimeoutException() {
            super("Acquire operation took longer then configured maximum time");
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    private class AcquireListener
    implements FutureListener<Channel> {
        private final Promise<Channel> originalPromise;
        protected boolean acquired;

        /*
         * WARNING - void declaration
         */
        AcquireListener(Promise<Channel> originalPromise) {
            void var2_2;
            this.originalPromise = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void operationComplete(Future<Channel> future) throws Exception {
            try {
                assert (FixedChannelPool.this.executor.inEventLoop());
                if (FixedChannelPool.this.closed) {
                    if (future.isSuccess()) {
                        ((Channel)future.getNow()).close();
                    }
                    this.originalPromise.setFailure((Throwable)new IllegalStateException("FixedChannelPool was closed"));
                    return;
                }
                if (!future.isSuccess()) {
                    if (this.acquired) {
                        FixedChannelPool.this.decrementAndRunTaskQueue();
                    } else {
                        FixedChannelPool.this.runTaskQueue();
                    }
                    this.originalPromise.setFailure(future.cause());
                    return;
                }
                this.originalPromise.setSuccess(future.getNow());
            }
            catch (Throwable cause) {
                void var1_2;
                this.originalPromise.tryFailure((Throwable)var1_2);
            }
        }

        public void acquired() {
            if (this.acquired) {
                return;
            }
            FixedChannelPool.this.acquiredChannelCount.incrementAndGet();
            this.acquired = true;
        }
    }

    private abstract class TimeoutTask
    implements Runnable {
        private TimeoutTask() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            AcquireTask task;
            assert (FixedChannelPool.this.executor.inEventLoop());
            long nanoTime = System.nanoTime();
            while ((task = (AcquireTask)FixedChannelPool.this.pendingAcquireQueue.peek()) != null && nanoTime - task.expireNanoTime >= 0L) {
                void var3_2;
                FixedChannelPool.this.pendingAcquireQueue.remove();
                --FixedChannelPool.this.pendingAcquireCount;
                this.onTimeout((AcquireTask)var3_2);
            }
        }

        public abstract void onTimeout(AcquireTask var1);
    }

    private final class AcquireTask
    extends AcquireListener {
        final Promise<Channel> promise;
        final long expireNanoTime;
        ScheduledFuture<?> timeoutFuture;

        /*
         * WARNING - void declaration
         */
        AcquireTask(Promise<Channel> promise) {
            void var2_2;
            super((Promise<Channel>)var2_2);
            this.expireNanoTime = System.nanoTime() + FixedChannelPool.this.acquireTimeoutNanos;
            this.promise = FixedChannelPool.this.executor.newPromise().addListener((GenericFutureListener)this);
        }
    }

    public static enum AcquireTimeoutAction {
        NEW,
        FAIL;

    }
}

