/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ReadOnlyIterator;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractChannelPoolMap<K, P extends ChannelPool>
implements ChannelPoolMap<K, P>,
Closeable,
Iterable<Map.Entry<K, P>> {
    private final ConcurrentMap<K, P> map = PlatformDependent.newConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    @Override
    public final P get(K key) {
        void var2_2;
        ChannelPool old;
        ChannelPool pool = (ChannelPool)this.map.get(ObjectUtil.checkNotNull(key, (String)"key"));
        if (pool == null && (old = this.map.putIfAbsent(key, pool = this.newPool(key))) != null) {
            void var1_1;
            AbstractChannelPoolMap.poolCloseAsyncIfSupported(pool);
            pool = var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(K key) {
        ChannelPool pool = (ChannelPool)this.map.remove(ObjectUtil.checkNotNull(key, (String)"key"));
        if (pool != null) {
            void var1_1;
            AbstractChannelPoolMap.poolCloseAsyncIfSupported((ChannelPool)var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Future<Boolean> removeAsyncIfSupported(K key) {
        ChannelPool pool = (ChannelPool)this.map.remove(ObjectUtil.checkNotNull(key, (String)"key"));
        if (pool != null) {
            void var2_2;
            void var1_1;
            Promise removePromise = GlobalEventExecutor.INSTANCE.newPromise();
            AbstractChannelPoolMap.poolCloseAsyncIfSupported((ChannelPool)var1_1).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(this, removePromise){
                final /* synthetic */ Promise val$removePromise;
                final /* synthetic */ AbstractChannelPoolMap this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$removePromise = promise;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(Future<? super Void> future) throws Exception {
                    void var1_1;
                    if (future.isSuccess()) {
                        this.val$removePromise.setSuccess((Object)Boolean.TRUE);
                        return;
                    }
                    this.val$removePromise.setFailure(var1_1.cause());
                }
            });
            return var2_2;
        }
        return GlobalEventExecutor.INSTANCE.newSucceededFuture((Object)Boolean.FALSE);
    }

    /*
     * WARNING - void declaration
     */
    private static Future<Void> poolCloseAsyncIfSupported(ChannelPool pool) {
        if (pool instanceof SimpleChannelPool) {
            return ((SimpleChannelPool)pool).closeAsync();
        }
        try {
            pool.close();
            return GlobalEventExecutor.INSTANCE.newSucceededFuture(null);
        }
        catch (Exception e) {
            void var0_1;
            return GlobalEventExecutor.INSTANCE.newFailedFuture((Throwable)var0_1);
        }
    }

    @Override
    public final Iterator<Map.Entry<K, P>> iterator() {
        return new ReadOnlyIterator(this.map.entrySet().iterator());
    }

    public final int size() {
        return this.map.size();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(K key) {
        void var1_1;
        return this.map.containsKey(ObjectUtil.checkNotNull((Object)var1_1, (String)"key"));
    }

    protected abstract P newPool(K var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() {
        for (Object key : this.map.keySet()) {
            void var2_2;
            this.removeAsyncIfSupported(var2_2).syncUninterruptibly();
        }
    }
}

