/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.oio.AbstractOioByteChannel;
import io.netty.util.internal.ObjectUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.WritableByteChannel;

@Deprecated
public abstract class OioByteStreamChannel
extends AbstractOioByteChannel {
    private static final InputStream CLOSED_IN = new InputStream(){

        @Override
        public final int read() {
            return -1;
        }
    };
    private static final OutputStream CLOSED_OUT = new OutputStream(){

        @Override
        public final void write(int b) throws IOException {
            throw new ClosedChannelException();
        }
    };
    private InputStream is;
    private OutputStream os;
    private WritableByteChannel outChannel;

    /*
     * WARNING - void declaration
     */
    protected OioByteStreamChannel(Channel parent) {
        super((Channel)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final void activate(InputStream is, OutputStream os) {
        void var2_2;
        void var1_1;
        if (this.is != null) {
            throw new IllegalStateException("input was set already");
        }
        if (this.os != null) {
            throw new IllegalStateException("output was set already");
        }
        this.is = (InputStream)ObjectUtil.checkNotNull((Object)var1_1, (String)"is");
        this.os = (OutputStream)ObjectUtil.checkNotNull((Object)var2_2, (String)"os");
        if (this.readWhenInactive) {
            this.eventLoop().execute(this.readTask);
            this.readWhenInactive = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isActive() {
        void var1_1;
        InputStream is = this.is;
        if (is == null || is == CLOSED_IN) {
            return false;
        }
        OutputStream os = this.os;
        return os != null && var1_1 != CLOSED_OUT;
    }

    @Override
    protected int available() {
        try {
            return this.is.available();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int doReadBytes(ByteBuf buf) throws Exception {
        void var2_2;
        void var1_1;
        RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
        allocHandle.attemptedBytesRead(Math.max(1, Math.min(this.available(), buf.maxWritableBytes())));
        return var1_1.writeBytes(this.is, var2_2.attemptedBytesRead());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doWriteBytes(ByteBuf buf) throws Exception {
        void var1_1;
        void var2_2;
        OutputStream os = this.os;
        if (os == null) {
            throw new NotYetConnectedException();
        }
        buf.readBytes((OutputStream)var2_2, var1_1.readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doWriteFileRegion(FileRegion region) throws Exception {
        long localWritten;
        OutputStream os = this.os;
        if (os == null) {
            throw new NotYetConnectedException();
        }
        if (this.outChannel == null) {
            void var2_2;
            this.outChannel = Channels.newChannel((OutputStream)var2_2);
        }
        long written = 0L;
        do {
            if ((localWritten = region.transferTo(this.outChannel, written)) != -1L) continue;
            OioByteStreamChannel.checkEOF(region);
            return;
        } while ((written += localWritten) < region.count());
    }

    private static void checkEOF(FileRegion region) throws IOException {
        if (region.transferred() < region.count()) {
            FileRegion fileRegion;
            throw new EOFException("Expected to be able to write " + region.count() + " bytes, but only wrote " + fileRegion.transferred());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doClose() throws Exception {
        InputStream is = this.is;
        OutputStream os = this.os;
        this.is = CLOSED_IN;
        this.os = CLOSED_OUT;
        try {
            if (is != null) {
                void var1_1;
                var1_1.close();
            }
            if (os == null) return;
        }
        catch (Throwable throwable) {
            void var2_3;
            if (os == null) throw throwable;
            var2_3.close();
            throw throwable;
        }
        os.close();
    }
}

