/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.oio.AbstractOioChannel;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.util.internal.StringUtil;
import java.io.IOException;

public abstract class AbstractOioByteChannel
extends AbstractOioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';

    /*
     * WARNING - void declaration
     */
    protected AbstractOioByteChannel(Channel parent) {
        super((Channel)var1_1);
        void var1_1;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected abstract boolean isInputShutdown();

    protected abstract ChannelFuture shutdownInput();

    /*
     * WARNING - void declaration
     */
    private void closeOnRead(ChannelPipeline pipeline) {
        if (this.isOpen()) {
            void var1_1;
            if (Boolean.TRUE.equals(this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                this.shutdownInput();
                pipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
            } else {
                this.unsafe().close(this.unsafe().voidPromise());
            }
            var1_1.fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean close, RecvByteBufAllocator.Handle allocHandle) {
        void var3_3;
        if (byteBuf != null) {
            if (byteBuf.isReadable()) {
                this.readPending = false;
                pipeline.fireChannelRead(byteBuf);
            } else {
                void var2_2;
                var2_2.release();
            }
        }
        allocHandle.readComplete();
        pipeline.fireChannelReadComplete();
        pipeline.fireExceptionCaught(cause);
        if (close || cause instanceof OutOfMemoryError || var3_3 instanceof IOException) {
            void var1_1;
            this.closeOnRead((ChannelPipeline)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doRead() {
        block16: {
            boolean readData;
            ChannelConfig config;
            block15: {
                config = this.config();
                if (this.isInputShutdown() || !this.readPending) {
                    return;
                }
                this.readPending = false;
                ChannelPipeline pipeline = this.pipeline();
                ByteBufAllocator allocator = config.getAllocator();
                RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
                allocHandle.reset(config);
                ByteBuf byteBuf = null;
                boolean close = false;
                readData = false;
                try {
                    byteBuf = allocHandle.allocate(allocator);
                    do {
                        int maxCapacity;
                        allocHandle.lastBytesRead(this.doReadBytes(byteBuf));
                        if (allocHandle.lastBytesRead() <= 0) {
                            if (byteBuf.isReadable()) break;
                            byteBuf.release();
                            byteBuf = null;
                            close = allocHandle.lastBytesRead() < 0;
                            if (!close) break;
                            this.readPending = false;
                            break;
                        }
                        readData = true;
                        int available = this.available();
                        if (available <= 0) break;
                        if (byteBuf.isWritable()) continue;
                        int capacity = byteBuf.capacity();
                        if (capacity == (maxCapacity = byteBuf.maxCapacity())) {
                            allocHandle.incMessagesRead(1);
                            this.readPending = false;
                            pipeline.fireChannelRead(byteBuf);
                            byteBuf = allocHandle.allocate(allocator);
                            continue;
                        }
                        int n = byteBuf.writerIndex();
                        if (n + available > maxCapacity) {
                            byteBuf.capacity(maxCapacity);
                            continue;
                        }
                        byteBuf.ensureWritable(available);
                    } while (allocHandle.continueReading());
                    if (byteBuf != null) {
                        if (byteBuf.isReadable()) {
                            this.readPending = false;
                            pipeline.fireChannelRead(byteBuf);
                        } else {
                            byteBuf.release();
                        }
                        byteBuf = null;
                    }
                    if (readData) {
                        allocHandle.readComplete();
                        pipeline.fireChannelReadComplete();
                    }
                    if (!close) break block15;
                    this.closeOnRead(pipeline);
                }
                catch (Throwable t) {
                    try {
                        void var2_2;
                        this.handleReadException((ChannelPipeline)var2_2, byteBuf, t, close, allocHandle);
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (!this.readPending && !config.isAutoRead() && (readData || !this.isActive())) break block16;
                        this.read();
                    }
                }
            }
            if (this.readPending || config.isAutoRead() || !readData && this.isActive()) {
                this.read();
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        Object msg;
        while ((msg = in.current()) != null) {
            void var2_2;
            ByteBuf buf;
            if (msg instanceof ByteBuf) {
                buf = (ByteBuf)msg;
                int readableBytes = buf.readableBytes();
                while (readableBytes > 0) {
                    this.doWriteBytes(buf);
                    int newReadableBytes = buf.readableBytes();
                    in.progress(readableBytes - newReadableBytes);
                    readableBytes = newReadableBytes;
                }
                in.remove();
                continue;
            }
            if (buf instanceof FileRegion) {
                FileRegion region = (FileRegion)buf;
                long transferred = region.transferred();
                this.doWriteFileRegion(region);
                in.progress(var2_2.transferred() - transferred);
                in.remove();
                continue;
            }
            in.remove(new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)var2_2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final Object filterOutboundMessage(Object msg) throws Exception {
        void var1_1;
        if (msg instanceof ByteBuf || msg instanceof FileRegion) {
            return msg;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)var1_1) + EXPECTED_TYPES);
    }

    protected abstract int available();

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract void doWriteBytes(ByteBuf var1) throws Exception;

    protected abstract void doWriteFileRegion(FileRegion var1) throws Exception;
}

