/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.EventLoopException;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.nio.NioTask;
import io.netty.channel.nio.SelectedSelectionKeySet;
import io.netty.channel.nio.SelectedSelectionKeySetSelector;
import io.netty.util.IntSupplier;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ReflectionUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public final class NioEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger;
    private static final int CLEANUP_INTERVAL = 256;
    private static final boolean DISABLE_KEY_SET_OPTIMIZATION;
    private static final int MIN_PREMATURE_SELECTOR_RETURNS = 3;
    private static final int SELECTOR_AUTO_REBUILD_THRESHOLD;
    private final IntSupplier selectNowSupplier = new IntSupplier(this){
        final /* synthetic */ NioEventLoop this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public int get() throws Exception {
            return this.this$0.selectNow();
        }
    };
    private Selector selector;
    private Selector unwrappedSelector;
    private SelectedSelectionKeySet selectedKeys;
    private final SelectorProvider provider;
    private static final long AWAKE = -1L;
    private static final long NONE = Long.MAX_VALUE;
    private final AtomicLong nextWakeupNanos = new AtomicLong(-1L);
    private final SelectStrategy selectStrategy;
    private volatile int ioRatio = 50;
    private int cancelledKeys;
    private boolean needsToSelectAgain;

    /*
     * WARNING - void declaration
     */
    NioEventLoop(NioEventLoopGroup parent, Executor executor, SelectorProvider selectorProvider, SelectStrategy strategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory taskQueueFactory, EventLoopTaskQueueFactory tailTaskQueueFactory) {
        super(parent, (Executor)var2_2, false, NioEventLoop.newTaskQueue(taskQueueFactory), NioEventLoop.newTaskQueue(tailTaskQueueFactory), rejectedExecutionHandler);
        void var1_1;
        void var3_3;
        void var2_2;
        this.provider = (SelectorProvider)ObjectUtil.checkNotNull((Object)var3_3, (String)"selectorProvider");
        this.selectStrategy = (SelectStrategy)ObjectUtil.checkNotNull((Object)strategy, (String)"selectStrategy");
        SelectorTuple selectorTuple = this.openSelector();
        this.selector = selectorTuple.selector;
        this.unwrappedSelector = var1_1.unwrappedSelector;
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory queueFactory) {
        EventLoopTaskQueueFactory eventLoopTaskQueueFactory;
        if (queueFactory == null) {
            return NioEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return eventLoopTaskQueueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    /*
     * WARNING - void declaration
     */
    private SelectorTuple openSelector() {
        void var3_4;
        void var1_1;
        Throwable t;
        AbstractSelector unwrappedSelector;
        try {
            unwrappedSelector = this.provider.openSelector();
        }
        catch (IOException e) {
            throw new ChannelException("failed to open a new selector", e);
        }
        if (DISABLE_KEY_SET_OPTIMIZATION) {
            return new SelectorTuple(unwrappedSelector);
        }
        Object maybeSelectorImplClass = AccessController.doPrivileged(new PrivilegedAction<Object>(this){
            final /* synthetic */ NioEventLoop this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public Object run() {
                try {
                    return Class.forName("sun.nio.ch.SelectorImpl", false, PlatformDependent.getSystemClassLoader());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    return throwable;
                }
            }
        });
        if (!(maybeSelectorImplClass instanceof Class) || !((Class)maybeSelectorImplClass).isAssignableFrom(unwrappedSelector.getClass())) {
            if (maybeSelectorImplClass instanceof Throwable) {
                t = (Throwable)maybeSelectorImplClass;
                logger.trace("failed to instrument a special java.util.Set into: {}", (Object)unwrappedSelector, (Object)t);
            }
            return new SelectorTuple(unwrappedSelector);
        }
        Class selectorImplClass = (Class)((Object)t);
        SelectedSelectionKeySet selectedKeySet = new SelectedSelectionKeySet();
        Object maybeException = AccessController.doPrivileged(new PrivilegedAction<Object>(this, selectorImplClass, (Selector)unwrappedSelector, selectedKeySet){
            final /* synthetic */ Class val$selectorImplClass;
            final /* synthetic */ Selector val$unwrappedSelector;
            final /* synthetic */ SelectedSelectionKeySet val$selectedKeySet;
            final /* synthetic */ NioEventLoop this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$selectorImplClass = clazz;
                this.val$unwrappedSelector = selector;
                this.val$selectedKeySet = selectedSelectionKeySet;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Object run() {
                try {
                    void var2_4;
                    void var1_1;
                    Throwable cause;
                    Field selectedKeysField = this.val$selectorImplClass.getDeclaredField("selectedKeys");
                    Field publicSelectedKeysField = this.val$selectorImplClass.getDeclaredField("publicSelectedKeys");
                    if (PlatformDependent.javaVersion() >= 9 && PlatformDependent.hasUnsafe()) {
                        long selectedKeysFieldOffset = PlatformDependent.objectFieldOffset((Field)selectedKeysField);
                        long publicSelectedKeysFieldOffset = PlatformDependent.objectFieldOffset((Field)publicSelectedKeysField);
                        if (selectedKeysFieldOffset != -1L && publicSelectedKeysFieldOffset != -1L) {
                            PlatformDependent.putObject((Object)this.val$unwrappedSelector, (long)selectedKeysFieldOffset, (Object)this.val$selectedKeySet);
                            PlatformDependent.putObject((Object)this.val$unwrappedSelector, (long)publicSelectedKeysFieldOffset, (Object)this.val$selectedKeySet);
                            return null;
                        }
                    }
                    if ((cause = ReflectionUtil.trySetAccessible((AccessibleObject)selectedKeysField, (boolean)true)) != null) {
                        return cause;
                    }
                    cause = ReflectionUtil.trySetAccessible((AccessibleObject)publicSelectedKeysField, (boolean)true);
                    if (cause != null) {
                        void var3_6;
                        return var3_6;
                    }
                    var1_1.set(this.val$unwrappedSelector, this.val$selectedKeySet);
                    var2_4.set(this.val$unwrappedSelector, this.val$selectedKeySet);
                    return null;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
                    return noSuchFieldException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    IllegalAccessException illegalAccessException2 = illegalAccessException;
                    return illegalAccessException;
                }
            }
        });
        if (maybeException instanceof Exception) {
            void var2_3;
            this.selectedKeys = null;
            Exception e = (Exception)maybeException;
            logger.trace("failed to instrument a special java.util.Set into: {}", (Object)unwrappedSelector, (Object)var2_3);
            return new SelectorTuple(unwrappedSelector);
        }
        this.selectedKeys = selectedKeySet;
        logger.trace("instrumented a special java.util.Set into: {}", (Object)unwrappedSelector);
        return new SelectorTuple(unwrappedSelector, new SelectedSelectionKeySetSelector((Selector)var1_1, (SelectedSelectionKeySet)var3_4));
    }

    public final SelectorProvider selectorProvider() {
        return this.provider;
    }

    protected final Queue<Runnable> newTaskQueue(int maxPendingTasks) {
        return NioEventLoop.newTaskQueue0(maxPendingTasks);
    }

    private static Queue<Runnable> newTaskQueue0(int maxPendingTasks) {
        int n;
        if (maxPendingTasks == Integer.MAX_VALUE) {
            return PlatformDependent.newMpscQueue();
        }
        return PlatformDependent.newMpscQueue((int)n);
    }

    /*
     * WARNING - void declaration
     */
    public final void register(SelectableChannel ch, int interestOps, NioTask<?> task) {
        ObjectUtil.checkNotNull((Object)ch, (String)"ch");
        if (interestOps == 0) {
            throw new IllegalArgumentException("interestOps must be non-zero.");
        }
        if ((interestOps & ~ch.validOps()) != 0) {
            throw new IllegalArgumentException("invalid interestOps: " + interestOps + "(validOps: " + ch.validOps() + ')');
        }
        ObjectUtil.checkNotNull(task, (String)"task");
        if (this.isShutdown()) {
            throw new IllegalStateException("event loop shut down");
        }
        if (this.inEventLoop()) {
            this.register0(ch, interestOps, task);
            return;
        }
        try {
            void var3_3;
            void var2_2;
            void var1_1;
            this.submit(new Runnable(this, (SelectableChannel)var1_1, (int)var2_2, (NioTask)var3_3){
                final /* synthetic */ SelectableChannel val$ch;
                final /* synthetic */ int val$interestOps;
                final /* synthetic */ NioTask val$task;
                final /* synthetic */ NioEventLoop this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$ch = selectableChannel;
                    this.val$interestOps = n;
                    this.val$task = nioTask;
                }

                @Override
                public void run() {
                    NioEventLoop.access$000(this.this$0, this.val$ch, this.val$interestOps, this.val$task);
                }
            }).sync();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void register0(SelectableChannel ch, int interestOps, NioTask<?> task) {
        try {
            void var3_4;
            void var2_3;
            ch.register(this.unwrappedSelector, (int)var2_3, var3_4);
            return;
        }
        catch (Exception e) {
            void var1_2;
            throw new EventLoopException("failed to register a channel", (Throwable)var1_2);
        }
    }

    public final int getIoRatio() {
        return this.ioRatio;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIoRatio(int ioRatio) {
        void var1_1;
        if (ioRatio <= 0 || ioRatio > 100) {
            throw new IllegalArgumentException("ioRatio: " + ioRatio + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = var1_1;
    }

    public final void rebuildSelector() {
        if (!this.inEventLoop()) {
            this.execute(new Runnable(this){
                final /* synthetic */ NioEventLoop this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void run() {
                    this.this$0.rebuildSelector0();
                }
            });
            return;
        }
        this.rebuildSelector0();
    }

    @Override
    public final int registeredChannels() {
        return this.selector.keys().size() - this.cancelledKeys;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<Channel> registeredChannelsIterator() {
        void var1_1;
        assert (this.inEventLoop());
        Set<SelectionKey> keys = this.selector.keys();
        if (keys.isEmpty()) {
            return SingleThreadEventLoop.ChannelsReadOnlyIterator.empty();
        }
        return new Iterator<Channel>(this, (Set)var1_1){
            final Iterator<SelectionKey> selectionKeyIterator;
            Channel next;
            boolean isDone;
            final /* synthetic */ Set val$keys;
            final /* synthetic */ NioEventLoop this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$keys = set;
                this.selectionKeyIterator = ((Set)ObjectUtil.checkNotNull((Object)this.val$keys, (String)"selectionKeys")).iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.isDone) {
                    return false;
                }
                Channel channel = this.next;
                if (channel == null) {
                    channel = this.next = this.nextOrDone();
                    return this.next != null;
                }
                return true;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Channel next() {
                void var1_1;
                if (this.isDone) {
                    throw new NoSuchElementException();
                }
                Channel cur = this.next;
                if (cur == null && (cur = this.nextOrDone()) == null) {
                    throw new NoSuchElementException();
                }
                this.next = this.nextOrDone();
                return var1_1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            /*
             * WARNING - void declaration
             */
            private Channel nextOrDone() {
                Iterator<SelectionKey> it = this.selectionKeyIterator;
                while (it.hasNext()) {
                    void var2_2;
                    Object attachment;
                    SelectionKey key = it.next();
                    if (!key.isValid() || !((attachment = key.attachment()) instanceof AbstractNioChannel)) continue;
                    return (AbstractNioChannel)var2_2;
                }
                this.isDone = true;
                return null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void rebuildSelector0() {
        block11: {
            void var2_2;
            SelectorTuple newSelectorTuple;
            Selector oldSelector = this.selector;
            if (oldSelector == null) {
                return;
            }
            try {
                newSelectorTuple = this.openSelector();
            }
            catch (Exception e) {
                logger.warn("Failed to create a new Selector.", (Throwable)e);
                return;
            }
            int nChannels = 0;
            for (SelectionKey key : oldSelector.keys()) {
                Object a = key.attachment();
                try {
                    if (!key.isValid() || key.channel().keyFor(newSelectorTuple.unwrappedSelector) != null) continue;
                    int interestOps = key.interestOps();
                    key.cancel();
                    SelectionKey newKey = key.channel().register(newSelectorTuple.unwrappedSelector, interestOps, a);
                    if (a instanceof AbstractNioChannel) {
                        ((AbstractNioChannel)a).selectionKey = newKey;
                    }
                    ++nChannels;
                }
                catch (Exception e) {
                    logger.warn("Failed to re-register a Channel to the new Selector.", (Throwable)e);
                    if (a instanceof AbstractNioChannel) {
                        AbstractNioChannel ch = (AbstractNioChannel)a;
                        ch.unsafe().close(ch.unsafe().voidPromise());
                        continue;
                    }
                    NioTask nioTask = (NioTask)a;
                    NioEventLoop.invokeChannelUnregistered(nioTask, key, e);
                }
            }
            this.selector = newSelectorTuple.selector;
            this.unwrappedSelector = var2_2.unwrappedSelector;
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block11;
                logger.warn("Failed to close the old Selector.", t);
            }
        }
        if (logger.isInfoEnabled()) {
            void var3_4;
            logger.info("Migrated " + (int)var3_4 + " channel(s) to the new Selector.");
        }
    }

    /*
     * Exception decompiling
     */
    protected final void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private boolean unexpectedSelectorWakeup(int selectCnt) {
        if (Thread.interrupted()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Selector.select() returned prematurely because Thread.currentThread().interrupt() was called. Use NioEventLoop.shutdownGracefully() to shutdown the NioEventLoop.");
            }
            return true;
        }
        if (SELECTOR_AUTO_REBUILD_THRESHOLD > 0 && selectCnt >= SELECTOR_AUTO_REBUILD_THRESHOLD) {
            void var1_1;
            logger.warn("Selector.select() returned prematurely {} times in a row; rebuilding Selector {}.", (Object)((int)var1_1), (Object)this.selector);
            this.rebuildSelector();
            return true;
        }
        return false;
    }

    private static void handleLoopException(Throwable t) {
        Throwable throwable;
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void processSelectedKeys() {
        if (this.selectedKeys != null) {
            this.processSelectedKeysOptimized();
            return;
        }
        NioEventLoop nioEventLoop = this;
        nioEventLoop.processSelectedKeysPlain(nioEventLoop.selector.selectedKeys());
    }

    /*
     * WARNING - void declaration
     */
    protected final void cleanup() {
        try {
            this.selector.close();
            return;
        }
        catch (IOException e) {
            void var1_1;
            logger.warn("Failed to close a selector.", (Throwable)var1_1);
            return;
        }
    }

    final void cancel(SelectionKey key) {
        key.cancel();
        ++this.cancelledKeys;
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.needsToSelectAgain = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processSelectedKeysPlain(Set<SelectionKey> selectedKeys) {
        if (selectedKeys.isEmpty()) {
            return;
        }
        Iterator i = selectedKeys.iterator();
        while (true) {
            SelectionKey k = i.next();
            Object a = k.attachment();
            i.remove();
            if (a instanceof AbstractNioChannel) {
                this.processSelectedKey(k, (AbstractNioChannel)a);
            } else {
                void var3_3;
                void var2_2;
                NioTask task = (NioTask)a;
                NioEventLoop.processSelectedKey((SelectionKey)var2_2, (NioTask<SelectableChannel>)var3_3);
            }
            if (!i.hasNext()) break;
            if (!this.needsToSelectAgain) continue;
            this.selectAgain();
            i = this.selector.selectedKeys();
            if (i.isEmpty()) break;
            i = i.iterator();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processSelectedKeysOptimized() {
        for (int i = 0; i < this.selectedKeys.size; ++i) {
            SelectionKey k = this.selectedKeys.keys[i];
            this.selectedKeys.keys[i] = null;
            Object a = k.attachment();
            if (a instanceof AbstractNioChannel) {
                this.processSelectedKey(k, (AbstractNioChannel)a);
            } else {
                void var3_3;
                void var2_2;
                NioTask task = (NioTask)a;
                NioEventLoop.processSelectedKey((SelectionKey)var2_2, (NioTask<SelectableChannel>)var3_3);
            }
            if (!this.needsToSelectAgain) continue;
            this.selectedKeys.reset(i + 1);
            this.selectAgain();
            i = -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processSelectedKey(SelectionKey k, AbstractNioChannel ch) {
        AbstractNioChannel.NioUnsafe unsafe = ch.unsafe();
        if (!k.isValid()) {
            NioEventLoop eventLoop;
            try {
                eventLoop = ch.eventLoop();
            }
            catch (Throwable throwable) {
                return;
            }
            if (eventLoop == this) {
                AbstractNioChannel.NioUnsafe nioUnsafe = unsafe;
                nioUnsafe.close(nioUnsafe.voidPromise());
            }
            return;
        }
        try {
            void var2_3;
            int readyOps = k.readyOps();
            if ((readyOps & 8) != 0) {
                void var1_1;
                int n = k.interestOps();
                int ops = n & 0xFFFFFFF7;
                var1_1.interestOps(ops);
                unsafe.finishConnect();
            }
            if ((readyOps & 4) != 0) {
                unsafe.forceFlush();
            }
            if ((readyOps & 0x11) != 0 || var2_3 == false) {
                unsafe.read();
            }
            return;
        }
        catch (CancelledKeyException cancelledKeyException) {
            void var3_4;
            void v3 = var3_4;
            v3.close(v3.voidPromise());
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processSelectedKey(SelectionKey k, NioTask<SelectableChannel> task) {
        try {
            task.channelReady(k.channel(), k);
            if (k.isValid()) return;
        }
        catch (Exception e) {
            try {
                void var2_2;
                k.cancel();
                NioEventLoop.invokeChannelUnregistered(task, k, (Throwable)var2_2);
                return;
            }
            catch (Throwable throwable) {
                SelectionKey selectionKey;
                void var1_1;
                k.cancel();
                NioEventLoop.invokeChannelUnregistered((NioTask<SelectableChannel>)var1_1, selectionKey, null);
                throw throwable;
            }
        }
        NioEventLoop.invokeChannelUnregistered(task, k, null);
        return;
    }

    /*
     * WARNING - void declaration
     */
    private void closeAll() {
        void var2_2;
        Iterator iterator;
        this.selectAgain();
        Set<SelectionKey> keys = this.selector.keys();
        ArrayList<AbstractNioChannel> channels = new ArrayList<AbstractNioChannel>(keys.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SelectionKey k = (SelectionKey)iterator.next();
            Object a = k.attachment();
            if (a instanceof AbstractNioChannel) {
                channels.add((AbstractNioChannel)a);
                continue;
            }
            k.cancel();
            NioTask nioTask = (NioTask)a;
            NioEventLoop.invokeChannelUnregistered(nioTask, k, null);
        }
        for (AbstractNioChannel ch : var2_2) {
            void var3_3;
            ch.unsafe().close(var3_3.unsafe().voidPromise());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void invokeChannelUnregistered(NioTask<SelectableChannel> task, SelectionKey k, Throwable cause) {
        try {
            void var2_3;
            void var1_2;
            task.channelUnregistered(var1_2.channel(), (Throwable)var2_3);
            return;
        }
        catch (Exception e) {
            void var0_1;
            logger.warn("Unexpected exception while running NioTask.channelUnregistered()", (Throwable)var0_1);
            return;
        }
    }

    protected final void wakeup(boolean inEventLoop) {
        if (!inEventLoop && this.nextWakeupNanos.getAndSet(-1L) != -1L) {
            this.selector.wakeup();
        }
    }

    protected final boolean beforeScheduledTaskSubmitted(long deadlineNanos) {
        return deadlineNanos < this.nextWakeupNanos.get();
    }

    protected final boolean afterScheduledTaskSubmitted(long deadlineNanos) {
        return deadlineNanos < this.nextWakeupNanos.get();
    }

    final Selector unwrappedSelector() {
        return this.unwrappedSelector;
    }

    final int selectNow() throws IOException {
        return this.selector.selectNow();
    }

    /*
     * WARNING - void declaration
     */
    private int select(long deadlineNanos) throws IOException {
        void var3_2;
        void var1_1;
        if (deadlineNanos == Long.MAX_VALUE) {
            return this.selector.select();
        }
        long timeoutMillis = NioEventLoop.deadlineToDelayNanos((long)(var1_1 + 995000L)) / 1000000L;
        if (timeoutMillis <= 0L) {
            return this.selector.selectNow();
        }
        return this.selector.select((long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private void selectAgain() {
        this.needsToSelectAgain = false;
        try {
            this.selector.selectNow();
            return;
        }
        catch (Throwable t) {
            void var1_1;
            logger.warn("Failed to update SelectionKeys.", (Throwable)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(NioEventLoop x0, SelectableChannel x1, int x2, NioTask x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.register0((SelectableChannel)var1_1, (int)var2_2, (NioTask<?>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0_2;
        int selectorAutoRebuildThreshold;
        String string;
        logger = InternalLoggerFactory.getInstance(NioEventLoop.class);
        DISABLE_KEY_SET_OPTIMIZATION = SystemPropertyUtil.getBoolean((String)"io.netty.noKeySetOptimization", (boolean)false);
        if (PlatformDependent.javaVersion() < 7 && (string = SystemPropertyUtil.get((String)"sun.nio.ch.bugLevel")) == null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public final Void run() {
                        System.setProperty("sun.nio.ch.bugLevel", "");
                        return null;
                    }
                });
            }
            catch (SecurityException e) {
                logger.debug("Unable to get/set System Property: sun.nio.ch.bugLevel", (Throwable)e);
            }
        }
        if ((selectorAutoRebuildThreshold = SystemPropertyUtil.getInt((String)"io.netty.selectorAutoRebuildThreshold", (int)512)) < 3) {
            selectorAutoRebuildThreshold = 0;
        }
        SELECTOR_AUTO_REBUILD_THRESHOLD = var0_2;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noKeySetOptimization: {}", (Object)DISABLE_KEY_SET_OPTIMIZATION);
            logger.debug("-Dio.netty.selectorAutoRebuildThreshold: {}", (Object)SELECTOR_AUTO_REBUILD_THRESHOLD);
        }
    }

    private static final class SelectorTuple {
        final Selector unwrappedSelector;
        final Selector selector;

        /*
         * WARNING - void declaration
         */
        SelectorTuple(Selector unwrappedSelector) {
            void var1_1;
            this.unwrappedSelector = unwrappedSelector;
            this.selector = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        SelectorTuple(Selector unwrappedSelector, Selector selector) {
            void var2_2;
            void var1_1;
            this.unwrappedSelector = var1_1;
            this.selector = var2_2;
        }
    }
}

