/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.AbstractNioChannel;
import java.io.IOException;
import java.net.PortUnreachableException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractNioMessageChannel
extends AbstractNioChannel {
    boolean inputShutdown;

    /*
     * WARNING - void declaration
     */
    protected AbstractNioMessageChannel(Channel parent, SelectableChannel ch, int readInterestOp) {
        super((Channel)var1_1, (SelectableChannel)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioMessageUnsafe();
    }

    @Override
    protected void doBeginRead() throws Exception {
        if (this.inputShutdown) {
            return;
        }
        super.doBeginRead();
    }

    protected boolean continueReading(RecvByteBufAllocator.Handle allocHandle) {
        return allocHandle.continueReading();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        void var1_1;
        Object msg;
        SelectionKey key = this.selectionKey();
        int interestOps = key.interestOps();
        int maxMessagesPerWrite = this.maxMessagesPerWrite();
        while (maxMessagesPerWrite > 0 && (msg = in.current()) != null) {
            try {
                boolean done = false;
                for (int i = this.config().getWriteSpinCount() - 1; i >= 0; --i) {
                    if (!this.doWriteMessage(msg, in)) continue;
                    done = true;
                    break;
                }
                if (!done) break;
                --maxMessagesPerWrite;
                in.remove();
            }
            catch (Exception e) {
                if (this.continueOnWriteError()) {
                    --maxMessagesPerWrite;
                    in.remove(e);
                    continue;
                }
                throw e;
            }
        }
        if (var1_1.isEmpty()) {
            if ((interestOps & 4) != 0) {
                key.interestOps(interestOps & 0xFFFFFFFB);
                return;
            }
        } else if ((interestOps & 4) == 0) {
            void var3_3;
            void var2_2;
            var2_2.interestOps(var3_3 | 4);
        }
    }

    protected boolean continueOnWriteError() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean closeOnReadError(Throwable cause) {
        void var1_1;
        if (!this.isActive()) {
            return true;
        }
        if (cause instanceof PortUnreachableException) {
            return false;
        }
        if (var1_1 instanceof IOException) {
            return !(this instanceof ServerChannel);
        }
        return true;
    }

    protected abstract int doReadMessages(List<Object> var1) throws Exception;

    protected abstract boolean doWriteMessage(Object var1, ChannelOutboundBuffer var2) throws Exception;

    private final class NioMessageUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private final List<Object> readBuf;

        private NioMessageUnsafe() {
            super(AbstractNioMessageChannel.this);
            this.readBuf = new ArrayList<Object>();
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void read() {
            assert (AbstractNioMessageChannel.this.eventLoop().inEventLoop());
            ChannelConfig config = AbstractNioMessageChannel.this.config();
            ChannelPipeline pipeline = AbstractNioMessageChannel.this.pipeline();
            RecvByteBufAllocator.Handle allocHandle = AbstractNioMessageChannel.this.unsafe().recvBufAllocHandle();
            allocHandle.reset(config);
            boolean closed = false;
            Throwable exception = null;
            try {
                void var3_4;
                try {
                    int localRead;
                    while ((localRead = AbstractNioMessageChannel.this.doReadMessages(this.readBuf)) != 0) {
                        if (localRead < 0) {
                            closed = true;
                        } else {
                            allocHandle.incMessagesRead(localRead);
                            if (AbstractNioMessageChannel.this.continueReading(allocHandle)) continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Throwable localRead = throwable;
                    exception = throwable;
                }
                int size = this.readBuf.size();
                for (int i = 0; i < size; ++i) {
                    AbstractNioMessageChannel.this.readPending = false;
                    pipeline.fireChannelRead(this.readBuf.get(i));
                }
                this.readBuf.clear();
                var3_4.readComplete();
                pipeline.fireChannelReadComplete();
                if (exception != null) {
                    void var2_2;
                    closed = AbstractNioMessageChannel.this.closeOnReadError(exception);
                    var2_2.fireExceptionCaught(exception);
                }
                if (closed) {
                    AbstractNioMessageChannel.this.inputShutdown = true;
                    if (AbstractNioMessageChannel.this.isOpen()) {
                        NioMessageUnsafe nioMessageUnsafe = this;
                        nioMessageUnsafe.close(nioMessageUnsafe.voidPromise());
                    }
                }
                if (AbstractNioMessageChannel.this.readPending || config.isAutoRead()) return;
            }
            catch (Throwable throwable) {
                void var1_1;
                if (AbstractNioMessageChannel.this.readPending || var1_1.isAutoRead()) throw throwable;
                this.removeReadOp();
                throw throwable;
            }
            this.removeReadOp();
        }
    }
}

