/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoop;
import io.netty.channel.nio.NioEventLoop;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.TimeUnit;

public abstract class AbstractNioChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioChannel.class);
    private final SelectableChannel ch;
    protected final int readInterestOp;
    volatile SelectionKey selectionKey;
    boolean readPending;
    private final Runnable clearReadPendingRunnable = new Runnable(this){
        final /* synthetic */ AbstractNioChannel this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            this.this$0.clearReadPending0();
        }
    };
    private ChannelPromise connectPromise;
    private Future<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;

    /*
     * WARNING - void declaration
     */
    protected AbstractNioChannel(Channel parent, SelectableChannel ch, int readInterestOp) {
        super(parent);
        void var3_5;
        this.ch = ch;
        this.readInterestOp = var3_5;
        try {
            ch.configureBlocking(false);
            return;
        }
        catch (IOException e) {
            void var1_2;
            try {
                ch.close();
            }
            catch (IOException e2) {
                void var2_4;
                logger.warn("Failed to close a partially initialized socket.", (Throwable)var2_4);
            }
            throw new ChannelException("Failed to enter non-blocking mode.", (Throwable)var1_2);
        }
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public NioUnsafe unsafe() {
        return (NioUnsafe)super.unsafe();
    }

    protected SelectableChannel javaChannel() {
        return this.ch;
    }

    @Override
    public NioEventLoop eventLoop() {
        return (NioEventLoop)super.eventLoop();
    }

    protected SelectionKey selectionKey() {
        assert (this.selectionKey != null);
        return this.selectionKey;
    }

    @Deprecated
    protected boolean isReadPending() {
        return this.readPending;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Deprecated
    protected void setReadPending(boolean readPending) {
        void var2_2;
        if (!this.isRegistered()) {
            void var1_1;
            this.readPending = var1_1;
            return;
        }
        NioEventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.setReadPending0(readPending);
            return;
        }
        var2_2.execute(new Runnable(this, readPending){
            final /* synthetic */ boolean val$readPending;
            final /* synthetic */ AbstractNioChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$readPending = bl;
            }

            @Override
            public void run() {
                AbstractNioChannel.access$100(this.this$0, this.val$readPending);
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected final void clearReadPending() {
        void var1_1;
        if (!this.isRegistered()) {
            this.readPending = false;
            return;
        }
        NioEventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.clearReadPending0();
            return;
        }
        var1_1.execute(this.clearReadPendingRunnable);
    }

    /*
     * WARNING - void declaration
     */
    private void setReadPending0(boolean readPending) {
        void var1_1;
        this.readPending = readPending;
        if (var1_1 == false) {
            ((AbstractNioUnsafe)this.unsafe()).removeReadOp();
        }
    }

    private void clearReadPending0() {
        this.readPending = false;
        ((AbstractNioUnsafe)this.unsafe()).removeReadOp();
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof NioEventLoop;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doRegister() throws Exception {
        boolean selected = false;
        while (true) {
            try {
                this.selectionKey = this.javaChannel().register(this.eventLoop().unwrappedSelector(), 0, this);
                return;
            }
            catch (CancelledKeyException e) {
                void var2_2;
                if (!selected) {
                    this.eventLoop().selectNow();
                    selected = true;
                    continue;
                }
                throw var2_2;
            }
            break;
        }
    }

    @Override
    protected void doDeregister() throws Exception {
        this.eventLoop().cancel(this.selectionKey());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doBeginRead() throws Exception {
        SelectionKey selectionKey = this.selectionKey;
        if (!selectionKey.isValid()) {
            return;
        }
        this.readPending = true;
        int interestOps = selectionKey.interestOps();
        if ((interestOps & this.readInterestOp) == 0) {
            void var2_2;
            void var1_1;
            var1_1.interestOps(var2_2 | this.readInterestOp);
        }
    }

    protected abstract boolean doConnect(SocketAddress var1, SocketAddress var2) throws Exception;

    protected abstract void doFinishConnect() throws Exception;

    /*
     * WARNING - void declaration
     */
    protected final ByteBuf newDirectBuffer(ByteBuf buf) {
        void var1_1;
        ByteBuf directBuf;
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            ReferenceCountUtil.safeRelease((Object)buf);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator alloc = this.alloc();
        if (alloc.isDirectBufferPooled()) {
            directBuf = alloc.directBuffer(readableBytes);
            ByteBuf byteBuf = buf;
            directBuf.writeBytes(byteBuf, byteBuf.readerIndex(), readableBytes);
            ReferenceCountUtil.safeRelease((Object)buf);
            return directBuf;
        }
        directBuf = ByteBufUtil.threadLocalDirectBuffer();
        if (directBuf != null) {
            void var3_3;
            void var2_2;
            ByteBuf byteBuf = buf;
            directBuf.writeBytes(byteBuf, byteBuf.readerIndex(), (int)var2_2);
            ReferenceCountUtil.safeRelease((Object)buf);
            return var3_3;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final ByteBuf newDirectBuffer(ReferenceCounted holder, ByteBuf buf) {
        void var2_2;
        ByteBuf directBuf;
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            ReferenceCountUtil.safeRelease((Object)holder);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator alloc = this.alloc();
        if (alloc.isDirectBufferPooled()) {
            directBuf = alloc.directBuffer(readableBytes);
            ByteBuf byteBuf = buf;
            directBuf.writeBytes(byteBuf, byteBuf.readerIndex(), readableBytes);
            ReferenceCountUtil.safeRelease((Object)holder);
            return directBuf;
        }
        directBuf = ByteBufUtil.threadLocalDirectBuffer();
        if (directBuf != null) {
            void var3_3;
            ByteBuf byteBuf = buf;
            directBuf.writeBytes(byteBuf, byteBuf.readerIndex(), (int)var3_3);
            ReferenceCountUtil.safeRelease((Object)holder);
            return directBuf;
        }
        if (holder != buf) {
            void var1_1;
            buf.retain();
            ReferenceCountUtil.safeRelease((Object)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doClose() throws Exception {
        Future<?> future;
        ChannelPromise promise = this.connectPromise;
        if (promise != null) {
            promise.tryFailure(new ClosedChannelException());
            this.connectPromise = null;
        }
        if ((future = this.connectTimeoutFuture) != null) {
            void var1_1;
            var1_1.cancel(false);
            this.connectTimeoutFuture = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(AbstractNioChannel x0, boolean x1) {
        void var1_1;
        x0.setReadPending0((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ChannelPromise access$202(AbstractNioChannel x0, ChannelPromise x1) {
        void var1_1;
        x0.connectPromise = var1_1;
        return x0.connectPromise;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SocketAddress access$302(AbstractNioChannel x0, SocketAddress x1) {
        void var1_1;
        x0.requestedRemoteAddress = var1_1;
        return x0.requestedRemoteAddress;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Future access$402(AbstractNioChannel x0, Future x1) {
        void var1_1;
        x0.connectTimeoutFuture = var1_1;
        return x0.connectTimeoutFuture;
    }

    protected abstract class AbstractNioUnsafe
    extends AbstractChannel.AbstractUnsafe
    implements NioUnsafe {
        /*
         * WARNING - void declaration
         */
        protected AbstractNioUnsafe() {
            void var1_1;
            super((AbstractChannel)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected final void removeReadOp() {
            SelectionKey key = AbstractNioChannel.this.selectionKey();
            if (!key.isValid()) {
                return;
            }
            int interestOps = key.interestOps();
            if ((interestOps & AbstractNioChannel.this.readInterestOp) != 0) {
                void var2_2;
                void var1_1;
                var1_1.interestOps(var2_2 & ~AbstractNioChannel.this.readInterestOp);
            }
        }

        @Override
        public final SelectableChannel ch() {
            return AbstractNioChannel.this.javaChannel();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (promise.isDone() || !this.ensureOpen(promise)) {
                return;
            }
            try {
                if (AbstractNioChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                boolean wasActive = AbstractNioChannel.this.isActive();
                if (!AbstractNioChannel.this.doConnect(remoteAddress, localAddress)) {
                    AbstractNioChannel.access$202(AbstractNioChannel.this, promise);
                    AbstractNioChannel.access$302(AbstractNioChannel.this, remoteAddress);
                    int connectTimeoutMillis = AbstractNioChannel.this.config().getConnectTimeoutMillis();
                    if (connectTimeoutMillis > 0) {
                        void var2_3;
                        AbstractNioChannel.access$402(AbstractNioChannel.this, (Future)AbstractNioChannel.this.eventLoop().schedule(new Runnable(this, connectTimeoutMillis, remoteAddress){
                            final /* synthetic */ int val$connectTimeoutMillis;
                            final /* synthetic */ SocketAddress val$remoteAddress;
                            final /* synthetic */ AbstractNioUnsafe this$1;
                            {
                                void var1_1;
                                this.this$1 = var1_1;
                                this.val$connectTimeoutMillis = n;
                                this.val$remoteAddress = socketAddress;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public void run() {
                                void var1_1;
                                ChannelPromise connectPromise = this.this$1.AbstractNioChannel.this.connectPromise;
                                if (connectPromise != null && !connectPromise.isDone() && var1_1.tryFailure((Throwable)new ConnectTimeoutException("connection timed out after " + this.val$connectTimeoutMillis + " ms: " + this.val$remoteAddress))) {
                                    this.this$1.close(this.this$1.voidPromise());
                                }
                            }
                        }, (long)var2_3, TimeUnit.MILLISECONDS));
                    }
                    promise.addListener(new ChannelFutureListener(this){
                        final /* synthetic */ AbstractNioUnsafe this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                        }

                        public void operationComplete(ChannelFuture future) {
                            if (future.isCancelled()) {
                                if (this.this$1.AbstractNioChannel.this.connectTimeoutFuture != null) {
                                    this.this$1.AbstractNioChannel.this.connectTimeoutFuture.cancel(false);
                                }
                                AbstractNioChannel.access$202(this.this$1.AbstractNioChannel.this, null);
                                this.this$1.close(this.this$1.voidPromise());
                            }
                        }
                    });
                    return;
                }
                this.fulfillConnectPromise(promise, wasActive);
            }
            catch (Throwable t) {
                void var1_1;
                void var3_4;
                var3_4.tryFailure(this.annotateConnectException(t, (SocketAddress)var1_1));
                this.closeIfClosed();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fulfillConnectPromise(ChannelPromise promise, boolean wasActive) {
            void var1_2;
            void var3_4;
            void var2_3;
            if (promise == null) {
                return;
            }
            boolean active = AbstractNioChannel.this.isActive();
            boolean promiseSet = promise.trySuccess();
            if (var2_3 == false && var3_4 != false) {
                AbstractNioChannel.this.pipeline().fireChannelActive();
            }
            if (var1_2 == false) {
                AbstractNioUnsafe abstractNioUnsafe = this;
                abstractNioUnsafe.close(abstractNioUnsafe.voidPromise());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fulfillConnectPromise(ChannelPromise promise, Throwable cause) {
            void var2_2;
            void var1_1;
            if (promise == null) {
                return;
            }
            var1_1.tryFailure((Throwable)var2_2);
            this.closeIfClosed();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void finishConnect() {
            assert (AbstractNioChannel.this.eventLoop().inEventLoop());
            try {
                boolean wasActive = AbstractNioChannel.this.isActive();
                AbstractNioChannel.this.doFinishConnect();
                AbstractNioUnsafe abstractNioUnsafe = this;
                abstractNioUnsafe.fulfillConnectPromise(abstractNioUnsafe.AbstractNioChannel.this.connectPromise, wasActive);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                AbstractNioUnsafe abstractNioUnsafe = this;
                abstractNioUnsafe.fulfillConnectPromise(abstractNioUnsafe.AbstractNioChannel.this.connectPromise, this.annotateConnectException((Throwable)var1_2, AbstractNioChannel.this.requestedRemoteAddress));
                return;
            }
            finally {
                if (AbstractNioChannel.this.connectTimeoutFuture != null) {
                    AbstractNioChannel.this.connectTimeoutFuture.cancel(false);
                }
                AbstractNioChannel.access$202(AbstractNioChannel.this, null);
            }
        }

        @Override
        protected final void flush0() {
            if (!this.isFlushPending()) {
                super.flush0();
            }
        }

        @Override
        public final void forceFlush() {
            super.flush0();
        }

        /*
         * WARNING - void declaration
         */
        private boolean isFlushPending() {
            void var1_1;
            SelectionKey selectionKey = AbstractNioChannel.this.selectionKey();
            return selectionKey.isValid() && (var1_1.interestOps() & 4) != 0;
        }
    }

    public static interface NioUnsafe
    extends Channel.Unsafe {
        public SelectableChannel ch();

        public void finishConnect();

        public void read();

        public void forceFlush();
    }
}

