/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

public abstract class AbstractNioByteChannel
extends AbstractNioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';
    private final Runnable flushTask = new Runnable(this){
        final /* synthetic */ AbstractNioByteChannel this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            ((AbstractNioChannel.AbstractNioUnsafe)this.this$0.unsafe()).flush0();
        }
    };
    private boolean inputClosedSeenErrorOnRead;

    /*
     * WARNING - void declaration
     */
    protected AbstractNioByteChannel(Channel parent, SelectableChannel ch) {
        super((Channel)var1_1, (SelectableChannel)var2_2, 1);
        void var2_2;
        void var1_1;
    }

    protected abstract ChannelFuture shutdownInput();

    protected boolean isInputShutdown0() {
        return false;
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioByteUnsafe();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    /*
     * WARNING - void declaration
     */
    final boolean shouldBreakReadReady(ChannelConfig config) {
        void var1_1;
        return this.isInputShutdown0() && (this.inputClosedSeenErrorOnRead || !AbstractNioByteChannel.isAllowHalfClosure((ChannelConfig)var1_1));
    }

    private static boolean isAllowHalfClosure(ChannelConfig config) {
        ChannelConfig channelConfig;
        return config instanceof SocketChannelConfig && ((SocketChannelConfig)channelConfig).isAllowHalfClosure();
    }

    /*
     * WARNING - void declaration
     */
    protected final int doWrite0(ChannelOutboundBuffer in) throws Exception {
        void var1_1;
        Object object = in.current();
        if (object == null) {
            return 0;
        }
        void v0 = var1_1;
        return this.doWriteInternal((ChannelOutboundBuffer)v0, v0.current());
    }

    /*
     * WARNING - void declaration
     */
    private int doWriteInternal(ChannelOutboundBuffer in, Object msg) throws Exception {
        ByteBuf buf;
        if (msg instanceof ByteBuf) {
            buf = (ByteBuf)msg;
            if (!buf.isReadable()) {
                in.remove();
                return 0;
            }
            int localFlushedAmount = this.doWriteBytes(buf);
            if (localFlushedAmount > 0) {
                in.progress(localFlushedAmount);
                if (!buf.isReadable()) {
                    in.remove();
                }
                return 1;
            }
        } else if (buf instanceof FileRegion) {
            FileRegion region = (FileRegion)buf;
            if (region.transferred() >= region.count()) {
                in.remove();
                return 0;
            }
            long localFlushedAmount = this.doWriteFileRegion(region);
            if (localFlushedAmount > 0L) {
                void var2_2;
                in.progress(localFlushedAmount);
                if (region.transferred() >= var2_2.count()) {
                    void var1_1;
                    var1_1.remove();
                }
                return 1;
            }
        } else {
            throw new Error();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        void var2_2;
        void var3_3;
        int writeSpinCount = this.config().getWriteSpinCount();
        do {
            Object msg;
            if ((msg = in.current()) != null) continue;
            this.clearOpWrite();
            return;
        } while ((writeSpinCount -= this.doWriteInternal(in, var3_3)) > 0);
        this.incompleteWrite(var2_2 < 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final Object filterOutboundMessage(Object msg) {
        void var1_1;
        if (msg instanceof ByteBuf) {
            void var2_2;
            ByteBuf buf = (ByteBuf)msg;
            if (buf.isDirect()) {
                return msg;
            }
            return this.newDirectBuffer((ByteBuf)var2_2);
        }
        if (msg instanceof FileRegion) {
            return msg;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)var1_1) + EXPECTED_TYPES);
    }

    protected final void incompleteWrite(boolean setOpWrite) {
        if (setOpWrite) {
            this.setOpWrite();
            return;
        }
        this.clearOpWrite();
        this.eventLoop().execute(this.flushTask);
    }

    protected abstract long doWriteFileRegion(FileRegion var1) throws Exception;

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract int doWriteBytes(ByteBuf var1) throws Exception;

    /*
     * WARNING - void declaration
     */
    protected final void setOpWrite() {
        SelectionKey key = this.selectionKey();
        if (!key.isValid()) {
            return;
        }
        int interestOps = key.interestOps();
        if ((interestOps & 4) == 0) {
            void var2_2;
            void var1_1;
            var1_1.interestOps(var2_2 | 4);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void clearOpWrite() {
        SelectionKey key = this.selectionKey();
        if (!key.isValid()) {
            return;
        }
        int interestOps = key.interestOps();
        if ((interestOps & 4) != 0) {
            void var2_2;
            void var1_1;
            var1_1.interestOps((int)(var2_2 & 0xFFFFFFFB));
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$102(AbstractNioByteChannel x0, boolean x1) {
        void var1_1;
        x0.inputClosedSeenErrorOnRead = var1_1;
        return x0.inputClosedSeenErrorOnRead;
    }

    protected class NioByteUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        /*
         * WARNING - void declaration
         */
        protected NioByteUnsafe() {
            void var1_1;
            super((AbstractNioChannel)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void closeOnRead(ChannelPipeline pipeline) {
            if (!AbstractNioByteChannel.this.isInputShutdown0()) {
                if (AbstractNioByteChannel.isAllowHalfClosure(AbstractNioByteChannel.this.config())) {
                    AbstractNioByteChannel.this.shutdownInput();
                    pipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                    return;
                }
                NioByteUnsafe nioByteUnsafe = this;
                nioByteUnsafe.close(nioByteUnsafe.voidPromise());
                return;
            }
            if (!AbstractNioByteChannel.this.inputClosedSeenErrorOnRead) {
                void var1_1;
                AbstractNioByteChannel.access$102(AbstractNioByteChannel.this, true);
                var1_1.fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean close, RecvByteBufAllocator.Handle allocHandle) {
            void var3_3;
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    AbstractNioByteChannel.this.readPending = false;
                    pipeline.fireChannelRead(byteBuf);
                } else {
                    void var2_2;
                    var2_2.release();
                }
            }
            allocHandle.readComplete();
            pipeline.fireChannelReadComplete();
            pipeline.fireExceptionCaught(cause);
            if (close || cause instanceof OutOfMemoryError || var3_3 instanceof IOException) {
                void var1_1;
                this.closeOnRead((ChannelPipeline)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void read() {
            ChannelConfig config = AbstractNioByteChannel.this.config();
            if (AbstractNioByteChannel.this.shouldBreakReadReady(config)) {
                AbstractNioByteChannel.this.clearReadPending();
                return;
            }
            ChannelPipeline pipeline = AbstractNioByteChannel.this.pipeline();
            ByteBufAllocator allocator = config.getAllocator();
            RecvByteBufAllocator.Handle allocHandle = this.recvBufAllocHandle();
            allocHandle.reset(config);
            ByteBuf byteBuf = null;
            boolean close = false;
            try {
                do {
                    byteBuf = allocHandle.allocate(allocator);
                    allocHandle.lastBytesRead(AbstractNioByteChannel.this.doReadBytes(byteBuf));
                    if (allocHandle.lastBytesRead() <= 0) {
                        byteBuf.release();
                        byteBuf = null;
                        close = allocHandle.lastBytesRead() < 0;
                        if (!close) break;
                        AbstractNioByteChannel.this.readPending = false;
                        break;
                    }
                    allocHandle.incMessagesRead(1);
                    AbstractNioByteChannel.this.readPending = false;
                    pipeline.fireChannelRead(byteBuf);
                    byteBuf = null;
                } while (allocHandle.continueReading());
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                if (close) {
                    this.closeOnRead(pipeline);
                }
                if (AbstractNioByteChannel.this.readPending || config.isAutoRead()) return;
            }
            catch (Throwable t) {
                try {
                    void var3_5;
                    void var2_2;
                    this.handleReadException((ChannelPipeline)var2_2, byteBuf, (Throwable)var3_5, close, allocHandle);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (AbstractNioByteChannel.this.readPending || config.isAutoRead()) return;
                    this.removeReadOp();
                }
            }
            this.removeReadOp();
            return;
        }
    }
}

