/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.channel.AbstractServerChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.channel.PreferHeapByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ServerChannelRecvByteBufAllocator;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalChannelRegistry;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;

public class LocalServerChannel
extends AbstractServerChannel {
    private final ChannelConfig config;
    private final Queue<Object> inboundBuffer;
    private final Runnable shutdownHook;
    private volatile int state;
    private volatile LocalAddress localAddress;
    private volatile boolean acceptInProgress;

    public LocalServerChannel() {
        LocalServerChannel localServerChannel = this;
        this.config = new DefaultChannelConfig(localServerChannel, localServerChannel, new ServerChannelRecvByteBufAllocator()){
            final /* synthetic */ LocalServerChannel this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((Channel)var2_2, (RecvByteBufAllocator)var3_3);
            }
        };
        this.inboundBuffer = new ArrayDeque<Object>();
        this.shutdownHook = new Runnable(this){
            final /* synthetic */ LocalServerChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.unsafe().close(this.this$0.unsafe().voidPromise());
            }
        };
        this.config().setAllocator(new PreferHeapByteBufAllocator(this.config.getAllocator()));
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public LocalAddress localAddress() {
        return (LocalAddress)super.localAddress();
    }

    @Override
    public LocalAddress remoteAddress() {
        return (LocalAddress)super.remoteAddress();
    }

    @Override
    public boolean isOpen() {
        return this.state < 2;
    }

    @Override
    public boolean isActive() {
        return this.state == 1;
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof SingleThreadEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    protected void doRegister() throws Exception {
        ((SingleThreadEventExecutor)this.eventLoop()).addShutdownHook(this.shutdownHook);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, (SocketAddress)var1_1);
        this.state = 1;
    }

    @Override
    protected void doClose() throws Exception {
        if (this.state <= 1) {
            if (this.localAddress != null) {
                LocalChannelRegistry.unregister(this.localAddress);
                this.localAddress = null;
            }
            this.state = 2;
        }
    }

    @Override
    protected void doDeregister() throws Exception {
        ((SingleThreadEventExecutor)this.eventLoop()).removeShutdownHook(this.shutdownHook);
    }

    @Override
    protected void doBeginRead() throws Exception {
        if (this.acceptInProgress) {
            return;
        }
        Queue<Object> queue = this.inboundBuffer;
        if (queue.isEmpty()) {
            this.acceptInProgress = true;
            return;
        }
        this.readInbound();
    }

    /*
     * WARNING - void declaration
     */
    LocalChannel serve(LocalChannel peer) {
        void var1_1;
        LocalChannel child = this.newLocalChannel(peer);
        if (this.eventLoop().inEventLoop()) {
            this.serve0(child);
        } else {
            this.eventLoop().execute(new Runnable(this, child){
                final /* synthetic */ LocalChannel val$child;
                final /* synthetic */ LocalServerChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$child = localChannel;
                }

                @Override
                public void run() {
                    LocalServerChannel.access$000(this.this$0, this.val$child);
                }
            });
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void readInbound() {
        void var2_2;
        void var1_1;
        Object m;
        RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
        handle.reset(this.config());
        ChannelPipeline pipeline = this.pipeline();
        while ((m = this.inboundBuffer.poll()) != null) {
            void var3_3;
            pipeline.fireChannelRead(var3_3);
            if (handle.continueReading()) continue;
        }
        var1_1.readComplete();
        var2_2.fireChannelReadComplete();
    }

    /*
     * WARNING - void declaration
     */
    protected LocalChannel newLocalChannel(LocalChannel peer) {
        void var1_1;
        return new LocalChannel(this, (LocalChannel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void serve0(LocalChannel child) {
        void var1_1;
        this.inboundBuffer.add(var1_1);
        if (this.acceptInProgress) {
            this.acceptInProgress = false;
            this.readInbound();
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(LocalServerChannel x0, LocalChannel x1) {
        void var1_1;
        x0.serve0((LocalChannel)var1_1);
    }
}

