/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.local.LocalAddress;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;

final class LocalChannelRegistry {
    private static final ConcurrentMap<LocalAddress, Channel> boundChannels = PlatformDependent.newConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    static LocalAddress register(Channel channel, LocalAddress oldLocalAddress, SocketAddress localAddress) {
        void var1_1;
        Channel boundChannel;
        void var2_2;
        if (oldLocalAddress != null) {
            throw new ChannelException("already bound");
        }
        if (!(localAddress instanceof LocalAddress)) {
            throw new ChannelException("unsupported address type: " + StringUtil.simpleClassName((Object)localAddress));
        }
        LocalAddress addr = (LocalAddress)var2_2;
        if (LocalAddress.ANY.equals(addr)) {
            addr = new LocalAddress(channel);
        }
        if ((boundChannel = boundChannels.putIfAbsent(addr, channel)) != null) {
            Channel channel2;
            throw new ChannelException("address already in use by: " + channel2);
        }
        return var1_1;
    }

    static Channel get(SocketAddress localAddress) {
        SocketAddress socketAddress;
        return (Channel)boundChannels.get(socketAddress);
    }

    static void unregister(LocalAddress localAddress) {
        LocalAddress localAddress2;
        boundChannels.remove(localAddress2);
    }

    private LocalChannelRegistry() {
    }
}

