/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.channel.PreferHeapByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannelRegistry;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class LocalChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LocalChannel.class);
    private static final AtomicReferenceFieldUpdater<LocalChannel, Future> FINISH_READ_FUTURE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LocalChannel.class, Future.class, "finishReadFuture");
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final int MAX_READER_STACK_DEPTH = 8;
    private final ChannelConfig config = new DefaultChannelConfig(this);
    final Queue<Object> inboundBuffer = PlatformDependent.newSpscQueue();
    private final Runnable readTask = new Runnable(this){
        final /* synthetic */ LocalChannel this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            if (!this.this$0.inboundBuffer.isEmpty()) {
                this.this$0.readInbound();
            }
        }
    };
    private final Runnable shutdownHook = new Runnable(this){
        final /* synthetic */ LocalChannel this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            this.this$0.unsafe().close(this.this$0.unsafe().voidPromise());
        }
    };
    private volatile State state;
    private volatile LocalChannel peer;
    private volatile LocalAddress localAddress;
    private volatile LocalAddress remoteAddress;
    private volatile ChannelPromise connectPromise;
    private volatile boolean readInProgress;
    private volatile boolean writeInProgress;
    private volatile Future<?> finishReadFuture;

    public LocalChannel() {
        super(null);
        this.config().setAllocator(new PreferHeapByteBufAllocator(this.config.getAllocator()));
    }

    /*
     * WARNING - void declaration
     */
    protected LocalChannel(LocalServerChannel parent, LocalChannel peer) {
        super(parent);
        void var2_2;
        void var1_1;
        this.config().setAllocator(new PreferHeapByteBufAllocator(this.config.getAllocator()));
        this.peer = peer;
        this.localAddress = var1_1.localAddress();
        this.remoteAddress = var2_2.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public LocalServerChannel parent() {
        return (LocalServerChannel)super.parent();
    }

    @Override
    public LocalAddress localAddress() {
        return (LocalAddress)super.localAddress();
    }

    @Override
    public LocalAddress remoteAddress() {
        return (LocalAddress)super.remoteAddress();
    }

    @Override
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == State.CONNECTED;
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new LocalUnsafe();
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof SingleThreadEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doRegister() throws Exception {
        if (this.peer != null && this.parent() != null) {
            void var1_1;
            LocalChannel peer = this.peer;
            this.state = State.CONNECTED;
            peer.remoteAddress = this.parent() == null ? null : this.parent().localAddress();
            peer.state = State.CONNECTED;
            peer.eventLoop().execute(new Runnable(this, (LocalChannel)var1_1){
                final /* synthetic */ LocalChannel val$peer;
                final /* synthetic */ LocalChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$peer = localChannel;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    void var1_1;
                    ChannelPromise promise = this.val$peer.connectPromise;
                    if (promise != null && var1_1.trySuccess()) {
                        this.val$peer.pipeline().fireChannelActive();
                    }
                }
            });
        }
        ((SingleThreadEventExecutor)this.eventLoop()).addShutdownHook(this.shutdownHook);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, (SocketAddress)var1_1);
        this.state = State.BOUND;
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doClose() throws Exception {
        LocalChannel peer = this.peer;
        State oldState = this.state;
        try {
            if (oldState != State.CLOSED) {
                ChannelPromise promise;
                if (this.localAddress != null) {
                    if (this.parent() == null) {
                        LocalChannelRegistry.unregister(this.localAddress);
                    }
                    this.localAddress = null;
                }
                this.state = State.CLOSED;
                if (this.writeInProgress && peer != null) {
                    this.finishPeerRead(peer);
                }
                if ((promise = this.connectPromise) != null) {
                    promise.tryFailure(new ClosedChannelException());
                    this.connectPromise = null;
                }
            }
            if (peer != null) {
                this.peer = null;
                EventLoop peerEventLoop = peer.eventLoop();
                boolean peerIsActive = peer.isActive();
                try {
                    peerEventLoop.execute(new Runnable(this, peer, peerIsActive){
                        final /* synthetic */ LocalChannel val$peer;
                        final /* synthetic */ boolean val$peerIsActive;
                        final /* synthetic */ LocalChannel this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$peer = localChannel;
                            this.val$peerIsActive = bl;
                        }

                        @Override
                        public void run() {
                            LocalChannel.access$300(this.val$peer, this.val$peerIsActive);
                        }
                    });
                }
                catch (Throwable cause) {
                    void var3_4;
                    logger.warn("Releasing Inbound Queues for channels {}-{} because exception occurred!", new Object[]{this, peer, cause});
                    if (var3_4.inEventLoop()) {
                        peer.releaseInboundBuffers();
                    } else {
                        void var1_1;
                        var1_1.close();
                    }
                    PlatformDependent.throwException((Throwable)cause);
                }
            }
            if (oldState != null && oldState != State.CLOSED) {
                this.releaseInboundBuffers();
                return;
            }
        }
        catch (Throwable throwable) {
            void var2_3;
            if (oldState != null && var2_3 != State.CLOSED) {
                this.releaseInboundBuffers();
            }
            throw throwable;
        }
    }

    private void tryClose(boolean isActive) {
        if (isActive) {
            this.unsafe().close(this.unsafe().voidPromise());
            return;
        }
        this.releaseInboundBuffers();
    }

    @Override
    protected void doDeregister() throws Exception {
        ((SingleThreadEventExecutor)this.eventLoop()).removeShutdownHook(this.shutdownHook);
    }

    /*
     * WARNING - void declaration
     */
    private void readInbound() {
        void var2_2;
        void var1_1;
        Object received;
        RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
        handle.reset(this.config());
        ChannelPipeline pipeline = this.pipeline();
        while ((received = this.inboundBuffer.poll()) != null) {
            void var3_3;
            if (received instanceof ByteBuf && this.inboundBuffer.peek() instanceof ByteBuf) {
                ByteBuf msg = (ByteBuf)received;
                ByteBuf output = handle.allocate(this.alloc());
                if (msg.readableBytes() < output.writableBytes()) {
                    ByteBuf byteBuf = msg;
                    output.writeBytes(byteBuf, byteBuf.readerIndex(), msg.readableBytes());
                    msg.release();
                    while ((received = this.inboundBuffer.peek()) instanceof ByteBuf && ((ByteBuf)received).readableBytes() < output.writableBytes()) {
                        this.inboundBuffer.poll();
                        ByteBuf byteBuf2 = msg = (ByteBuf)received;
                        output.writeBytes(byteBuf2, byteBuf2.readerIndex(), msg.readableBytes());
                        msg.release();
                    }
                    handle.lastBytesRead(output.readableBytes());
                    received = output;
                } else {
                    handle.lastBytesRead(output.capacity());
                    output.release();
                }
            }
            handle.incMessagesRead(1);
            pipeline.fireChannelRead(var3_3);
            if (handle.continueReading()) continue;
        }
        var1_1.readComplete();
        var2_2.fireChannelReadComplete();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doBeginRead() throws Exception {
        block7: {
            block6: {
                if (this.readInProgress) {
                    return;
                }
                Queue<Object> queue = this.inboundBuffer;
                if (queue.isEmpty()) {
                    this.readInProgress = true;
                    return;
                }
                InternalThreadLocalMap threadLocals = InternalThreadLocalMap.get();
                int stackDepth = threadLocals.localChannelReaderStackDepth();
                if (stackDepth >= 8) break block6;
                threadLocals.setLocalChannelReaderStackDepth(stackDepth + 1);
                try {
                    this.readInbound();
                }
                catch (Throwable throwable) {
                    void var2_2;
                    queue.setLocalChannelReaderStackDepth((int)var2_2);
                    throw throwable;
                }
                threadLocals.setLocalChannelReaderStackDepth(stackDepth);
                break block7;
            }
            try {
                this.eventLoop().execute(this.readTask);
                return;
            }
            catch (Throwable cause) {
                void var3_4;
                logger.warn("Closing Local channels {}-{} because exception occurred!", new Object[]{this, this.peer, cause});
                this.close();
                this.peer.close();
                PlatformDependent.throwException((Throwable)var3_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        void var2_3;
        switch (this.state) {
            case OPEN: 
            case BOUND: {
                throw new NotYetConnectedException();
            }
            case CLOSED: {
                throw new ClosedChannelException();
            }
        }
        LocalChannel peer = this.peer;
        this.writeInProgress = true;
        try {
            Object msg;
            ClosedChannelException exception = null;
            while ((msg = in.current()) != null) {
                try {
                    if (peer.state == State.CONNECTED) {
                        peer.inboundBuffer.add(ReferenceCountUtil.retain((Object)msg));
                        in.remove();
                        continue;
                    }
                    if (exception == null) {
                        exception = new ClosedChannelException();
                    }
                    in.remove(exception);
                }
                catch (Throwable cause) {
                    in.remove(cause);
                }
            }
        }
        finally {
            this.writeInProgress = false;
        }
        this.finishPeerRead((LocalChannel)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private void finishPeerRead(LocalChannel peer) {
        void var1_1;
        if (peer.eventLoop() == this.eventLoop() && !peer.writeInProgress) {
            this.finishPeerRead0(peer);
            return;
        }
        this.runFinishPeerReadTask((LocalChannel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void runFinishPeerReadTask(LocalChannel peer) {
        Runnable finishPeerReadTask = new Runnable(this, peer){
            final /* synthetic */ LocalChannel val$peer;
            final /* synthetic */ LocalChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$peer = localChannel;
            }

            @Override
            public void run() {
                LocalChannel.access$400(this.this$0, this.val$peer);
            }
        };
        try {
            if (!peer.writeInProgress) {
                peer.eventLoop().execute(finishPeerReadTask);
                return;
            }
            peer.finishReadFuture = peer.eventLoop().submit(finishPeerReadTask);
        }
        catch (Throwable cause) {
            void var2_3;
            void var1_1;
            logger.warn("Closing Local channels {}-{} because exception occurred!", new Object[]{this, peer, cause});
            this.close();
            var1_1.close();
            PlatformDependent.throwException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void releaseInboundBuffers() {
        Object msg;
        assert (this.eventLoop() == null || this.eventLoop().inEventLoop());
        this.readInProgress = false;
        Queue<Object> inboundBuffer = this.inboundBuffer;
        while ((msg = inboundBuffer.poll()) != null) {
            void var2_2;
            ReferenceCountUtil.release((Object)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void finishPeerRead0(LocalChannel peer) {
        Future<?> peerFinishReadFuture = peer.finishReadFuture;
        if (peerFinishReadFuture != null) {
            void var2_2;
            if (!peerFinishReadFuture.isDone()) {
                this.runFinishPeerReadTask(peer);
                return;
            }
            FINISH_READ_FUTURE_UPDATER.compareAndSet(peer, (Future)var2_2, null);
        }
        if (peer.readInProgress && !peer.inboundBuffer.isEmpty()) {
            void var1_1;
            peer.readInProgress = false;
            super.readInbound();
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(LocalChannel x0, boolean x1) {
        void var1_1;
        x0.tryClose((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(LocalChannel x0, LocalChannel x1) {
        void var1_1;
        x0.finishPeerRead0((LocalChannel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ChannelPromise access$202(LocalChannel x0, ChannelPromise x1) {
        void var1_1;
        x0.connectPromise = var1_1;
        return x0.connectPromise;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ LocalChannel access$602(LocalChannel x0, LocalChannel x1) {
        void var1_1;
        x0.peer = var1_1;
        return x0.peer;
    }

    private class LocalUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private LocalUnsafe() {
            super(LocalChannel.this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            void var1_1;
            void var2_2;
            Channel boundChannel;
            Serializable cause;
            if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
                return;
            }
            if (LocalChannel.this.state == State.CONNECTED) {
                cause = new AlreadyConnectedException();
                this.safeSetFailure(promise, (Throwable)cause);
                LocalChannel.this.pipeline().fireExceptionCaught((Throwable)cause);
                return;
            }
            if (LocalChannel.this.connectPromise != null) {
                throw new ConnectionPendingException();
            }
            LocalChannel.access$202(LocalChannel.this, promise);
            if (LocalChannel.this.state != State.BOUND && cause == null) {
                cause = new LocalAddress(LocalChannel.this);
            }
            if (cause != null) {
                try {
                    LocalChannel.this.doBind((SocketAddress)cause);
                }
                catch (Throwable t) {
                    this.safeSetFailure(promise, t);
                    LocalUnsafe localUnsafe = this;
                    localUnsafe.close(localUnsafe.voidPromise());
                    return;
                }
            }
            if (!((boundChannel = LocalChannelRegistry.get(remoteAddress)) instanceof LocalServerChannel)) {
                void var3_4;
                ConnectException cause2 = new ConnectException("connection refused: " + remoteAddress);
                this.safeSetFailure((ChannelPromise)var3_4, cause2);
                LocalUnsafe localUnsafe = this;
                localUnsafe.close(localUnsafe.voidPromise());
                return;
            }
            LocalServerChannel serverChannel = (LocalServerChannel)var2_2;
            LocalChannel.access$602(LocalChannel.this, var1_1.serve(LocalChannel.this));
        }
    }

    private static enum State {
        OPEN,
        BOUND,
        CONNECTED,
        CLOSED;

    }
}

