/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.group;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupException;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.util.concurrent.BlockingOperationException;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

final class DefaultChannelGroupFuture
extends DefaultPromise<Void>
implements ChannelGroupFuture {
    private final ChannelGroup group;
    private final Map<Channel, ChannelFuture> futures;
    private int successCount;
    private int failureCount;
    private final ChannelFutureListener childListener = new ChannelFutureListener(this){
        final /* synthetic */ DefaultChannelGroupFuture this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void operationComplete(ChannelFuture future) throws Exception {
            void var1_2;
            boolean success = future.isSuccess();
            DefaultChannelGroupFuture defaultChannelGroupFuture = this.this$0;
            synchronized (defaultChannelGroupFuture) {
                boolean callSetDone;
                if (success) {
                    this.this$0.successCount++;
                } else {
                    this.this$0.failureCount++;
                }
                boolean bl = callSetDone = this.this$0.successCount + this.this$0.failureCount == this.this$0.futures.size();
                assert (this.this$0.successCount + this.this$0.failureCount <= this.this$0.futures.size());
            }
            if (var1_2 != false) {
                if (this.this$0.failureCount > 0) {
                    ArrayList<DefaultEntry<Channel, Throwable>> failed = new ArrayList<DefaultEntry<Channel, Throwable>>(this.this$0.failureCount);
                    for (ChannelFuture f : this.this$0.futures.values()) {
                        void var3_6;
                        if (f.isSuccess()) continue;
                        failed.add(new DefaultEntry<Channel, Throwable>(f.channel(), var3_6.cause()));
                    }
                    DefaultChannelGroupFuture.access$300(this.this$0, new ChannelGroupException((Collection<Map.Entry<Channel, Throwable>>)((Object)defaultChannelGroupFuture)));
                    return;
                }
                this.this$0.setSuccess0();
            }
        }
    };

    /*
     * WARNING - void declaration
     */
    DefaultChannelGroupFuture(ChannelGroup group, Collection<ChannelFuture> futures, EventExecutor executor) {
        super(executor);
        void var1_1;
        Iterator<Object> iterator;
        this.group = (ChannelGroup)ObjectUtil.checkNotNull((Object)group, (String)"group");
        ObjectUtil.checkNotNull(futures, (String)"futures");
        LinkedHashMap<Channel, void> futureMap = new LinkedHashMap<Channel, void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ChannelFuture channelFuture;
            ChannelFuture f = (ChannelFuture)iterator.next();
            futureMap.put(f.channel(), (void)channelFuture);
        }
        this.futures = Collections.unmodifiableMap(var1_1);
        for (ChannelFuture channelFuture : this.futures.values()) {
            channelFuture.addListener(this.childListener);
        }
        if (this.futures.isEmpty()) {
            this.setSuccess0();
        }
    }

    /*
     * WARNING - void declaration
     */
    DefaultChannelGroupFuture(ChannelGroup group, Map<Channel, ChannelFuture> futures, EventExecutor executor) {
        super((EventExecutor)var3_3);
        ChannelFuture channelFuture2;
        Iterator<ChannelFuture> iterator;
        void var3_3;
        this.group = iterator;
        this.futures = Collections.unmodifiableMap(channelFuture2);
        for (ChannelFuture channelFuture2 : this.futures.values()) {
            channelFuture2.addListener(this.childListener);
        }
        if (this.futures.isEmpty()) {
            this.setSuccess0();
        }
    }

    @Override
    public final ChannelGroup group() {
        return this.group;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture find(Channel channel) {
        void var1_1;
        return this.futures.get(var1_1);
    }

    @Override
    public final Iterator<ChannelFuture> iterator() {
        return this.futures.values().iterator();
    }

    @Override
    public final synchronized boolean isPartialSuccess() {
        return this.successCount != 0 && this.successCount != this.futures.size();
    }

    @Override
    public final synchronized boolean isPartialFailure() {
        return this.failureCount != 0 && this.failureCount != this.futures.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultChannelGroupFuture addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        void var1_1;
        super.addListener((GenericFutureListener)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultChannelGroupFuture addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        void var1_1;
        super.addListeners((GenericFutureListener[])var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultChannelGroupFuture removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        void var1_1;
        super.removeListener((GenericFutureListener)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultChannelGroupFuture removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        void var1_1;
        super.removeListeners((GenericFutureListener[])var1_1);
        return this;
    }

    @Override
    public final DefaultChannelGroupFuture await() throws InterruptedException {
        super.await();
        return this;
    }

    @Override
    public final DefaultChannelGroupFuture awaitUninterruptibly() {
        super.awaitUninterruptibly();
        return this;
    }

    @Override
    public final DefaultChannelGroupFuture syncUninterruptibly() {
        super.syncUninterruptibly();
        return this;
    }

    @Override
    public final DefaultChannelGroupFuture sync() throws InterruptedException {
        super.sync();
        return this;
    }

    @Override
    public final ChannelGroupException cause() {
        return (ChannelGroupException)super.cause();
    }

    private void setSuccess0() {
        super.setSuccess(null);
    }

    /*
     * WARNING - void declaration
     */
    private void setFailure0(ChannelGroupException cause) {
        void var1_1;
        super.setFailure((Throwable)var1_1);
    }

    public final DefaultChannelGroupFuture setSuccess(Void result) {
        throw new IllegalStateException();
    }

    public final boolean trySuccess(Void result) {
        throw new IllegalStateException();
    }

    public final DefaultChannelGroupFuture setFailure(Throwable cause) {
        throw new IllegalStateException();
    }

    public final boolean tryFailure(Throwable cause) {
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    protected final void checkDeadLock() {
        void var1_1;
        EventExecutor e = this.executor();
        if (e != null && e != ImmediateEventExecutor.INSTANCE && var1_1.inEventLoop()) {
            throw new BlockingOperationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(DefaultChannelGroupFuture x0, ChannelGroupException x1) {
        void var1_1;
        x0.setFailure0((ChannelGroupException)var1_1);
    }

    private static final class DefaultEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        /*
         * WARNING - void declaration
         */
        DefaultEntry(K key, V value) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.value = var2_2;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V value) {
            throw new UnsupportedOperationException("read-only");
        }
    }
}

