/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.group;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelId;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelMatcher;
import io.netty.channel.group.ChannelMatchers;
import io.netty.channel.group.CombinedIterator;
import io.netty.channel.group.DefaultChannelGroupFuture;
import io.netty.channel.group.VoidChannelGroupFuture;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultChannelGroup
extends AbstractSet<Channel>
implements ChannelGroup {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final String name;
    private final EventExecutor executor;
    private final ConcurrentMap<ChannelId, Channel> serverChannels = PlatformDependent.newConcurrentHashMap();
    private final ConcurrentMap<ChannelId, Channel> nonServerChannels = PlatformDependent.newConcurrentHashMap();
    private final ChannelFutureListener remover = new ChannelFutureListener(this){
        final /* synthetic */ DefaultChannelGroup this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void operationComplete(ChannelFuture future) throws Exception {
            void var1_1;
            this.this$0.remove(var1_1.channel());
        }
    };
    private final VoidChannelGroupFuture voidFuture = new VoidChannelGroupFuture(this);
    private final boolean stayClosed;
    private volatile boolean closed;

    /*
     * WARNING - void declaration
     */
    public DefaultChannelGroup(EventExecutor executor) {
        this((EventExecutor)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultChannelGroup(String name, EventExecutor executor) {
        this((String)var1_1, (EventExecutor)var2_2, false);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultChannelGroup(EventExecutor executor, boolean stayClosed) {
        this("group-0x" + Integer.toHexString(nextId.incrementAndGet()), (EventExecutor)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultChannelGroup(String name, EventExecutor executor, boolean stayClosed) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)name, (String)"name");
        this.name = var1_1;
        this.executor = var2_2;
        this.stayClosed = var3_3;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Channel find(ChannelId id) {
        void var1_1;
        Channel c = (Channel)this.nonServerChannels.get(id);
        if (c != null) {
            void var2_2;
            return var2_2;
        }
        return (Channel)this.serverChannels.get(var1_1);
    }

    @Override
    public boolean isEmpty() {
        return this.nonServerChannels.isEmpty() && this.serverChannels.isEmpty();
    }

    @Override
    public int size() {
        return this.nonServerChannels.size() + this.serverChannels.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object o) {
        if (o instanceof ServerChannel) {
            return this.serverChannels.containsValue(o);
        }
        if (o instanceof Channel) {
            void var1_1;
            return this.nonServerChannels.containsValue(var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(Channel channel) {
        void var2_3;
        ConcurrentMap<ChannelId, Channel> concurrentMap = channel instanceof ServerChannel ? this.serverChannels : this.nonServerChannels;
        boolean added = concurrentMap.putIfAbsent(channel.id(), channel) == null;
        if (added) {
            channel.closeFuture().addListener(this.remover);
        }
        if (this.stayClosed && this.closed) {
            void var1_1;
            var1_1.close();
        }
        return (boolean)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object o) {
        void var2_2;
        Channel c = null;
        if (o instanceof ChannelId) {
            c = (Channel)this.nonServerChannels.remove(o);
            if (c == null) {
                c = (Channel)this.serverChannels.remove(o);
            }
        } else if (o instanceof Channel) {
            void var1_1;
            c = (Channel)var1_1;
            c = c instanceof ServerChannel ? (Channel)this.serverChannels.remove(c.id()) : (Channel)this.nonServerChannels.remove(c.id());
        }
        if (c == null) {
            return false;
        }
        var2_2.closeFuture().removeListener(this.remover);
        return true;
    }

    @Override
    public void clear() {
        this.nonServerChannels.clear();
        this.serverChannels.clear();
    }

    @Override
    public Iterator<Channel> iterator() {
        return new CombinedIterator<Channel>(this.serverChannels.values().iterator(), this.nonServerChannels.values().iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object[] toArray() {
        void var1_1;
        ArrayList channels = new ArrayList(this.size());
        channels.addAll(this.serverChannels.values());
        channels.addAll(this.nonServerChannels.values());
        return var1_1.toArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T[] toArray(T[] a) {
        void var1_1;
        void var2_2;
        ArrayList channels = new ArrayList(this.size());
        channels.addAll(this.serverChannels.values());
        channels.addAll(this.nonServerChannels.values());
        return var2_2.toArray((T[])var1_1);
    }

    @Override
    public ChannelGroupFuture close() {
        return this.close(ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture disconnect() {
        return this.disconnect(ChannelMatchers.all());
    }

    @Override
    public ChannelGroupFuture deregister() {
        return this.deregister(ChannelMatchers.all());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture write(Object message) {
        void var1_1;
        return this.write(var1_1, ChannelMatchers.all());
    }

    private static Object safeDuplicate(Object message) {
        Object object;
        if (message instanceof ByteBuf) {
            return ((ByteBuf)message).retainedDuplicate();
        }
        if (message instanceof ByteBufHolder) {
            return ((ByteBufHolder)message).retainedDuplicate();
        }
        return ReferenceCountUtil.retain((Object)object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture write(Object message, ChannelMatcher matcher) {
        void var2_2;
        void var1_1;
        return this.write(var1_1, (ChannelMatcher)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture write(Object message, ChannelMatcher matcher, boolean voidPromise) {
        void var2_2;
        void var1_1;
        ChannelGroupFuture future;
        ObjectUtil.checkNotNull((Object)message, (String)"message");
        ObjectUtil.checkNotNull((Object)matcher, (String)"matcher");
        if (voidPromise) {
            for (Channel c : this.nonServerChannels.values()) {
                if (!matcher.matches(c)) continue;
                c.write(DefaultChannelGroup.safeDuplicate(message), c.voidPromise());
            }
            future = this.voidFuture;
        } else {
            void var3_5;
            LinkedHashMap<Channel, ChannelFuture> futures = new LinkedHashMap<Channel, ChannelFuture>(this.nonServerChannels.size());
            for (Channel c : this.nonServerChannels.values()) {
                if (!future.matches(c)) continue;
                Channel channel = c;
                futures.put(channel, channel.write(DefaultChannelGroup.safeDuplicate(message)));
            }
            future = new DefaultChannelGroupFuture((ChannelGroup)this, (Map<Channel, ChannelFuture>)var3_5, this.executor);
        }
        ReferenceCountUtil.release((Object)var1_1);
        return var2_2;
    }

    @Override
    public ChannelGroup flush() {
        return this.flush(ChannelMatchers.all());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture flushAndWrite(Object message) {
        void var1_1;
        return this.writeAndFlush(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture writeAndFlush(Object message) {
        void var1_1;
        return this.writeAndFlush(var1_1, ChannelMatchers.all());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture disconnect(ChannelMatcher matcher) {
        void var2_2;
        ObjectUtil.checkNotNull((Object)matcher, (String)"matcher");
        LinkedHashMap<Channel, ChannelFuture> futures = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        for (Channel c : this.serverChannels.values()) {
            if (!matcher.matches(c)) continue;
            Channel channel = c;
            futures.put(channel, channel.disconnect());
        }
        for (Channel c : this.nonServerChannels.values()) {
            if (!matcher.matches(c)) continue;
            Channel channel = c;
            futures.put(channel, channel.disconnect());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, (Map<Channel, ChannelFuture>)var2_2, this.executor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture close(ChannelMatcher matcher) {
        void var2_2;
        ObjectUtil.checkNotNull((Object)matcher, (String)"matcher");
        LinkedHashMap<Channel, ChannelFuture> futures = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        if (this.stayClosed) {
            this.closed = true;
        }
        for (Channel c : this.serverChannels.values()) {
            if (!matcher.matches(c)) continue;
            Channel channel = c;
            futures.put(channel, channel.close());
        }
        for (Channel c : this.nonServerChannels.values()) {
            if (!matcher.matches(c)) continue;
            Channel channel = c;
            futures.put(channel, channel.close());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, (Map<Channel, ChannelFuture>)var2_2, this.executor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture deregister(ChannelMatcher matcher) {
        void var2_2;
        ObjectUtil.checkNotNull((Object)matcher, (String)"matcher");
        LinkedHashMap<Channel, ChannelFuture> futures = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        for (Channel c : this.serverChannels.values()) {
            if (!matcher.matches(c)) continue;
            Channel channel = c;
            futures.put(channel, channel.deregister());
        }
        for (Channel c : this.nonServerChannels.values()) {
            if (!matcher.matches(c)) continue;
            Channel channel = c;
            futures.put(channel, channel.deregister());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, (Map<Channel, ChannelFuture>)var2_2, this.executor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroup flush(ChannelMatcher matcher) {
        for (Channel c : this.nonServerChannels.values()) {
            void var3_3;
            if (!matcher.matches(c)) continue;
            var3_3.flush();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture flushAndWrite(Object message, ChannelMatcher matcher) {
        void var2_2;
        void var1_1;
        return this.writeAndFlush(var1_1, (ChannelMatcher)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture writeAndFlush(Object message, ChannelMatcher matcher) {
        void var2_2;
        void var1_1;
        return this.writeAndFlush(var1_1, (ChannelMatcher)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture writeAndFlush(Object message, ChannelMatcher matcher, boolean voidPromise) {
        void var2_2;
        void var1_1;
        ChannelGroupFuture future;
        ObjectUtil.checkNotNull((Object)message, (String)"message");
        if (voidPromise) {
            for (Channel c : this.nonServerChannels.values()) {
                if (!matcher.matches(c)) continue;
                c.writeAndFlush(DefaultChannelGroup.safeDuplicate(message), c.voidPromise());
            }
            future = this.voidFuture;
        } else {
            void var3_5;
            LinkedHashMap<Channel, ChannelFuture> futures = new LinkedHashMap<Channel, ChannelFuture>(this.nonServerChannels.size());
            for (Channel c : this.nonServerChannels.values()) {
                if (!future.matches(c)) continue;
                Channel channel = c;
                futures.put(channel, channel.writeAndFlush(DefaultChannelGroup.safeDuplicate(message)));
            }
            future = new DefaultChannelGroupFuture((ChannelGroup)this, (Map<Channel, ChannelFuture>)var3_5, this.executor);
        }
        ReferenceCountUtil.release((Object)var1_1);
        return var2_2;
    }

    @Override
    public ChannelGroupFuture newCloseFuture() {
        return this.newCloseFuture(ChannelMatchers.all());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelGroupFuture newCloseFuture(ChannelMatcher matcher) {
        void var2_2;
        LinkedHashMap<Channel, ChannelFuture> futures = new LinkedHashMap<Channel, ChannelFuture>(this.size());
        for (Channel c : this.serverChannels.values()) {
            if (!matcher.matches(c)) continue;
            Channel channel = c;
            futures.put(channel, channel.closeFuture());
        }
        for (Channel c : this.nonServerChannels.values()) {
            if (!matcher.matches(c)) continue;
            Channel channel = c;
            futures.put(channel, channel.closeFuture());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, (Map<Channel, ChannelFuture>)var2_2, this.executor);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        void var1_1;
        return this == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(ChannelGroup o) {
        void var1_1;
        int v = this.name().compareTo(o.name());
        if (v != 0) {
            void var2_2;
            return (int)var2_2;
        }
        return System.identityHashCode(this) - System.identityHashCode(var1_1);
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "(name: " + this.name() + ", size: " + this.size() + ')';
    }
}

