/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.group;

import io.netty.channel.Channel;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelMatcher;

public final class ChannelMatchers {
    private static final ChannelMatcher ALL_MATCHER = new ChannelMatcher(){

        @Override
        public final boolean matches(Channel channel) {
            return true;
        }
    };
    private static final ChannelMatcher SERVER_CHANNEL_MATCHER = ChannelMatchers.isInstanceOf(ServerChannel.class);
    private static final ChannelMatcher NON_SERVER_CHANNEL_MATCHER = ChannelMatchers.isNotInstanceOf(ServerChannel.class);

    private ChannelMatchers() {
    }

    public static ChannelMatcher all() {
        return ALL_MATCHER;
    }

    public static ChannelMatcher isNot(Channel channel) {
        return ChannelMatchers.invert(ChannelMatchers.is(channel));
    }

    public static ChannelMatcher is(Channel channel) {
        Channel channel2;
        return new InstanceMatcher(channel2);
    }

    public static ChannelMatcher isInstanceOf(Class<? extends Channel> clazz) {
        Class<? extends Channel> clazz2;
        return new ClassMatcher(clazz2);
    }

    public static ChannelMatcher isNotInstanceOf(Class<? extends Channel> clazz) {
        return ChannelMatchers.invert(ChannelMatchers.isInstanceOf(clazz));
    }

    public static ChannelMatcher isServerChannel() {
        return SERVER_CHANNEL_MATCHER;
    }

    public static ChannelMatcher isNonServerChannel() {
        return NON_SERVER_CHANNEL_MATCHER;
    }

    public static ChannelMatcher invert(ChannelMatcher matcher) {
        ChannelMatcher channelMatcher;
        return new InvertMatcher(channelMatcher);
    }

    public static ChannelMatcher compose(ChannelMatcher ... matchers) {
        ChannelMatcher[] channelMatcherArray;
        if (matchers.length <= 0) {
            throw new IllegalArgumentException("matchers must at least contain one element");
        }
        if (matchers.length == 1) {
            return matchers[0];
        }
        return new CompositeMatcher(channelMatcherArray);
    }

    private static final class ClassMatcher
    implements ChannelMatcher {
        private final Class<? extends Channel> clazz;

        /*
         * WARNING - void declaration
         */
        ClassMatcher(Class<? extends Channel> clazz) {
            void var1_1;
            this.clazz = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Channel ch) {
            void var1_1;
            return this.clazz.isInstance(var1_1);
        }
    }

    private static final class InstanceMatcher
    implements ChannelMatcher {
        private final Channel channel;

        /*
         * WARNING - void declaration
         */
        InstanceMatcher(Channel channel) {
            void var1_1;
            this.channel = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Channel ch) {
            void var1_1;
            return this.channel == var1_1;
        }
    }

    private static final class InvertMatcher
    implements ChannelMatcher {
        private final ChannelMatcher matcher;

        /*
         * WARNING - void declaration
         */
        InvertMatcher(ChannelMatcher matcher) {
            void var1_1;
            this.matcher = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(Channel channel) {
            void var1_1;
            return !this.matcher.matches((Channel)var1_1);
        }
    }

    private static final class CompositeMatcher
    implements ChannelMatcher {
        private final ChannelMatcher[] matchers;

        /*
         * WARNING - void declaration
         */
        CompositeMatcher(ChannelMatcher ... matchers) {
            void var1_1;
            this.matchers = var1_1;
        }

        @Override
        public final boolean matches(Channel channel) {
            ChannelMatcher[] channelMatcherArray = this.matchers;
            int n = this.matchers.length;
            for (int i = 0; i < n; ++i) {
                ChannelMatcher channelMatcher = channelMatcherArray[i];
                if (channelMatcher.matches(channel)) continue;
                return false;
            }
            return true;
        }
    }
}

