/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

final class EmbeddedEventLoop
extends AbstractScheduledEventExecutor
implements EventLoop {
    private long startTime = EmbeddedEventLoop.initialNanoTime();
    private long frozenTimestamp;
    private boolean timeFrozen;
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>(2);

    EmbeddedEventLoop() {
    }

    @Override
    public final EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public final EventLoop next() {
        return (EventLoop)super.next();
    }

    /*
     * WARNING - void declaration
     */
    public final void execute(Runnable command) {
        void var1_1;
        this.tasks.add((Runnable)ObjectUtil.checkNotNull((Object)var1_1, (String)"command"));
    }

    /*
     * WARNING - void declaration
     */
    final void runTasks() {
        Runnable task;
        while ((task = this.tasks.poll()) != null) {
            void var1_1;
            var1_1.run();
        }
    }

    final boolean hasPendingNormalTasks() {
        return !this.tasks.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    final long runScheduledTasks() {
        long time = this.getCurrentTimeNanos();
        Runnable task;
        while ((task = this.pollScheduledTask(time)) != null) {
            void var3_2;
            var3_2.run();
        }
        return this.nextScheduledTaskNano();
    }

    final long nextScheduledTask() {
        return this.nextScheduledTaskNano();
    }

    protected final long getCurrentTimeNanos() {
        if (this.timeFrozen) {
            return this.frozenTimestamp;
        }
        return System.nanoTime() - this.startTime;
    }

    /*
     * WARNING - void declaration
     */
    final void advanceTimeBy(long nanos) {
        void var1_1;
        if (this.timeFrozen) {
            this.frozenTimestamp += nanos;
            return;
        }
        this.startTime -= var1_1;
    }

    final void freezeTime() {
        if (!this.timeFrozen) {
            this.frozenTimestamp = this.getCurrentTimeNanos();
            this.timeFrozen = true;
        }
    }

    final void unfreezeTime() {
        if (this.timeFrozen) {
            this.startTime = System.nanoTime() - this.frozenTimestamp;
            this.timeFrozen = false;
        }
    }

    protected final void cancelScheduledTasks() {
        super.cancelScheduledTasks();
    }

    public final Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public final Future<?> terminationFuture() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void shutdown() {
        throw new UnsupportedOperationException();
    }

    public final boolean isShuttingDown() {
        return false;
    }

    public final boolean isShutdown() {
        return false;
    }

    public final boolean isTerminated() {
        return false;
    }

    public final boolean awaitTermination(long timeout, TimeUnit unit) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture register(Channel channel) {
        void var1_1;
        return this.register(new DefaultChannelPromise((Channel)var1_1, (EventExecutor)this));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture register(ChannelPromise promise) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)promise, (String)"promise");
        promise.channel().unsafe().register(this, promise);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final ChannelFuture register(Channel channel, ChannelPromise promise) {
        void var2_2;
        channel.unsafe().register(this, promise);
        return var2_2;
    }

    public final boolean inEventLoop() {
        return true;
    }

    public final boolean inEventLoop(Thread thread) {
        return true;
    }
}

