/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.embedded.EmbeddedChannelId;
import io.netty.channel.embedded.EmbeddedEventLoop;
import io.netty.channel.embedded.EmbeddedSocketAddress;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.RecyclableArrayList;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class EmbeddedChannel
extends AbstractChannel {
    private static final SocketAddress LOCAL_ADDRESS = new EmbeddedSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new EmbeddedSocketAddress();
    private static final ChannelHandler[] EMPTY_HANDLERS = new ChannelHandler[0];
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA_NO_DISCONNECT = new ChannelMetadata(false);
    private static final ChannelMetadata METADATA_DISCONNECT = new ChannelMetadata(true);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelFutureListener recordExceptionListener = new ChannelFutureListener(this){
        final /* synthetic */ EmbeddedChannel this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void operationComplete(ChannelFuture future) throws Exception {
            void var1_1;
            EmbeddedChannel.access$000(this.this$0, (ChannelFuture)var1_1);
        }
    };
    private final ChannelMetadata metadata;
    private final ChannelConfig config;
    private Queue<Object> inboundMessages;
    private Queue<Object> outboundMessages;
    private Throwable lastException;
    private State state;
    private int executingStackCnt;

    public EmbeddedChannel() {
        this(EMPTY_HANDLERS);
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedChannel(ChannelId channelId) {
        this((ChannelId)var1_1, EMPTY_HANDLERS);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedChannel(ChannelHandler ... handlers) {
        this(EmbeddedChannelId.INSTANCE, (ChannelHandler[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedChannel(boolean hasDisconnect, ChannelHandler ... handlers) {
        this(EmbeddedChannelId.INSTANCE, (boolean)var1_1, (ChannelHandler[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedChannel(boolean register, boolean hasDisconnect, ChannelHandler ... handlers) {
        this(EmbeddedChannelId.INSTANCE, (boolean)var1_1, (boolean)var2_2, (ChannelHandler[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedChannel(ChannelId channelId, ChannelHandler ... handlers) {
        this((ChannelId)var1_1, false, (ChannelHandler[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedChannel(ChannelId channelId, boolean hasDisconnect, ChannelHandler ... handlers) {
        this((ChannelId)var1_1, true, (boolean)var2_2, (ChannelHandler[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedChannel(ChannelId channelId, boolean register, boolean hasDisconnect, ChannelHandler ... handlers) {
        this(null, (ChannelId)var1_1, (boolean)var2_2, (boolean)var3_3, handlers);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedChannel(Channel parent, ChannelId channelId, boolean register, boolean hasDisconnect, ChannelHandler ... handlers) {
        super((Channel)var1_1, (ChannelId)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.metadata = EmbeddedChannel.metadata(hasDisconnect);
        this.config = new DefaultChannelConfig(this);
        this.setup((boolean)var3_3, handlers);
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedChannel(ChannelId channelId, boolean hasDisconnect, ChannelConfig config, ChannelHandler ... handlers) {
        super(null, (ChannelId)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.metadata = EmbeddedChannel.metadata((boolean)var2_2);
        this.config = (ChannelConfig)ObjectUtil.checkNotNull((Object)var3_3, (String)"config");
        this.setup(true, handlers);
    }

    private static ChannelMetadata metadata(boolean hasDisconnect) {
        if (hasDisconnect) {
            return METADATA_DISCONNECT;
        }
        return METADATA_NO_DISCONNECT;
    }

    /*
     * WARNING - void declaration
     */
    private void setup(boolean register, ChannelHandler ... handlers) {
        void var2_3;
        ObjectUtil.checkNotNull((Object)handlers, (String)"handlers");
        ChannelPipeline channelPipeline = this.pipeline();
        channelPipeline.addLast(new ChannelInitializer<Channel>(this, (ChannelHandler[])var2_3){
            final /* synthetic */ ChannelHandler[] val$handlers;
            final /* synthetic */ EmbeddedChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$handlers = channelHandlerArray;
            }

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ChannelHandler h;
                ChannelPipeline pipeline = ch.pipeline();
                ChannelHandler[] channelHandlerArray = this.val$handlers;
                int n = this.val$handlers.length;
                for (int i = 0; i < n && (h = channelHandlerArray[i]) != null; ++i) {
                    pipeline.addLast(h);
                }
            }
        });
        if (register) {
            void var1_2;
            ChannelFuture future = this.loop.register(this);
            assert (var1_2.isDone());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void register() throws Exception {
        ChannelFuture future = this.loop.register(this);
        assert (future.isDone());
        Throwable cause = future.cause();
        if (cause != null) {
            void var1_1;
            PlatformDependent.throwException((Throwable)var1_1);
        }
    }

    @Override
    protected final DefaultChannelPipeline newChannelPipeline() {
        EmbeddedChannel embeddedChannel = this;
        return embeddedChannel.new EmbeddedChannelPipeline(embeddedChannel);
    }

    @Override
    public ChannelMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public Queue<Object> inboundMessages() {
        if (this.inboundMessages == null) {
            this.inboundMessages = new ArrayDeque<Object>();
        }
        return this.inboundMessages;
    }

    @Deprecated
    public Queue<Object> lastInboundBuffer() {
        return this.inboundMessages();
    }

    public Queue<Object> outboundMessages() {
        if (this.outboundMessages == null) {
            this.outboundMessages = new ArrayDeque<Object>();
        }
        return this.outboundMessages;
    }

    @Deprecated
    public Queue<Object> lastOutboundBuffer() {
        return this.outboundMessages();
    }

    /*
     * WARNING - void declaration
     */
    public <T> T readInbound() {
        void var1_1;
        Object message = EmbeddedChannel.poll(this.inboundMessages);
        if (message != null) {
            ReferenceCountUtil.touch((Object)message, (Object)"Caller of readInbound() will handle the message from this point");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T readOutbound() {
        void var1_1;
        Object message = EmbeddedChannel.poll(this.outboundMessages);
        if (message != null) {
            ReferenceCountUtil.touch((Object)message, (Object)"Caller of readOutbound() will handle the message from this point.");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean writeInbound(Object ... msgs) {
        this.ensureOpen();
        if (msgs.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.inboundMessages);
        }
        ++this.executingStackCnt;
        try {
            void var1_1;
            ChannelPipeline p = this.pipeline();
            for (void m : var1_1) {
                p.fireChannelRead(m);
            }
            this.flushInbound(false, this.voidPromise());
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return EmbeddedChannel.isNotEmpty(this.inboundMessages);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture writeOneInbound(Object msg) {
        void var1_1;
        return this.writeOneInbound(var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture writeOneInbound(Object msg, ChannelPromise promise) {
        void var2_3;
        ++this.executingStackCnt;
        try {
            if (this.checkOpen(true)) {
                void var1_1;
                this.pipeline().fireChannelRead(var1_1);
            }
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return this.checkException((ChannelPromise)var2_3);
    }

    public EmbeddedChannel flushInbound() {
        this.flushInbound(true, this.voidPromise());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture flushInbound(boolean recordException, ChannelPromise promise) {
        void var2_3;
        ++this.executingStackCnt;
        try {
            void var1_1;
            if (this.checkOpen((boolean)var1_1)) {
                this.pipeline().fireChannelReadComplete();
                this.runPendingTasks();
            }
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return this.checkException((ChannelPromise)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean writeOutbound(Object ... msgs) {
        boolean bl;
        this.ensureOpen();
        if (msgs.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.outboundMessages);
        }
        ++this.executingStackCnt;
        RecyclableArrayList futures = RecyclableArrayList.newInstance((int)msgs.length);
        try {
            try {
                for (Object m : msgs) {
                    if (m == null) break;
                    futures.add((Object)((AbstractChannel)this).write(m));
                }
                this.flushOutbound0();
                int size = futures.size();
                for (int i = 0; i < size; ++i) {
                    ChannelFuture future = (ChannelFuture)futures.get(i);
                    if (future.isDone()) {
                        this.recordException(future);
                        continue;
                    }
                    future.addListener(this.recordExceptionListener);
                }
            }
            finally {
                --this.executingStackCnt;
                this.maybeRunPendingTasks();
            }
            this.checkException();
            bl = EmbeddedChannel.isNotEmpty(this.outboundMessages);
        }
        catch (Throwable throwable) {
            void var2_5;
            var2_5.recycle();
            throw throwable;
        }
        futures.recycle();
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture writeOneOutbound(Object msg) {
        void var1_1;
        return this.writeOneOutbound(var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture writeOneOutbound(Object msg, ChannelPromise promise) {
        void var2_3;
        ++this.executingStackCnt;
        try {
            if (this.checkOpen(true)) {
                ChannelFuture channelFuture;
                channelFuture = ((AbstractChannel)this).write(channelFuture, promise);
                return channelFuture;
            }
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        return this.checkException((ChannelPromise)var2_3);
    }

    public EmbeddedChannel flushOutbound() {
        ++this.executingStackCnt;
        try {
            if (this.checkOpen(true)) {
                this.flushOutbound0();
            }
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        EmbeddedChannel embeddedChannel = this;
        embeddedChannel.checkException(embeddedChannel.voidPromise());
        return this;
    }

    private void flushOutbound0() {
        this.runPendingTasks();
        ((AbstractChannel)this).flush();
    }

    public boolean finish() {
        return this.finish(false);
    }

    public boolean finishAndReleaseAll() {
        return this.finish(true);
    }

    private boolean finish(boolean releaseAll) {
        ++this.executingStackCnt;
        try {
            ((AbstractChannel)this).close();
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        try {
            this.checkException();
            boolean bl = EmbeddedChannel.isNotEmpty(this.inboundMessages) || EmbeddedChannel.isNotEmpty(this.outboundMessages);
            return bl;
        }
        finally {
            if (releaseAll) {
                EmbeddedChannel.releaseAll(this.inboundMessages);
                EmbeddedChannel.releaseAll(this.outboundMessages);
            }
        }
    }

    public boolean releaseInbound() {
        return EmbeddedChannel.releaseAll(this.inboundMessages);
    }

    public boolean releaseOutbound() {
        return EmbeddedChannel.releaseAll(this.outboundMessages);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean releaseAll(Queue<Object> queue) {
        if (EmbeddedChannel.isNotEmpty(queue)) {
            Object msg;
            while ((msg = queue.poll()) != null) {
                void var1_1;
                ReferenceCountUtil.release((Object)var1_1);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void finishPendingTasks(boolean cancel) {
        void var1_1;
        this.runPendingTasks();
        if (var1_1 != false) {
            this.embeddedEventLoop().cancelScheduledTasks();
        }
    }

    @Override
    public final ChannelFuture close() {
        EmbeddedChannel embeddedChannel = this;
        return ((AbstractChannel)embeddedChannel).close(embeddedChannel.newPromise());
    }

    @Override
    public final ChannelFuture disconnect() {
        EmbeddedChannel embeddedChannel = this;
        return ((AbstractChannel)embeddedChannel).disconnect(embeddedChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture close(ChannelPromise promise) {
        void var1_1;
        ++this.executingStackCnt;
        try {
            this.runPendingTasks();
            ChannelFuture future = super.close(promise);
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        this.finishPendingTasks(true);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture disconnect(ChannelPromise promise) {
        void var1_1;
        ++this.executingStackCnt;
        try {
            ChannelFuture future = super.disconnect(promise);
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
        EmbeddedChannel embeddedChannel = this;
        embeddedChannel.finishPendingTasks(!embeddedChannel.metadata.hasDisconnect());
        return var1_1;
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture;
            channelFuture = super.bind((SocketAddress)((Object)channelFuture));
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture;
            channelFuture = super.connect((SocketAddress)((Object)channelFuture));
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        ++this.executingStackCnt;
        try {
            void var2_3;
            ChannelFuture channelFuture;
            channelFuture = super.connect((SocketAddress)((Object)channelFuture), (SocketAddress)var2_3);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture deregister() {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture = super.deregister();
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public Channel flush() {
        ++this.executingStackCnt;
        try {
            Channel channel = super.flush();
            return channel;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        ++this.executingStackCnt;
        try {
            void var2_3;
            ChannelFuture channelFuture;
            channelFuture = super.bind((SocketAddress)((Object)channelFuture), (ChannelPromise)var2_3);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        ++this.executingStackCnt;
        try {
            void var2_3;
            ChannelFuture channelFuture;
            channelFuture = super.connect((SocketAddress)((Object)channelFuture), (ChannelPromise)var2_3);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        ++this.executingStackCnt;
        try {
            void var3_4;
            void var2_3;
            ChannelFuture channelFuture;
            channelFuture = super.connect((SocketAddress)((Object)channelFuture), (SocketAddress)var2_3, (ChannelPromise)var3_4);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture;
            channelFuture = super.deregister((ChannelPromise)channelFuture);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public Channel read() {
        ++this.executingStackCnt;
        try {
            Channel channel = super.read();
            return channel;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture write(Object msg) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture;
            channelFuture = super.write(channelFuture);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        ++this.executingStackCnt;
        try {
            void var2_3;
            ChannelFuture channelFuture;
            channelFuture = super.write(channelFuture, (ChannelPromise)var2_3);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        ++this.executingStackCnt;
        try {
            ChannelFuture channelFuture;
            channelFuture = super.writeAndFlush(channelFuture);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        ++this.executingStackCnt;
        try {
            void var2_3;
            ChannelFuture channelFuture;
            channelFuture = super.writeAndFlush(channelFuture, (ChannelPromise)var2_3);
            return channelFuture;
        }
        finally {
            --this.executingStackCnt;
            this.maybeRunPendingTasks();
        }
    }

    private static boolean isNotEmpty(Queue<Object> queue) {
        Queue<Object> queue2;
        return queue != null && !queue2.isEmpty();
    }

    private static Object poll(Queue<Object> queue) {
        if (queue != null) {
            Queue<Object> queue2;
            return queue2.poll();
        }
        return null;
    }

    private void maybeRunPendingTasks() {
        if (this.executingStackCnt == 0) {
            this.runPendingTasks();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void runPendingTasks() {
        try {
            this.embeddedEventLoop().runTasks();
        }
        catch (Exception e) {
            this.recordException(e);
        }
        try {
            this.embeddedEventLoop().runScheduledTasks();
            return;
        }
        catch (Exception e) {
            void var1_2;
            this.recordException((Throwable)var1_2);
            return;
        }
    }

    public boolean hasPendingTasks() {
        return this.embeddedEventLoop().hasPendingNormalTasks() || this.embeddedEventLoop().nextScheduledTask() == 0L;
    }

    /*
     * WARNING - void declaration
     */
    public long runScheduledPendingTasks() {
        try {
            return this.embeddedEventLoop().runScheduledTasks();
        }
        catch (Exception e) {
            void var1_1;
            this.recordException((Throwable)var1_1);
            return this.embeddedEventLoop().nextScheduledTask();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void recordException(ChannelFuture future) {
        if (!future.isSuccess()) {
            void var1_1;
            this.recordException(var1_1.cause());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void recordException(Throwable cause) {
        void var1_1;
        if (this.lastException == null) {
            this.lastException = cause;
            return;
        }
        logger.warn("More than one exception was raised. Will report only the first one and log others.", (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void advanceTimeBy(long duration, TimeUnit unit) {
        void var1_1;
        void var3_2;
        this.embeddedEventLoop().advanceTimeBy(var3_2.toNanos((long)var1_1));
    }

    public void freezeTime() {
        this.embeddedEventLoop().freezeTime();
    }

    public void unfreezeTime() {
        this.embeddedEventLoop().unfreezeTime();
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture checkException(ChannelPromise promise) {
        void var1_1;
        Throwable t = this.lastException;
        if (t != null) {
            void var2_2;
            this.lastException = null;
            if (promise.isVoid()) {
                PlatformDependent.throwException((Throwable)t);
            }
            return promise.setFailure((Throwable)var2_2);
        }
        return var1_1.setSuccess();
    }

    public void checkException() {
        EmbeddedChannel embeddedChannel = this;
        embeddedChannel.checkException(embeddedChannel.voidPromise());
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkOpen(boolean recordException) {
        if (!this.isOpen()) {
            void var1_1;
            if (var1_1 != false) {
                this.recordException(new ClosedChannelException());
            }
            return false;
        }
        return true;
    }

    private EmbeddedEventLoop embeddedEventLoop() {
        if (this.isRegistered()) {
            return (EmbeddedEventLoop)super.eventLoop();
        }
        return this.loop;
    }

    protected final void ensureOpen() {
        if (!this.checkOpen(true)) {
            this.checkException();
        }
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof EmbeddedEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        if (this.isActive()) {
            return LOCAL_ADDRESS;
        }
        return null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        if (this.isActive()) {
            return REMOTE_ADDRESS;
        }
        return null;
    }

    @Override
    protected void doRegister() throws Exception {
        this.state = State.ACTIVE;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    @Override
    protected void doDisconnect() throws Exception {
        if (!this.metadata.hasDisconnect()) {
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws Exception {
        this.state = State.CLOSED;
    }

    @Override
    protected void doBeginRead() throws Exception {
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new EmbeddedUnsafe();
    }

    @Override
    public Channel.Unsafe unsafe() {
        return ((EmbeddedUnsafe)super.unsafe()).wrapped;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        Object msg;
        while ((msg = in.current()) != null) {
            void var2_2;
            ReferenceCountUtil.retain((Object)msg);
            this.handleOutboundMessage(var2_2);
            in.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void handleOutboundMessage(Object msg) {
        void var1_1;
        this.outboundMessages().add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void handleInboundMessage(Object msg) {
        void var1_1;
        this.inboundMessages().add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(EmbeddedChannel x0, ChannelFuture x1) {
        void var1_1;
        x0.recordException((ChannelFuture)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(EmbeddedChannel x0, Throwable x1) {
        void var1_1;
        x0.recordException((Throwable)var1_1);
    }

    private final class EmbeddedChannelPipeline
    extends DefaultChannelPipeline {
        /*
         * WARNING - void declaration
         */
        EmbeddedChannelPipeline(EmbeddedChannel channel) {
            void var2_2;
            super((Channel)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void onUnhandledInboundException(Throwable cause) {
            void var1_1;
            EmbeddedChannel.access$400(EmbeddedChannel.this, (Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void onUnhandledInboundMessage(ChannelHandlerContext ctx, Object msg) {
            void var2_2;
            EmbeddedChannel.this.handleInboundMessage(var2_2);
        }
    }

    private final class EmbeddedUnsafe
    extends AbstractChannel.AbstractUnsafe {
        final Channel.Unsafe wrapped;

        private EmbeddedUnsafe() {
            super(EmbeddedChannel.this);
            this.wrapped = new Channel.Unsafe(this){
                final /* synthetic */ EmbeddedUnsafe this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                @Override
                public RecvByteBufAllocator.Handle recvBufAllocHandle() {
                    return this.this$1.recvBufAllocHandle();
                }

                @Override
                public SocketAddress localAddress() {
                    return this.this$1.localAddress();
                }

                @Override
                public SocketAddress remoteAddress() {
                    return this.this$1.remoteAddress();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void register(EventLoop eventLoop, ChannelPromise promise) {
                    this.this$1.EmbeddedChannel.this.executingStackCnt++;
                    try {
                        void var2_3;
                        void var1_1;
                        this.this$1.register((EventLoop)var1_1, (ChannelPromise)var2_3);
                        return;
                    }
                    finally {
                        this.this$1.EmbeddedChannel.this.executingStackCnt--;
                        this.this$1.EmbeddedChannel.this.maybeRunPendingTasks();
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void bind(SocketAddress localAddress, ChannelPromise promise) {
                    this.this$1.EmbeddedChannel.this.executingStackCnt++;
                    try {
                        void var2_3;
                        void var1_1;
                        this.this$1.bind((SocketAddress)var1_1, (ChannelPromise)var2_3);
                        return;
                    }
                    finally {
                        this.this$1.EmbeddedChannel.this.executingStackCnt--;
                        this.this$1.EmbeddedChannel.this.maybeRunPendingTasks();
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                    this.this$1.EmbeddedChannel.this.executingStackCnt++;
                    try {
                        void var3_4;
                        void var2_3;
                        void var1_1;
                        this.this$1.connect((SocketAddress)var1_1, (SocketAddress)var2_3, (ChannelPromise)var3_4);
                        return;
                    }
                    finally {
                        this.this$1.EmbeddedChannel.this.executingStackCnt--;
                        this.this$1.EmbeddedChannel.this.maybeRunPendingTasks();
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void disconnect(ChannelPromise promise) {
                    this.this$1.EmbeddedChannel.this.executingStackCnt++;
                    try {
                        void var1_1;
                        this.this$1.disconnect((ChannelPromise)var1_1);
                        return;
                    }
                    finally {
                        this.this$1.EmbeddedChannel.this.executingStackCnt--;
                        this.this$1.EmbeddedChannel.this.maybeRunPendingTasks();
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void close(ChannelPromise promise) {
                    this.this$1.EmbeddedChannel.this.executingStackCnt++;
                    try {
                        void var1_1;
                        this.this$1.close((ChannelPromise)var1_1);
                        return;
                    }
                    finally {
                        this.this$1.EmbeddedChannel.this.executingStackCnt--;
                        this.this$1.EmbeddedChannel.this.maybeRunPendingTasks();
                    }
                }

                @Override
                public void closeForcibly() {
                    this.this$1.EmbeddedChannel.this.executingStackCnt++;
                    try {
                        this.this$1.closeForcibly();
                        return;
                    }
                    finally {
                        this.this$1.EmbeddedChannel.this.executingStackCnt--;
                        this.this$1.EmbeddedChannel.this.maybeRunPendingTasks();
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void deregister(ChannelPromise promise) {
                    this.this$1.EmbeddedChannel.this.executingStackCnt++;
                    try {
                        void var1_1;
                        this.this$1.deregister((ChannelPromise)var1_1);
                        return;
                    }
                    finally {
                        this.this$1.EmbeddedChannel.this.executingStackCnt--;
                        this.this$1.EmbeddedChannel.this.maybeRunPendingTasks();
                    }
                }

                @Override
                public void beginRead() {
                    this.this$1.EmbeddedChannel.this.executingStackCnt++;
                    try {
                        this.this$1.beginRead();
                        return;
                    }
                    finally {
                        this.this$1.EmbeddedChannel.this.executingStackCnt--;
                        this.this$1.EmbeddedChannel.this.maybeRunPendingTasks();
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void write(Object msg, ChannelPromise promise) {
                    this.this$1.EmbeddedChannel.this.executingStackCnt++;
                    try {
                        void var2_3;
                        void var1_1;
                        this.this$1.write(var1_1, (ChannelPromise)var2_3);
                        return;
                    }
                    finally {
                        this.this$1.EmbeddedChannel.this.executingStackCnt--;
                        this.this$1.EmbeddedChannel.this.maybeRunPendingTasks();
                    }
                }

                @Override
                public void flush() {
                    this.this$1.EmbeddedChannel.this.executingStackCnt++;
                    try {
                        this.this$1.flush();
                        return;
                    }
                    finally {
                        this.this$1.EmbeddedChannel.this.executingStackCnt--;
                        this.this$1.EmbeddedChannel.this.maybeRunPendingTasks();
                    }
                }

                @Override
                public ChannelPromise voidPromise() {
                    return this.this$1.voidPromise();
                }

                @Override
                public ChannelOutboundBuffer outboundBuffer() {
                    return this.this$1.outboundBuffer();
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            void var3_3;
            this.safeSetSuccess((ChannelPromise)var3_3);
        }
    }

    private static enum State {
        OPEN,
        ACTIVE,
        CLOSED;

    }
}

