/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.ThreadPerChannelEventLoop;
import io.netty.util.concurrent.AbstractEventExecutorGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ReadOnlyIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

@Deprecated
public class ThreadPerChannelEventLoopGroup
extends AbstractEventExecutorGroup
implements EventLoopGroup {
    private final Object[] childArgs;
    private final int maxChannels;
    final Executor executor;
    final Set<EventLoop> activeChildren = Collections.newSetFromMap(PlatformDependent.newConcurrentHashMap());
    final Queue<EventLoop> idleChildren = new ConcurrentLinkedQueue<EventLoop>();
    private final ChannelException tooManyChannels;
    private volatile boolean shuttingDown;
    private final Promise<?> terminationFuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final FutureListener<Object> childTerminationListener = new FutureListener<Object>(this){
        final /* synthetic */ ThreadPerChannelEventLoopGroup this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public void operationComplete(Future<Object> future) throws Exception {
            if (this.this$0.isTerminated()) {
                this.this$0.terminationFuture.trySuccess(null);
            }
        }
    };

    protected ThreadPerChannelEventLoopGroup() {
        this(0);
    }

    /*
     * WARNING - void declaration
     */
    protected ThreadPerChannelEventLoopGroup(int maxChannels) {
        this((int)var1_1, (ThreadFactory)null, new Object[0]);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected ThreadPerChannelEventLoopGroup(int maxChannels, ThreadFactory threadFactory, Object ... args) {
        this((int)var1_1, (Executor)(threadFactory == null ? null : new ThreadPerTaskExecutor((ThreadFactory)var2_2)), (Object[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected ThreadPerChannelEventLoopGroup(int maxChannels, Executor executor, Object ... args) {
        void var1_1;
        void var2_2;
        void var3_3;
        ObjectUtil.checkPositiveOrZero((int)maxChannels, (String)"maxChannels");
        if (executor == null) {
            executor = new ThreadPerTaskExecutor((ThreadFactory)new DefaultThreadFactory(this.getClass()));
        }
        this.childArgs = args == null ? EmptyArrays.EMPTY_OBJECTS : (Object[])var3_3.clone();
        this.maxChannels = maxChannels;
        this.executor = var2_2;
        this.tooManyChannels = ChannelException.newStatic("too many channels (max: " + (int)var1_1 + ')', ThreadPerChannelEventLoopGroup.class, "nextChild()");
    }

    protected EventLoop newChild(Object ... args) throws Exception {
        return new ThreadPerChannelEventLoop(this);
    }

    public Iterator<EventExecutor> iterator() {
        return new ReadOnlyIterator(this.activeChildren.iterator());
    }

    @Override
    public EventLoop next() {
        throw new UnsupportedOperationException();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        this.shuttingDown = true;
        for (EventLoop eventLoop : this.activeChildren) {
            eventLoop.shutdownGracefully(quietPeriod, timeout, unit);
        }
        for (EventLoop eventLoop : this.idleChildren) {
            eventLoop.shutdownGracefully(quietPeriod, timeout, unit);
        }
        if (this.isTerminated()) {
            this.terminationFuture.trySuccess(null);
        }
        return this.terminationFuture();
    }

    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Deprecated
    public void shutdown() {
        this.shuttingDown = true;
        for (EventLoop eventLoop : this.activeChildren) {
            eventLoop.shutdown();
        }
        for (EventLoop eventLoop : this.idleChildren) {
            eventLoop.shutdown();
        }
        if (this.isTerminated()) {
            this.terminationFuture.trySuccess(null);
        }
    }

    public boolean isShuttingDown() {
        for (EventLoop eventLoop : this.activeChildren) {
            if (eventLoop.isShuttingDown()) continue;
            return false;
        }
        for (EventLoop eventLoop : this.idleChildren) {
            if (eventLoop.isShuttingDown()) continue;
            return false;
        }
        return true;
    }

    public boolean isShutdown() {
        for (EventLoop eventLoop : this.activeChildren) {
            if (eventLoop.isShutdown()) continue;
            return false;
        }
        for (EventLoop eventLoop : this.idleChildren) {
            if (eventLoop.isShutdown()) continue;
            return false;
        }
        return true;
    }

    public boolean isTerminated() {
        for (EventLoop eventLoop : this.activeChildren) {
            if (eventLoop.isTerminated()) continue;
            return false;
        }
        for (EventLoop eventLoop : this.idleChildren) {
            if (eventLoop.isTerminated()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long timeLeft;
        void var1_1;
        void var3_3;
        long deadline = System.nanoTime() + var3_3.toNanos((long)var1_1);
        block0: for (EventLoop l : this.activeChildren) {
            while ((timeLeft = deadline - System.nanoTime()) > 0L) {
                if (l.awaitTermination(timeLeft, TimeUnit.NANOSECONDS)) continue block0;
            }
            return this.isTerminated();
        }
        block2: for (EventLoop l : this.idleChildren) {
            while ((timeLeft = deadline - System.nanoTime()) > 0L) {
                if (l.awaitTermination(timeLeft, TimeUnit.NANOSECONDS)) continue block2;
            }
            return this.isTerminated();
        }
        return this.isTerminated();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture register(Channel channel) {
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        try {
            EventLoop l = this.nextChild();
            return l.register(new DefaultChannelPromise(channel, (EventExecutor)l));
        }
        catch (Throwable t) {
            void var2_3;
            void var1_1;
            return new FailedChannelFuture((Channel)var1_1, (EventExecutor)GlobalEventExecutor.INSTANCE, (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture register(ChannelPromise promise) {
        try {
            return this.nextChild().register(promise);
        }
        catch (Throwable t) {
            void var1_1;
            void var2_2;
            promise.setFailure((Throwable)var2_2);
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        try {
            return this.nextChild().register(channel, promise);
        }
        catch (Throwable t) {
            void var2_3;
            void var1_2;
            promise.setFailure((Throwable)var1_2);
            return var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    private EventLoop nextChild() throws Exception {
        void var1_1;
        if (this.shuttingDown) {
            throw new RejectedExecutionException("shutting down");
        }
        EventLoop loop = this.idleChildren.poll();
        if (loop == null) {
            if (this.maxChannels > 0 && this.activeChildren.size() >= this.maxChannels) {
                throw this.tooManyChannels;
            }
            ThreadPerChannelEventLoopGroup threadPerChannelEventLoopGroup = this;
            loop = threadPerChannelEventLoopGroup.newChild(threadPerChannelEventLoopGroup.childArgs);
            loop.terminationFuture().addListener(this.childTerminationListener);
        }
        this.activeChildren.add(loop);
        return var1_1;
    }
}

