/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public abstract class SingleThreadEventLoop
extends SingleThreadEventExecutor
implements EventLoop {
    protected static final int DEFAULT_MAX_PENDING_TASKS = Math.max(16, SystemPropertyUtil.getInt((String)"io.netty.eventLoop.maxPendingTasks", (int)Integer.MAX_VALUE));
    private final Queue<Runnable> tailTasks;

    /*
     * WARNING - void declaration
     */
    protected SingleThreadEventLoop(EventLoopGroup parent, ThreadFactory threadFactory, boolean addTaskWakesUp) {
        this((EventLoopGroup)var1_1, (ThreadFactory)var2_2, (boolean)var3_3, DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SingleThreadEventLoop(EventLoopGroup parent, Executor executor, boolean addTaskWakesUp) {
        this((EventLoopGroup)var1_1, (Executor)var2_2, (boolean)var3_3, DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SingleThreadEventLoop(EventLoopGroup parent, ThreadFactory threadFactory, boolean addTaskWakesUp, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventExecutorGroup)var1_1, (ThreadFactory)var2_2, (boolean)var3_3, maxPendingTasks, rejectedExecutionHandler);
        void var3_3;
        void var2_2;
        void var1_1;
        this.tailTasks = this.newTaskQueue(maxPendingTasks);
    }

    /*
     * WARNING - void declaration
     */
    protected SingleThreadEventLoop(EventLoopGroup parent, Executor executor, boolean addTaskWakesUp, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventExecutorGroup)var1_1, (Executor)var2_2, (boolean)var3_3, maxPendingTasks, rejectedExecutionHandler);
        void var3_3;
        void var2_2;
        void var1_1;
        this.tailTasks = this.newTaskQueue(maxPendingTasks);
    }

    /*
     * WARNING - void declaration
     */
    protected SingleThreadEventLoop(EventLoopGroup parent, Executor executor, boolean addTaskWakesUp, Queue<Runnable> taskQueue, Queue<Runnable> tailTaskQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventExecutorGroup)var1_1, (Executor)var2_2, (boolean)var3_3, taskQueue, rejectedExecutionHandler);
        void var3_3;
        void var2_2;
        void var1_1;
        this.tailTasks = (Queue)ObjectUtil.checkNotNull(tailTaskQueue, (String)"tailTaskQueue");
    }

    @Override
    public EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture register(Channel channel) {
        void var1_1;
        return this.register(new DefaultChannelPromise((Channel)var1_1, (EventExecutor)this));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture register(ChannelPromise promise) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)promise, (String)"promise");
        promise.channel().unsafe().register(this, promise);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)promise, (String)"promise");
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        var1_1.unsafe().register(this, promise);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void executeAfterEventLoopIteration(Runnable task) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)task, (String)"task");
        if (this.isShutdown()) {
            SingleThreadEventLoop.reject();
        }
        if (!this.tailTasks.offer(task)) {
            this.reject(task);
        }
        if (this.wakesUpForTask((Runnable)var1_1)) {
            SingleThreadEventLoop singleThreadEventLoop = this;
            singleThreadEventLoop.wakeup(singleThreadEventLoop.inEventLoop());
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean removeAfterEventLoopIterationTask(Runnable task) {
        void var1_1;
        return this.tailTasks.remove(ObjectUtil.checkNotNull((Object)var1_1, (String)"task"));
    }

    protected void afterRunningAllTasks() {
        SingleThreadEventLoop singleThreadEventLoop = this;
        singleThreadEventLoop.runAllTasksFrom(singleThreadEventLoop.tailTasks);
    }

    protected boolean hasTasks() {
        return super.hasTasks() || !this.tailTasks.isEmpty();
    }

    public int pendingTasks() {
        return super.pendingTasks() + this.tailTasks.size();
    }

    public int registeredChannels() {
        return -1;
    }

    public Iterator<Channel> registeredChannelsIterator() {
        throw new UnsupportedOperationException("registeredChannelsIterator");
    }

    protected static final class ChannelsReadOnlyIterator<T extends Channel>
    implements Iterator<Channel> {
        private final Iterator<T> channelIterator;
        private static final Iterator<Object> EMPTY = new Iterator<Object>(){

            @Override
            public final boolean hasNext() {
                return false;
            }

            @Override
            public final Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };

        /*
         * WARNING - void declaration
         */
        public ChannelsReadOnlyIterator(Iterable<T> channelIterable) {
            void var1_1;
            this.channelIterator = ((Iterable)ObjectUtil.checkNotNull((Object)var1_1, (String)"channelIterable")).iterator();
        }

        @Override
        public final boolean hasNext() {
            return this.channelIterator.hasNext();
        }

        @Override
        public final Channel next() {
            return (Channel)this.channelIterator.next();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public static <T> Iterator<T> empty() {
            return EMPTY;
        }
    }
}

