/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class SimpleChannelInboundHandler<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean autoRelease;

    protected SimpleChannelInboundHandler() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    protected SimpleChannelInboundHandler(boolean autoRelease) {
        void var1_1;
        this.matcher = TypeParameterMatcher.find((Object)this, SimpleChannelInboundHandler.class, (String)"I");
        this.autoRelease = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SimpleChannelInboundHandler(Class<? extends I> inboundMessageType) {
        this((Class<I>)var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SimpleChannelInboundHandler(Class<? extends I> inboundMessageType, boolean autoRelease) {
        void var2_2;
        void var1_1;
        this.matcher = TypeParameterMatcher.get((Class)var1_1);
        this.autoRelease = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean acceptInboundMessage(Object msg) throws Exception {
        void var1_1;
        return this.matcher.match((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        boolean release = true;
        try {
            if (this.acceptInboundMessage(msg)) {
                Object imsg = msg;
                this.channelRead0(ctx, imsg);
            } else {
                void var1_1;
                release = false;
                var1_1.fireChannelRead(msg);
            }
            if (!this.autoRelease || !release) return;
        }
        catch (Throwable throwable) {
            void var2_3;
            void var3_4;
            if (!this.autoRelease || var3_4 == false) throw throwable;
            ReferenceCountUtil.release((Object)var2_3);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)msg);
    }

    protected abstract void channelRead0(ChannelHandlerContext var1, I var2) throws Exception;
}

