/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import io.netty.channel.PendingBytesTracker;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private static final int PENDING_WRITE_OVERHEAD = SystemPropertyUtil.getInt((String)"io.netty.transport.pendingWriteSizeOverhead", (int)64);
    private final ChannelOutboundInvoker invoker;
    private final EventExecutor executor;
    private final PendingBytesTracker tracker;
    private PendingWrite head;
    private PendingWrite tail;
    private int size;
    private long bytes;

    /*
     * WARNING - void declaration
     */
    public PendingWriteQueue(ChannelHandlerContext ctx) {
        void var1_1;
        this.tracker = PendingBytesTracker.newTracker(ctx.channel());
        this.invoker = ctx;
        this.executor = var1_1.executor();
    }

    /*
     * WARNING - void declaration
     */
    public PendingWriteQueue(Channel channel) {
        void var1_1;
        this.tracker = PendingBytesTracker.newTracker(channel);
        this.invoker = channel;
        this.executor = var1_1.eventLoop();
    }

    public final boolean isEmpty() {
        assert (this.executor.inEventLoop());
        return this.head == null;
    }

    public final int size() {
        assert (this.executor.inEventLoop());
        return this.size;
    }

    public final long bytes() {
        assert (this.executor.inEventLoop());
        return this.bytes;
    }

    /*
     * WARNING - void declaration
     */
    private int size(Object msg) {
        void var1_2;
        int messageSize = this.tracker.size(msg);
        if (messageSize < 0) {
            messageSize = 0;
        }
        return (int)(var1_2 + PENDING_WRITE_OVERHEAD);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(Object msg, ChannelPromise promise) {
        void var1_1;
        void var2_2;
        void var3_3;
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull((Object)msg, (String)"msg");
        ObjectUtil.checkNotNull((Object)promise, (String)"promise");
        int messageSize = this.size(msg);
        PendingWrite write = PendingWrite.newInstance(msg, messageSize, promise);
        PendingWrite currentTail = this.tail;
        if (currentTail == null) {
            PendingWriteQueue pendingWriteQueue = this;
            pendingWriteQueue.tail = pendingWriteQueue.head = write;
        } else {
            PendingWrite.access$002(currentTail, write);
            this.tail = write;
        }
        ++this.size;
        this.bytes += (long)var3_3;
        this.tracker.incrementPendingOutboundBytes(((PendingWrite)var2_2).size);
        if (msg instanceof AbstractReferenceCountedByteBuf) {
            ((AbstractReferenceCountedByteBuf)msg).touch();
            return;
        }
        ReferenceCountUtil.touch((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture removeAndWriteAll() {
        void var1_1;
        assert (this.executor.inEventLoop());
        if (this.isEmpty()) {
            return null;
        }
        ChannelPromise p = this.invoker.newPromise();
        PromiseCombiner combiner = new PromiseCombiner(this.executor);
        try {
            void var2_2;
            PendingWrite write = this.head;
            while (write != null) {
                PendingWriteQueue pendingWriteQueue = this;
                pendingWriteQueue.tail = null;
                pendingWriteQueue.head = null;
                this.size = 0;
                this.bytes = 0L;
                while (write != null) {
                    PendingWrite next = write.next;
                    Object msg = write.msg;
                    ChannelPromise promise = write.promise;
                    this.recycle(write, false);
                    if (!(promise instanceof VoidChannelPromise)) {
                        combiner.add((Promise)promise);
                    }
                    this.invoker.write(msg, promise);
                    write = next;
                }
                write = this.head;
            }
            var2_2.finish((Promise)p);
        }
        catch (Throwable cause) {
            void var3_4;
            p.setFailure((Throwable)var3_4);
        }
        this.assertEmpty();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeAndFailAll(Throwable cause) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull((Object)cause, (String)"cause");
        PendingWrite write = this.head;
        while (write != null) {
            PendingWriteQueue pendingWriteQueue = this;
            pendingWriteQueue.tail = null;
            pendingWriteQueue.head = null;
            this.size = 0;
            this.bytes = 0L;
            while (write != null) {
                void var3_3;
                PendingWrite next = write.next;
                ReferenceCountUtil.safeRelease((Object)write.msg);
                ChannelPromise promise = write.promise;
                this.recycle(write, false);
                PendingWriteQueue.safeFail(promise, cause);
                write = var3_3;
            }
            write = this.head;
        }
        this.assertEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final void removeAndFail(Throwable cause) {
        void var2_2;
        void var1_1;
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull((Object)cause, (String)"cause");
        PendingWrite write = this.head;
        if (write == null) {
            return;
        }
        ReferenceCountUtil.safeRelease((Object)write.msg);
        ChannelPromise channelPromise = write.promise;
        PendingWriteQueue.safeFail(channelPromise, (Throwable)var1_1);
        this.recycle((PendingWrite)var2_2, true);
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture removeAndWrite() {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (this.executor.inEventLoop());
        PendingWrite write = this.head;
        if (write == null) {
            return null;
        }
        Object msg = write.msg;
        ChannelPromise promise = write.promise;
        this.recycle((PendingWrite)var1_1, true);
        return this.invoker.write(var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelPromise remove() {
        void var2_2;
        void var1_1;
        assert (this.executor.inEventLoop());
        PendingWrite write = this.head;
        if (write == null) {
            return null;
        }
        ChannelPromise promise = write.promise;
        ReferenceCountUtil.safeRelease((Object)write.msg);
        this.recycle((PendingWrite)var1_1, true);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Object current() {
        void var1_1;
        assert (this.executor.inEventLoop());
        PendingWrite write = this.head;
        if (write == null) {
            return null;
        }
        return ((PendingWrite)var1_1).msg;
    }

    /*
     * WARNING - void declaration
     */
    private void recycle(PendingWrite write, boolean update) {
        void var1_1;
        void var2_2;
        PendingWrite next = write.next;
        long writeSize = write.size;
        if (var2_2 != false) {
            if (next == null) {
                PendingWriteQueue pendingWriteQueue = this;
                pendingWriteQueue.tail = null;
                pendingWriteQueue.head = null;
                this.size = 0;
                this.bytes = 0L;
            } else {
                void var3_3;
                this.head = var3_3;
                --this.size;
                this.bytes -= writeSize;
                assert (this.size > 0 && this.bytes >= 0L);
            }
        }
        ((PendingWrite)var1_1).recycle();
        this.tracker.decrementPendingOutboundBytes(writeSize);
    }

    /*
     * WARNING - void declaration
     */
    private static void safeFail(ChannelPromise promise, Throwable cause) {
        if (!(promise instanceof VoidChannelPromise) && !promise.tryFailure(cause)) {
            void var1_1;
            ChannelPromise channelPromise;
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)var1_1);
        }
    }

    static final class PendingWrite {
        private static final ObjectPool<PendingWrite> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<PendingWrite>(){

            /*
             * WARNING - void declaration
             */
            public final PendingWrite newObject(ObjectPool.Handle<PendingWrite> handle) {
                void var1_1;
                return new PendingWrite((ObjectPool.Handle)var1_1);
            }
        });
        private final ObjectPool.Handle<PendingWrite> handle;
        private PendingWrite next;
        private long size;
        private ChannelPromise promise;
        private Object msg;

        /*
         * WARNING - void declaration
         */
        private PendingWrite(ObjectPool.Handle<PendingWrite> handle) {
            void var1_1;
            this.handle = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static PendingWrite newInstance(Object msg, int size, ChannelPromise promise) {
            void var3_3;
            void var2_2;
            Object object;
            void var1_1;
            PendingWrite write = (PendingWrite)RECYCLER.get();
            ((PendingWrite)RECYCLER.get()).size = (long)var1_1;
            write.msg = object;
            write.promise = var2_2;
            return var3_3;
        }

        private void recycle() {
            this.size = 0L;
            this.next = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle((Object)this);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ PendingWrite access$002(PendingWrite x0, PendingWrite x1) {
            void var1_1;
            x0.next = var1_1;
            return x0.next;
        }
    }
}

