/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.MessageSizeEstimator;
import io.netty.util.internal.ObjectUtil;

abstract class PendingBytesTracker
implements MessageSizeEstimator.Handle {
    private final MessageSizeEstimator.Handle estimatorHandle;

    /*
     * WARNING - void declaration
     */
    private PendingBytesTracker(MessageSizeEstimator.Handle estimatorHandle) {
        void var1_1;
        this.estimatorHandle = (MessageSizeEstimator.Handle)ObjectUtil.checkNotNull((Object)var1_1, (String)"estimatorHandle");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int size(Object msg) {
        void var1_1;
        return this.estimatorHandle.size(var1_1);
    }

    public abstract void incrementPendingOutboundBytes(long var1);

    public abstract void decrementPendingOutboundBytes(long var1);

    /*
     * WARNING - void declaration
     */
    static PendingBytesTracker newTracker(Channel channel) {
        MessageSizeEstimator.Handle handle;
        void var1_1;
        if (channel.pipeline() instanceof DefaultChannelPipeline) {
            return new DefaultChannelPipelinePendingBytesTracker((DefaultChannelPipeline)channel.pipeline());
        }
        ChannelOutboundBuffer buffer = channel.unsafe().outboundBuffer();
        MessageSizeEstimator.Handle handle2 = channel.config().getMessageSizeEstimator().newHandle();
        if (buffer == null) {
            return new NoopPendingBytesTracker(handle2);
        }
        return new ChannelOutboundBufferPendingBytesTracker((ChannelOutboundBuffer)var1_1, handle);
    }

    private static final class NoopPendingBytesTracker
    extends PendingBytesTracker {
        /*
         * WARNING - void declaration
         */
        NoopPendingBytesTracker(MessageSizeEstimator.Handle estimatorHandle) {
            super((MessageSizeEstimator.Handle)var1_1);
            void var1_1;
        }

        @Override
        public final void incrementPendingOutboundBytes(long bytes) {
        }

        @Override
        public final void decrementPendingOutboundBytes(long bytes) {
        }
    }

    private static final class ChannelOutboundBufferPendingBytesTracker
    extends PendingBytesTracker {
        private final ChannelOutboundBuffer buffer;

        /*
         * WARNING - void declaration
         */
        ChannelOutboundBufferPendingBytesTracker(ChannelOutboundBuffer buffer, MessageSizeEstimator.Handle estimatorHandle) {
            super((MessageSizeEstimator.Handle)var2_2);
            void var1_1;
            void var2_2;
            this.buffer = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void incrementPendingOutboundBytes(long bytes) {
            void var1_1;
            this.buffer.incrementPendingOutboundBytes((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void decrementPendingOutboundBytes(long bytes) {
            void var1_1;
            this.buffer.decrementPendingOutboundBytes((long)var1_1);
        }
    }

    private static final class DefaultChannelPipelinePendingBytesTracker
    extends PendingBytesTracker {
        private final DefaultChannelPipeline pipeline;

        /*
         * WARNING - void declaration
         */
        DefaultChannelPipelinePendingBytesTracker(DefaultChannelPipeline pipeline) {
            super(pipeline.estimatorHandle());
            void var1_1;
            this.pipeline = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void incrementPendingOutboundBytes(long bytes) {
            void var1_1;
            this.pipeline.incrementPendingOutboundBytes((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void decrementPendingOutboundBytes(long bytes) {
            void var1_1;
            this.pipeline.decrementPendingOutboundBytes((long)var1_1);
        }
    }
}

