/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.MultithreadEventExecutorGroup;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public abstract class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() << 1)));

    /*
     * WARNING - void declaration
     */
    protected MultithreadEventLoopGroup(int nThreads, Executor executor, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : var1_1, (Executor)var2_2, (Object[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : var1_1, (ThreadFactory)var2_2, (Object[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected MultithreadEventLoopGroup(int nThreads, Executor executor, EventExecutorChooserFactory chooserFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : var1_1, (Executor)var2_2, (EventExecutorChooserFactory)var3_3, args);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass(), 10);
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    protected abstract EventLoop newChild(Executor var1, Object ... var2) throws Exception;

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture register(Channel channel) {
        void var1_1;
        return this.next().register((Channel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture register(ChannelPromise promise) {
        void var1_1;
        return this.next().register((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.next().register((Channel)var1_1, (ChannelPromise)var2_2);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

