/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PromiseNotificationUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class DelegatingChannelPromiseNotifier
implements ChannelFutureListener,
ChannelPromise {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DelegatingChannelPromiseNotifier.class);
    private final ChannelPromise delegate;
    private final boolean logNotifyFailure;

    /*
     * WARNING - void declaration
     */
    public DelegatingChannelPromiseNotifier(ChannelPromise delegate) {
        void var1_1;
        void v0 = var1_1;
        this((ChannelPromise)v0, !(v0 instanceof VoidChannelPromise));
    }

    /*
     * WARNING - void declaration
     */
    public DelegatingChannelPromiseNotifier(ChannelPromise delegate, boolean logNotifyFailure) {
        void var2_2;
        void var1_1;
        this.delegate = (ChannelPromise)ObjectUtil.checkNotNull((Object)var1_1, (String)"delegate");
        this.logNotifyFailure = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void operationComplete(ChannelFuture future) throws Exception {
        void var2_2;
        void var1_1;
        Void result;
        InternalLogger internalLogger;
        Object object = internalLogger = this.logNotifyFailure ? logger : null;
        if (future.isSuccess()) {
            result = (Void)future.get();
            PromiseNotificationUtil.trySuccess((Promise)this.delegate, (Object)result, (InternalLogger)internalLogger);
            return;
        }
        if (result.isCancelled()) {
            PromiseNotificationUtil.tryCancel((Promise)this.delegate, (InternalLogger)internalLogger);
            return;
        }
        Throwable cause = result.cause();
        PromiseNotificationUtil.tryFailure((Promise)this.delegate, (Throwable)var1_1, (InternalLogger)var2_2);
    }

    @Override
    public final Channel channel() {
        return this.delegate.channel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPromise setSuccess(Void result) {
        void var1_1;
        this.delegate.setSuccess((Void)var1_1);
        return this;
    }

    @Override
    public final ChannelPromise setSuccess() {
        this.delegate.setSuccess();
        return this;
    }

    @Override
    public final boolean trySuccess() {
        return this.delegate.trySuccess();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean trySuccess(Void result) {
        void var1_1;
        return this.delegate.trySuccess(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPromise setFailure(Throwable cause) {
        void var1_1;
        this.delegate.setFailure((Throwable)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        void var1_1;
        this.delegate.addListener((GenericFutureListener<? extends Future<? super Void>>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        void var1_1;
        this.delegate.addListeners((GenericFutureListener<? extends Future<? super Void>>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        void var1_1;
        this.delegate.removeListener((GenericFutureListener<? extends Future<? super Void>>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        void var1_1;
        this.delegate.removeListeners((GenericFutureListener<? extends Future<? super Void>>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryFailure(Throwable cause) {
        void var1_1;
        return this.delegate.tryFailure((Throwable)var1_1);
    }

    public final boolean setUncancellable() {
        return this.delegate.setUncancellable();
    }

    @Override
    public final ChannelPromise await() throws InterruptedException {
        this.delegate.await();
        return this;
    }

    @Override
    public final ChannelPromise awaitUninterruptibly() {
        this.delegate.awaitUninterruptibly();
        return this;
    }

    @Override
    public final boolean isVoid() {
        return this.delegate.isVoid();
    }

    @Override
    public final ChannelPromise unvoid() {
        if (this.isVoid()) {
            return new DelegatingChannelPromiseNotifier(this.delegate.unvoid());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        void var3_2;
        void var1_1;
        return this.delegate.await((long)var1_1, (TimeUnit)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean await(long timeoutMillis) throws InterruptedException {
        void var1_1;
        return this.delegate.await((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        void var3_2;
        void var1_1;
        return this.delegate.awaitUninterruptibly((long)var1_1, (TimeUnit)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean awaitUninterruptibly(long timeoutMillis) {
        void var1_1;
        return this.delegate.awaitUninterruptibly((long)var1_1);
    }

    public final Void getNow() {
        return (Void)this.delegate.getNow();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean cancel(boolean mayInterruptIfRunning) {
        void var1_1;
        return this.delegate.cancel((boolean)var1_1);
    }

    public final boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public final boolean isDone() {
        return this.delegate.isDone();
    }

    public final Void get() throws InterruptedException, ExecutionException {
        return (Void)this.delegate.get();
    }

    /*
     * WARNING - void declaration
     */
    public final Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        void var3_2;
        void var1_1;
        return (Void)this.delegate.get((long)var1_1, (TimeUnit)var3_2);
    }

    @Override
    public final ChannelPromise sync() throws InterruptedException {
        this.delegate.sync();
        return this;
    }

    @Override
    public final ChannelPromise syncUninterruptibly() {
        this.delegate.syncUninterruptibly();
        return this;
    }

    public final boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    public final boolean isCancellable() {
        return this.delegate.isCancellable();
    }

    public final Throwable cause() {
        return this.delegate.cause();
    }
}

