/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.FileRegion;
import io.netty.channel.MessageSizeEstimator;
import io.netty.util.internal.ObjectUtil;

public final class DefaultMessageSizeEstimator
implements MessageSizeEstimator {
    public static final MessageSizeEstimator DEFAULT = new DefaultMessageSizeEstimator(8);
    private final MessageSizeEstimator.Handle handle;

    /*
     * WARNING - void declaration
     */
    public DefaultMessageSizeEstimator(int unknownSize) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)unknownSize, (String)"unknownSize");
        this.handle = new HandleImpl((int)var1_1);
    }

    @Override
    public final MessageSizeEstimator.Handle newHandle() {
        return this.handle;
    }

    private static final class HandleImpl
    implements MessageSizeEstimator.Handle {
        private final int unknownSize;

        /*
         * WARNING - void declaration
         */
        private HandleImpl(int unknownSize) {
            void var1_1;
            this.unknownSize = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int size(Object msg) {
            void var1_1;
            if (msg instanceof ByteBuf) {
                return ((ByteBuf)msg).readableBytes();
            }
            if (msg instanceof ByteBufHolder) {
                return ((ByteBufHolder)msg).content().readableBytes();
            }
            if (var1_1 instanceof FileRegion) {
                return 0;
            }
            return this.unknownSize;
        }
    }
}

