/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelConfig;
import io.netty.channel.MaxBytesRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.ObjectUtil;
import java.util.AbstractMap;
import java.util.Map;

public class DefaultMaxBytesRecvByteBufAllocator
implements MaxBytesRecvByteBufAllocator {
    private volatile int maxBytesPerRead;
    private volatile int maxBytesPerIndividualRead;

    public DefaultMaxBytesRecvByteBufAllocator() {
        this(65536, 65536);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultMaxBytesRecvByteBufAllocator(int maxBytesPerRead, int maxBytesPerIndividualRead) {
        void var2_2;
        void var1_1;
        DefaultMaxBytesRecvByteBufAllocator.checkMaxBytesPerReadPair(maxBytesPerRead, maxBytesPerIndividualRead);
        this.maxBytesPerRead = var1_1;
        this.maxBytesPerIndividualRead = var2_2;
    }

    @Override
    public RecvByteBufAllocator.Handle newHandle() {
        return new HandleImpl();
    }

    @Override
    public int maxBytesPerRead() {
        return this.maxBytesPerRead;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DefaultMaxBytesRecvByteBufAllocator maxBytesPerRead(int maxBytesPerRead) {
        ObjectUtil.checkPositive((int)maxBytesPerRead, (String)"maxBytesPerRead");
        DefaultMaxBytesRecvByteBufAllocator defaultMaxBytesRecvByteBufAllocator = this;
        synchronized (defaultMaxBytesRecvByteBufAllocator) {
            void var1_1;
            int maxBytesPerIndividualRead = this.maxBytesPerIndividualRead();
            if (maxBytesPerRead < maxBytesPerIndividualRead) {
                void var3_4;
                throw new IllegalArgumentException("maxBytesPerRead cannot be less than maxBytesPerIndividualRead (" + (int)var3_4 + "): " + maxBytesPerRead);
            }
            this.maxBytesPerRead = var1_1;
        }
        return this;
    }

    @Override
    public int maxBytesPerIndividualRead() {
        return this.maxBytesPerIndividualRead;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DefaultMaxBytesRecvByteBufAllocator maxBytesPerIndividualRead(int maxBytesPerIndividualRead) {
        ObjectUtil.checkPositive((int)maxBytesPerIndividualRead, (String)"maxBytesPerIndividualRead");
        DefaultMaxBytesRecvByteBufAllocator defaultMaxBytesRecvByteBufAllocator = this;
        synchronized (defaultMaxBytesRecvByteBufAllocator) {
            void var1_1;
            int maxBytesPerRead = this.maxBytesPerRead();
            if (maxBytesPerIndividualRead > maxBytesPerRead) {
                void var3_4;
                throw new IllegalArgumentException("maxBytesPerIndividualRead cannot be greater than maxBytesPerRead (" + (int)var3_4 + "): " + maxBytesPerIndividualRead);
            }
            this.maxBytesPerIndividualRead = var1_1;
        }
        return this;
    }

    @Override
    public synchronized Map.Entry<Integer, Integer> maxBytesPerReadPair() {
        return new AbstractMap.SimpleEntry<Integer, Integer>(this.maxBytesPerRead, this.maxBytesPerIndividualRead);
    }

    /*
     * WARNING - void declaration
     */
    private static void checkMaxBytesPerReadPair(int maxBytesPerRead, int maxBytesPerIndividualRead) {
        ObjectUtil.checkPositive((int)maxBytesPerRead, (String)"maxBytesPerRead");
        ObjectUtil.checkPositive((int)maxBytesPerIndividualRead, (String)"maxBytesPerIndividualRead");
        if (maxBytesPerRead < maxBytesPerIndividualRead) {
            int n;
            void var1_1;
            throw new IllegalArgumentException("maxBytesPerRead cannot be less than maxBytesPerIndividualRead (" + (int)var1_1 + "): " + n);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DefaultMaxBytesRecvByteBufAllocator maxBytesPerReadPair(int maxBytesPerRead, int maxBytesPerIndividualRead) {
        DefaultMaxBytesRecvByteBufAllocator.checkMaxBytesPerReadPair(maxBytesPerRead, maxBytesPerIndividualRead);
        DefaultMaxBytesRecvByteBufAllocator defaultMaxBytesRecvByteBufAllocator = this;
        synchronized (defaultMaxBytesRecvByteBufAllocator) {
            void var2_3;
            void var1_1;
            this.maxBytesPerRead = var1_1;
            this.maxBytesPerIndividualRead = var2_3;
        }
        return this;
    }

    private final class HandleImpl
    implements RecvByteBufAllocator.ExtendedHandle {
        private int individualReadMax;
        private int bytesToRead;
        private int lastBytesRead;
        private int attemptBytesRead;
        private final UncheckedBooleanSupplier defaultMaybeMoreSupplier = new UncheckedBooleanSupplier(this){
            final /* synthetic */ HandleImpl this$1;
            {
                void var1_1;
                this.this$1 = var1_1;
            }

            public boolean get() {
                return this.this$1.attemptBytesRead == this.this$1.lastBytesRead;
            }
        };

        private HandleImpl() {
        }

        @Override
        public final ByteBuf allocate(ByteBufAllocator alloc) {
            return alloc.ioBuffer(this.guess());
        }

        @Override
        public final int guess() {
            return Math.min(this.individualReadMax, this.bytesToRead);
        }

        @Override
        public final void reset(ChannelConfig config) {
            this.bytesToRead = DefaultMaxBytesRecvByteBufAllocator.this.maxBytesPerRead();
            this.individualReadMax = DefaultMaxBytesRecvByteBufAllocator.this.maxBytesPerIndividualRead();
        }

        @Override
        public final void incMessagesRead(int amt) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void lastBytesRead(int bytes) {
            void var1_1;
            this.lastBytesRead = bytes;
            this.bytesToRead -= var1_1;
        }

        @Override
        public final int lastBytesRead() {
            return this.lastBytesRead;
        }

        @Override
        public final boolean continueReading() {
            HandleImpl handleImpl = this;
            return handleImpl.continueReading(handleImpl.defaultMaybeMoreSupplier);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean continueReading(UncheckedBooleanSupplier maybeMoreDataSupplier) {
            void var1_1;
            return this.bytesToRead > 0 && var1_1.get();
        }

        @Override
        public final void readComplete() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void attemptedBytesRead(int bytes) {
            void var1_1;
            this.attemptBytesRead = var1_1;
        }

        @Override
        public final int attemptedBytesRead() {
            return this.attemptBytesRead;
        }
    }
}

