/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class DefaultFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultFileRegion.class);
    private final File f;
    private final long position;
    private final long count;
    private long transferred;
    private FileChannel file;

    /*
     * WARNING - void declaration
     */
    public DefaultFileRegion(FileChannel fileChannel, long position, long count) {
        void var2_2;
        void var1_1;
        this.file = (FileChannel)ObjectUtil.checkNotNull((Object)var1_1, (String)"fileChannel");
        this.position = ObjectUtil.checkPositiveOrZero((long)var2_2, (String)"position");
        this.count = ObjectUtil.checkPositiveOrZero((long)count, (String)"count");
        this.f = null;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultFileRegion(File file, long position, long count) {
        void var2_2;
        void var1_1;
        this.f = (File)ObjectUtil.checkNotNull((Object)var1_1, (String)"file");
        this.position = ObjectUtil.checkPositiveOrZero((long)var2_2, (String)"position");
        this.count = ObjectUtil.checkPositiveOrZero((long)count, (String)"count");
    }

    public boolean isOpen() {
        return this.file != null;
    }

    public void open() throws IOException {
        if (!this.isOpen() && this.refCnt() > 0) {
            this.file = new RandomAccessFile(this.f, "r").getChannel();
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    @Deprecated
    public long transfered() {
        return this.transferred;
    }

    @Override
    public long transferred() {
        return this.transferred;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long transferTo(WritableByteChannel target, long position) throws IOException {
        void var1_1;
        long count = this.count - position;
        if (count < 0L || position < 0L) {
            throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ')');
        }
        if (count == 0L) {
            return 0L;
        }
        if (this.refCnt() == 0) {
            throw new IllegalReferenceCountException(0);
        }
        this.open();
        long written = this.file.transferTo(this.position + position, count, (WritableByteChannel)var1_1);
        if (written > 0L) {
            this.transferred += written;
        } else if (written == 0L) {
            void var2_2;
            DefaultFileRegion.validate(this, (long)var2_2);
        }
        return written;
    }

    /*
     * WARNING - void declaration
     */
    protected void deallocate() {
        FileChannel file = this.file;
        if (file == null) {
            return;
        }
        this.file = null;
        try {
            file.close();
            return;
        }
        catch (IOException e) {
            void var1_2;
            logger.warn("Failed to close a file.", (Throwable)var1_2);
            return;
        }
    }

    @Override
    public FileRegion retain() {
        super.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileRegion retain(int increment) {
        void var1_1;
        super.retain((int)var1_1);
        return this;
    }

    @Override
    public FileRegion touch() {
        return this;
    }

    @Override
    public FileRegion touch(Object hint) {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static void validate(DefaultFileRegion region, long position) throws IOException {
        void var1_1;
        long count = region.count - position;
        long size = region.file.size();
        if (region.position + count + var1_1 > size) {
            DefaultFileRegion defaultFileRegion;
            void var3_2;
            throw new IOException("Underlying file size " + (long)var3_2 + " smaller then requested count " + defaultFileRegion.count);
        }
    }
}

