/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.AbstractChannelHandlerContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelHandlerContext;
import io.netty.channel.DefaultChannelProgressivePromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.SucceededChannelFuture;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultChannelPipeline
implements ChannelPipeline {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelPipeline.class);
    private static final String HEAD_NAME = DefaultChannelPipeline.generateName0(HeadContext.class);
    private static final String TAIL_NAME = DefaultChannelPipeline.generateName0(TailContext.class);
    private static final FastThreadLocal<Map<Class<?>, String>> nameCaches = new FastThreadLocal<Map<Class<?>, String>>(){

        protected final Map<Class<?>, String> initialValue() {
            return new WeakHashMap();
        }
    };
    private static final AtomicReferenceFieldUpdater<DefaultChannelPipeline, MessageSizeEstimator.Handle> ESTIMATOR = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelPipeline.class, MessageSizeEstimator.Handle.class, "estimatorHandle");
    final HeadContext head;
    final TailContext tail;
    private final Channel channel;
    private final ChannelFuture succeededFuture;
    private final VoidChannelPromise voidPromise;
    private final boolean touch = ResourceLeakDetector.isEnabled();
    private Map<EventExecutorGroup, EventExecutor> childExecutors;
    private volatile MessageSizeEstimator.Handle estimatorHandle;
    private boolean firstRegistration = true;
    private PendingHandlerCallback pendingHandlerCallbackHead;
    private boolean registered;

    /*
     * WARNING - void declaration
     */
    protected DefaultChannelPipeline(Channel channel) {
        void var1_1;
        this.channel = (Channel)ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        this.succeededFuture = new SucceededChannelFuture(channel, null);
        this.voidPromise = new VoidChannelPromise((Channel)var1_1, true);
        DefaultChannelPipeline defaultChannelPipeline = this;
        this.tail = new TailContext(defaultChannelPipeline, defaultChannelPipeline);
        DefaultChannelPipeline defaultChannelPipeline2 = this;
        this.head = new HeadContext(defaultChannelPipeline2, defaultChannelPipeline2);
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    /*
     * WARNING - void declaration
     */
    final MessageSizeEstimator.Handle estimatorHandle() {
        void var1_1;
        MessageSizeEstimator.Handle handle = this.estimatorHandle;
        if (handle == null && !ESTIMATOR.compareAndSet(this, null, handle = this.channel.config().getMessageSizeEstimator().newHandle())) {
            handle = this.estimatorHandle;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final Object touch(Object msg, AbstractChannelHandlerContext next) {
        void var1_1;
        if (this.touch) {
            void var2_2;
            return ReferenceCountUtil.touch((Object)msg, (Object)var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractChannelHandlerContext newContext(EventExecutorGroup group, String name, ChannelHandler handler) {
        void var3_3;
        void var2_2;
        void var1_1;
        DefaultChannelPipeline defaultChannelPipeline = this;
        return new DefaultChannelHandlerContext(defaultChannelPipeline, defaultChannelPipeline.childExecutor((EventExecutorGroup)var1_1), (String)var2_2, (ChannelHandler)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private EventExecutor childExecutor(EventExecutorGroup group) {
        void var3_3;
        EventExecutor childExecutor;
        if (group == null) {
            return null;
        }
        Boolean pinEventExecutor = this.channel.config().getOption(ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP);
        if (pinEventExecutor != null && !pinEventExecutor.booleanValue()) {
            return group.next();
        }
        Map<EventExecutorGroup, EventExecutor> childExecutors = this.childExecutors;
        if (childExecutors == null) {
            childExecutors = this.childExecutors = new IdentityHashMap<EventExecutorGroup, EventExecutor>(4);
        }
        if ((childExecutor = childExecutors.get(group)) == null) {
            void var1_1;
            void var2_2;
            childExecutor = group.next();
            var2_2.put(var1_1, childExecutor);
        }
        return var3_3;
    }

    @Override
    public final Channel channel() {
        return this.channel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline addFirst(String name, ChannelHandler handler) {
        void var2_2;
        void var1_1;
        return this.addFirst(null, (String)var1_1, (ChannelHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelPipeline internalAdd(EventExecutorGroup group, String name, ChannelHandler handler, String baseName, AddStrategy addStrategy) {
        void var1_1;
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            void var3_4;
            DefaultChannelPipeline.checkMultiplicity(handler);
            name = this.filterName(name, handler);
            AbstractChannelHandlerContext newCtx = this.newContext(group, name, (ChannelHandler)var3_4);
            switch (addStrategy) {
                case ADD_FIRST: {
                    this.addFirst0(newCtx);
                    break;
                }
                case ADD_LAST: {
                    this.addLast0(newCtx);
                    break;
                }
                case ADD_BEFORE: {
                    DefaultChannelPipeline.addBefore0(this.getContextOrDie(baseName), newCtx);
                    break;
                }
                case ADD_AFTER: {
                    DefaultChannelPipeline.addAfter0(this.getContextOrDie(baseName), newCtx);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown add strategy: " + (Object)((Object)addStrategy));
                }
            }
            if (!this.registered) {
                newCtx.setAddPending();
                this.callHandlerCallbackLater(newCtx, true);
                return this;
            }
            EventExecutor executor = newCtx.executor();
            if (!executor.inEventLoop()) {
                void var2_3;
                this.callHandlerAddedInEventLoop(newCtx, (EventExecutor)var2_3);
                return this;
            }
        }
        this.callHandlerAdded0((AbstractChannelHandlerContext)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline addFirst(EventExecutorGroup group, String name, ChannelHandler handler) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.internalAdd((EventExecutorGroup)var1_1, (String)var2_2, (ChannelHandler)var3_3, null, AddStrategy.ADD_FIRST);
    }

    /*
     * WARNING - void declaration
     */
    private void addFirst0(AbstractChannelHandlerContext newCtx) {
        void var1_1;
        AbstractChannelHandlerContext nextCtx = this.head.next;
        newCtx.prev = this.head;
        newCtx.next = nextCtx;
        this.head.next = newCtx;
        var2_2.prev = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline addLast(String name, ChannelHandler handler) {
        void var2_2;
        void var1_1;
        return this.addLast(null, (String)var1_1, (ChannelHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline addLast(EventExecutorGroup group, String name, ChannelHandler handler) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.internalAdd((EventExecutorGroup)var1_1, (String)var2_2, (ChannelHandler)var3_3, null, AddStrategy.ADD_LAST);
    }

    /*
     * WARNING - void declaration
     */
    private void addLast0(AbstractChannelHandlerContext newCtx) {
        void var1_1;
        AbstractChannelHandlerContext prev;
        newCtx.prev = prev = this.tail.prev;
        newCtx.next = this.tail;
        var2_2.next = newCtx;
        this.tail.prev = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline addBefore(String baseName, String name, ChannelHandler handler) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addBefore(null, (String)var1_1, (String)var2_2, (ChannelHandler)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline addBefore(EventExecutorGroup group, String baseName, String name, ChannelHandler handler) {
        void var2_2;
        void var3_3;
        void var1_1;
        return this.internalAdd((EventExecutorGroup)var1_1, (String)var3_3, handler, (String)var2_2, AddStrategy.ADD_BEFORE);
    }

    /*
     * WARNING - void declaration
     */
    private static void addBefore0(AbstractChannelHandlerContext ctx, AbstractChannelHandlerContext newCtx) {
        void var1_1;
        newCtx.prev = ctx.prev;
        newCtx.next = ctx;
        ctx.prev.next = newCtx;
        var0.prev = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String filterName(String name, ChannelHandler handler) {
        void var1_1;
        if (name == null) {
            void var2_2;
            return this.generateName((ChannelHandler)var2_2);
        }
        this.checkDuplicateName(name);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline addAfter(String baseName, String name, ChannelHandler handler) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addAfter(null, (String)var1_1, (String)var2_2, (ChannelHandler)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline addAfter(EventExecutorGroup group, String baseName, String name, ChannelHandler handler) {
        void var2_2;
        void var3_3;
        void var1_1;
        return this.internalAdd((EventExecutorGroup)var1_1, (String)var3_3, handler, (String)var2_2, AddStrategy.ADD_AFTER);
    }

    /*
     * WARNING - void declaration
     */
    private static void addAfter0(AbstractChannelHandlerContext ctx, AbstractChannelHandlerContext newCtx) {
        void var1_1;
        newCtx.prev = ctx;
        newCtx.next = ctx.next;
        ctx.next.prev = newCtx;
        var0.next = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelPipeline addFirst(ChannelHandler handler) {
        void var1_1;
        return this.addFirst((String)null, (ChannelHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline addFirst(ChannelHandler ... handlers) {
        void var1_1;
        return this.addFirst((EventExecutorGroup)null, (ChannelHandler[])var1_1);
    }

    @Override
    public final ChannelPipeline addFirst(EventExecutorGroup executor, ChannelHandler ... handlers) {
        ObjectUtil.checkNotNull((Object)handlers, (String)"handlers");
        if (handlers.length == 0 || handlers[0] == null) {
            return this;
        }
        for (int size = 1; size < handlers.length && handlers[size] != null; ++size) {
        }
        for (int i = size - 1; i >= 0; --i) {
            ChannelHandler h = handlers[i];
            this.addFirst(executor, (String)null, h);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelPipeline addLast(ChannelHandler handler) {
        void var1_1;
        return this.addLast((String)null, (ChannelHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline addLast(ChannelHandler ... handlers) {
        void var1_1;
        return this.addLast((EventExecutorGroup)null, (ChannelHandler[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline addLast(EventExecutorGroup executor, ChannelHandler ... handlers) {
        void var2_2;
        ObjectUtil.checkNotNull((Object)handlers, (String)"handlers");
        for (void h : var2_2) {
            if (h == null) break;
            this.addLast(executor, (String)null, (ChannelHandler)h);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private String generateName(ChannelHandler handler) {
        void var3_4;
        Class<?> handlerType;
        Map cache = (Map)nameCaches.get();
        String name = (String)cache.get(handlerType = handler.getClass());
        if (name == null) {
            name = DefaultChannelPipeline.generateName0(handlerType);
            cache.put(handlerType, name);
        }
        if (this.context0(name) != null) {
            String newName;
            String baseName = name.substring(0, name.length() - 1);
            int i = 1;
            while (this.context0(newName = baseName + i) != null) {
                ++i;
            }
        }
        return var3_4;
    }

    private static String generateName0(Class<?> handlerType) {
        Class<?> clazz;
        return StringUtil.simpleClassName(clazz) + "#0";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline remove(ChannelHandler handler) {
        void var1_1;
        DefaultChannelPipeline defaultChannelPipeline = this;
        defaultChannelPipeline.remove(defaultChannelPipeline.getContextOrDie((ChannelHandler)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelHandler remove(String name) {
        void var1_1;
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.remove(defaultChannelPipeline.getContextOrDie((String)var1_1)).handler();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T extends ChannelHandler> T remove(Class<T> handlerType) {
        void var1_1;
        DefaultChannelPipeline defaultChannelPipeline = this;
        return (T)defaultChannelPipeline.remove(defaultChannelPipeline.getContextOrDie((Class<? extends ChannelHandler>)var1_1)).handler();
    }

    /*
     * WARNING - void declaration
     */
    public final <T extends ChannelHandler> T removeIfExists(String name) {
        void var1_1;
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.removeIfExists(defaultChannelPipeline.context((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final <T extends ChannelHandler> T removeIfExists(Class<T> handlerType) {
        void var1_1;
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.removeIfExists(defaultChannelPipeline.context((Class<? extends ChannelHandler>)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final <T extends ChannelHandler> T removeIfExists(ChannelHandler handler) {
        void var1_1;
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.removeIfExists(defaultChannelPipeline.context((ChannelHandler)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private <T extends ChannelHandler> T removeIfExists(ChannelHandlerContext ctx) {
        void var1_1;
        if (ctx == null) {
            return null;
        }
        return (T)this.remove((AbstractChannelHandlerContext)var1_1).handler();
    }

    /*
     * WARNING - void declaration
     */
    private AbstractChannelHandlerContext remove(AbstractChannelHandlerContext ctx) {
        void var1_1;
        assert (ctx != this.head && ctx != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            this.atomicRemoveFromHandlerList(ctx);
            if (!this.registered) {
                this.callHandlerCallbackLater(ctx, false);
                return ctx;
            }
            EventExecutor executor = ctx.executor();
            if (!executor.inEventLoop()) {
                void var3_4;
                var3_4.execute(new Runnable(this, ctx){
                    final /* synthetic */ AbstractChannelHandlerContext val$ctx;
                    final /* synthetic */ DefaultChannelPipeline this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$ctx = abstractChannelHandlerContext;
                    }

                    @Override
                    public void run() {
                        DefaultChannelPipeline.access$000(this.this$0, this.val$ctx);
                    }
                });
                return ctx;
            }
        }
        this.callHandlerRemoved0(ctx);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void atomicRemoveFromHandlerList(AbstractChannelHandlerContext ctx) {
        void var2_2;
        AbstractChannelHandlerContext next;
        AbstractChannelHandlerContext prev = ctx.prev;
        prev.next = next = ctx.next;
        var1_1.prev = var2_2;
    }

    @Override
    public final ChannelHandler removeFirst() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.remove(defaultChannelPipeline.head.next).handler();
    }

    @Override
    public final ChannelHandler removeLast() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.remove(defaultChannelPipeline.tail.prev).handler();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline replace(ChannelHandler oldHandler, String newName, ChannelHandler newHandler) {
        void var3_3;
        void var2_2;
        void var1_1;
        DefaultChannelPipeline defaultChannelPipeline = this;
        defaultChannelPipeline.replace(defaultChannelPipeline.getContextOrDie((ChannelHandler)var1_1), (String)var2_2, (ChannelHandler)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelHandler replace(String oldName, String newName, ChannelHandler newHandler) {
        void var3_3;
        void var2_2;
        void var1_1;
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.replace(defaultChannelPipeline.getContextOrDie((String)var1_1), (String)var2_2, (ChannelHandler)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T extends ChannelHandler> T replace(Class<T> oldHandlerType, String newName, ChannelHandler newHandler) {
        void var3_3;
        void var2_2;
        void var1_1;
        DefaultChannelPipeline defaultChannelPipeline = this;
        return (T)defaultChannelPipeline.replace(defaultChannelPipeline.getContextOrDie((Class<? extends ChannelHandler>)var1_1), (String)var2_2, (ChannelHandler)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelHandler replace(AbstractChannelHandlerContext ctx, String newName, ChannelHandler newHandler) {
        void var1_1;
        void var2_3;
        assert (ctx != this.head && ctx != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            void var3_4;
            DefaultChannelPipeline.checkMultiplicity(newHandler);
            if (newName == null) {
                newName = this.generateName(newHandler);
            } else {
                boolean bl = ctx.name().equals(newName);
                if (!bl) {
                    this.checkDuplicateName(newName);
                }
            }
            AbstractChannelHandlerContext newCtx = this.newContext((EventExecutorGroup)ctx.executor, newName, (ChannelHandler)var3_4);
            DefaultChannelPipeline.replace0(ctx, newCtx);
            if (!this.registered) {
                this.callHandlerCallbackLater(newCtx, true);
                this.callHandlerCallbackLater(ctx, false);
                return ctx.handler();
            }
            EventExecutor executor = ctx.executor();
            if (!executor.inEventLoop()) {
                executor.execute(new Runnable(this, newCtx, ctx){
                    final /* synthetic */ AbstractChannelHandlerContext val$newCtx;
                    final /* synthetic */ AbstractChannelHandlerContext val$ctx;
                    final /* synthetic */ DefaultChannelPipeline this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$newCtx = abstractChannelHandlerContext;
                        this.val$ctx = abstractChannelHandlerContext2;
                    }

                    @Override
                    public void run() {
                        DefaultChannelPipeline.access$100(this.this$0, this.val$newCtx);
                        DefaultChannelPipeline.access$000(this.this$0, this.val$ctx);
                    }
                });
                return ctx.handler();
            }
        }
        this.callHandlerAdded0((AbstractChannelHandlerContext)var2_3);
        this.callHandlerRemoved0(ctx);
        return var1_1.handler();
    }

    /*
     * WARNING - void declaration
     */
    private static void replace0(AbstractChannelHandlerContext oldCtx, AbstractChannelHandlerContext newCtx) {
        void var1_1;
        AbstractChannelHandlerContext prev = oldCtx.prev;
        AbstractChannelHandlerContext next = oldCtx.next;
        newCtx.prev = prev;
        newCtx.next = next;
        var2_2.next = newCtx;
        var3_3.prev = newCtx;
        oldCtx.prev = newCtx;
        var0.next = var1_1;
    }

    private static void checkMultiplicity(ChannelHandler handler) {
        if (handler instanceof ChannelHandlerAdapter) {
            ChannelHandler h = (ChannelHandlerAdapter)handler;
            if (!((ChannelHandlerAdapter)h).isSharable() && ((ChannelHandlerAdapter)h).added) {
                throw new ChannelPipelineException(h.getClass().getName() + " is not a @Sharable handler, so can't be added or removed multiple times.");
            }
            ((ChannelHandlerAdapter)var0).added = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callHandlerAdded0(AbstractChannelHandlerContext ctx) {
        try {
            ctx.callHandlerAdded();
            return;
        }
        catch (Throwable t) {
            void var2_2;
            void var1_1;
            void var3_3;
            block5: {
                boolean removed = false;
                try {
                    this.atomicRemoveFromHandlerList(ctx);
                    ctx.callHandlerRemoved();
                    removed = true;
                }
                catch (Throwable t2) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Failed to remove a handler: " + ctx.name(), t2);
                }
            }
            if (var3_3 != false) {
                this.fireExceptionCaught(new ChannelPipelineException(ctx.handler().getClass().getName() + ".handlerAdded() has thrown an exception; removed.", t));
                return;
            }
            this.fireExceptionCaught(new ChannelPipelineException(var1_1.handler().getClass().getName() + ".handlerAdded() has thrown an exception; also failed to remove.", (Throwable)var2_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callHandlerRemoved0(AbstractChannelHandlerContext ctx) {
        try {
            ctx.callHandlerRemoved();
            return;
        }
        catch (Throwable t) {
            void var2_2;
            void var1_1;
            this.fireExceptionCaught(new ChannelPipelineException(var1_1.handler().getClass().getName() + ".handlerRemoved() has thrown an exception.", (Throwable)var2_2));
            return;
        }
    }

    final void invokeHandlerAddedIfNeeded() {
        assert (this.channel.eventLoop().inEventLoop());
        if (this.firstRegistration) {
            this.firstRegistration = false;
            this.callHandlerAddedForAllHandlers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelHandler first() {
        void var1_1;
        ChannelHandlerContext first = this.firstContext();
        if (first == null) {
            return null;
        }
        return var1_1.handler();
    }

    @Override
    public final ChannelHandlerContext firstContext() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        if (abstractChannelHandlerContext == this.tail) {
            return null;
        }
        return this.head.next;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelHandler last() {
        void var1_1;
        AbstractChannelHandlerContext last = this.tail.prev;
        if (last == this.head) {
            return null;
        }
        return var1_1.handler();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelHandlerContext lastContext() {
        void var1_1;
        AbstractChannelHandlerContext last = this.tail.prev;
        if (last == this.head) {
            return null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelHandler get(String name) {
        void var1_1;
        ChannelHandlerContext ctx = this.context(name);
        if (ctx == null) {
            return null;
        }
        return var1_1.handler();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T extends ChannelHandler> T get(Class<T> handlerType) {
        void var1_1;
        ChannelHandlerContext ctx = this.context(handlerType);
        if (ctx == null) {
            return null;
        }
        return (T)var1_1.handler();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelHandlerContext context(String name) {
        void var1_1;
        return this.context0((String)ObjectUtil.checkNotNull((Object)var1_1, (String)"name"));
    }

    @Override
    public final ChannelHandlerContext context(ChannelHandler handler) {
        ObjectUtil.checkNotNull((Object)handler, (String)"handler");
        AbstractChannelHandlerContext ctx = this.head.next;
        while (ctx != null) {
            if (ctx.handler() == handler) {
                return ctx;
            }
            ctx = ctx.next;
        }
        return null;
    }

    @Override
    public final ChannelHandlerContext context(Class<? extends ChannelHandler> handlerType) {
        ObjectUtil.checkNotNull(handlerType, (String)"handlerType");
        AbstractChannelHandlerContext ctx = this.head.next;
        while (ctx != null) {
            if (handlerType.isAssignableFrom(ctx.handler().getClass())) {
                return ctx;
            }
            ctx = ctx.next;
        }
        return null;
    }

    @Override
    public final List<String> names() {
        ArrayList<String> list = new ArrayList<String>();
        AbstractChannelHandlerContext ctx = this.head.next;
        while (ctx != null) {
            list.add(ctx.name());
            ctx = ctx.next;
        }
        return list;
    }

    @Override
    public final Map<String, ChannelHandler> toMap() {
        LinkedHashMap<String, ChannelHandler> map = new LinkedHashMap<String, ChannelHandler>();
        AbstractChannelHandlerContext ctx = this.head.next;
        while (ctx != this.tail) {
            map.put(ctx.name(), ctx.handler());
            ctx = ctx.next;
        }
        return map;
    }

    @Override
    public final Iterator<Map.Entry<String, ChannelHandler>> iterator() {
        return this.toMap().entrySet().iterator();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder().append(StringUtil.simpleClassName((Object)this)).append('{');
        AbstractChannelHandlerContext ctx = this.head.next;
        while (ctx != this.tail) {
            buf.append('(').append(ctx.name()).append(" = ").append(ctx.handler().getClass().getName()).append(')');
            ctx = ctx.next;
            if (ctx == this.tail) break;
            buf.append(", ");
        }
        buf.append('}');
        return var1_1.toString();
    }

    @Override
    public final ChannelPipeline fireChannelRegistered() {
        AbstractChannelHandlerContext.invokeChannelRegistered(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelUnregistered() {
        AbstractChannelHandlerContext.invokeChannelUnregistered(this.head);
        return this;
    }

    private synchronized void destroy() {
        DefaultChannelPipeline defaultChannelPipeline = this;
        defaultChannelPipeline.destroyUp(defaultChannelPipeline.head.next, false);
    }

    private void destroyUp(AbstractChannelHandlerContext ctx, boolean inEventLoop) {
        Thread currentThread = Thread.currentThread();
        TailContext tail = this.tail;
        while (true) {
            AbstractChannelHandlerContext abstractChannelHandlerContext;
            if (ctx == tail) {
                this.destroyDown(currentThread, tail.prev, inEventLoop);
                return;
            }
            EventExecutor executor = ctx.executor();
            if (!inEventLoop && !executor.inEventLoop(currentThread)) {
                executor.execute(new Runnable(this, abstractChannelHandlerContext){
                    final /* synthetic */ AbstractChannelHandlerContext val$finalCtx;
                    final /* synthetic */ DefaultChannelPipeline this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$finalCtx = abstractChannelHandlerContext;
                    }

                    @Override
                    public void run() {
                        DefaultChannelPipeline.access$200(this.this$0, this.val$finalCtx, true);
                    }
                });
                return;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
            inEventLoop = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void destroyDown(Thread currentThread, AbstractChannelHandlerContext ctx, boolean inEventLoop) {
        HeadContext head = this.head;
        while (ctx != head) {
            EventExecutor executor = ctx.executor();
            if (!inEventLoop && !executor.inEventLoop(currentThread)) {
                void var1_1;
                AbstractChannelHandlerContext finalCtx = ctx;
                executor.execute(new Runnable(this, (AbstractChannelHandlerContext)var1_1){
                    final /* synthetic */ AbstractChannelHandlerContext val$finalCtx;
                    final /* synthetic */ DefaultChannelPipeline this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$finalCtx = abstractChannelHandlerContext;
                    }

                    @Override
                    public void run() {
                        DefaultChannelPipeline.access$300(this.this$0, Thread.currentThread(), this.val$finalCtx, true);
                    }
                });
                return;
            }
            this.atomicRemoveFromHandlerList(ctx);
            this.callHandlerRemoved0(ctx);
            ctx = ctx.prev;
            inEventLoop = false;
        }
    }

    @Override
    public final ChannelPipeline fireChannelActive() {
        AbstractChannelHandlerContext.invokeChannelActive(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelInactive() {
        AbstractChannelHandlerContext.invokeChannelInactive(this.head);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline fireExceptionCaught(Throwable cause) {
        void var1_1;
        AbstractChannelHandlerContext.invokeExceptionCaught(this.head, (Throwable)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline fireUserEventTriggered(Object event) {
        void var1_1;
        AbstractChannelHandlerContext.invokeUserEventTriggered(this.head, var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelPipeline fireChannelRead(Object msg) {
        void var1_1;
        AbstractChannelHandlerContext.invokeChannelRead(this.head, var1_1);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelReadComplete() {
        AbstractChannelHandlerContext.invokeChannelReadComplete(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext.invokeChannelWritabilityChanged(this.head);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture bind(SocketAddress localAddress) {
        void var1_1;
        return this.tail.bind((SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture connect(SocketAddress remoteAddress) {
        void var1_1;
        return this.tail.connect((SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        void var2_2;
        void var1_1;
        return this.tail.connect((SocketAddress)var1_1, (SocketAddress)var2_2);
    }

    @Override
    public final ChannelFuture disconnect() {
        return this.tail.disconnect();
    }

    @Override
    public final ChannelFuture close() {
        return this.tail.close();
    }

    @Override
    public final ChannelFuture deregister() {
        return this.tail.deregister();
    }

    @Override
    public final ChannelPipeline flush() {
        this.tail.flush();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.tail.bind((SocketAddress)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.tail.connect((SocketAddress)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.tail.connect((SocketAddress)var1_1, (SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture disconnect(ChannelPromise promise) {
        void var1_1;
        return this.tail.disconnect((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture close(ChannelPromise promise) {
        void var1_1;
        return this.tail.close((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture deregister(ChannelPromise promise) {
        void var1_1;
        return this.tail.deregister((ChannelPromise)var1_1);
    }

    @Override
    public final ChannelPipeline read() {
        this.tail.read();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture write(Object msg) {
        void var1_1;
        return this.tail.write(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture write(Object msg, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.tail.write(var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.tail.writeAndFlush(var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture writeAndFlush(Object msg) {
        void var1_1;
        return this.tail.writeAndFlush(var1_1);
    }

    @Override
    public final ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel);
    }

    @Override
    public final ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel);
    }

    @Override
    public final ChannelFuture newSucceededFuture() {
        return this.succeededFuture;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ChannelFuture newFailedFuture(Throwable cause) {
        void var1_1;
        return new FailedChannelFuture(this.channel, null, (Throwable)var1_1);
    }

    @Override
    public final ChannelPromise voidPromise() {
        return this.voidPromise;
    }

    /*
     * WARNING - void declaration
     */
    private void checkDuplicateName(String name) {
        if (this.context0(name) != null) {
            void var1_1;
            throw new IllegalArgumentException("Duplicate handler name: " + (String)var1_1);
        }
    }

    private AbstractChannelHandlerContext context0(String name) {
        AbstractChannelHandlerContext context = this.head.next;
        while (context != this.tail) {
            if (context.name().equals(name)) {
                return context;
            }
            context = context.next;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractChannelHandlerContext getContextOrDie(String name) {
        void var2_2;
        AbstractChannelHandlerContext ctx = (AbstractChannelHandlerContext)this.context(name);
        if (ctx == null) {
            void var1_1;
            throw new NoSuchElementException((String)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractChannelHandlerContext getContextOrDie(ChannelHandler handler) {
        void var2_2;
        AbstractChannelHandlerContext ctx = (AbstractChannelHandlerContext)this.context(handler);
        if (ctx == null) {
            void var1_1;
            throw new NoSuchElementException(var1_1.getClass().getName());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractChannelHandlerContext getContextOrDie(Class<? extends ChannelHandler> handlerType) {
        void var2_2;
        AbstractChannelHandlerContext ctx = (AbstractChannelHandlerContext)this.context(handlerType);
        if (ctx == null) {
            void var1_1;
            throw new NoSuchElementException(var1_1.getName());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void callHandlerAddedForAllHandlers() {
        void var1_2;
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            assert (!this.registered);
            this.registered = true;
            PendingHandlerCallback pendingHandlerCallbackHead = this.pendingHandlerCallbackHead;
            this.pendingHandlerCallbackHead = null;
        }
        PendingHandlerCallback task = var1_2;
        while (task != null) {
            task.execute();
            task = task.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callHandlerCallbackLater(AbstractChannelHandlerContext ctx, boolean added) {
        void var1_1;
        assert (!this.registered);
        PendingHandlerCallback task = added ? new PendingHandlerAddedTask(ctx) : new PendingHandlerRemovedTask(ctx);
        PendingHandlerCallback pending = this.pendingHandlerCallbackHead;
        if (pending == null) {
            this.pendingHandlerCallbackHead = task;
            return;
        }
        while (pending.next != null) {
            pending = pending.next;
        }
        var2_3.next = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void callHandlerAddedInEventLoop(AbstractChannelHandlerContext newCtx, EventExecutor executor) {
        void var1_1;
        void var2_2;
        newCtx.setAddPending();
        var2_2.execute(new Runnable(this, (AbstractChannelHandlerContext)var1_1){
            final /* synthetic */ AbstractChannelHandlerContext val$newCtx;
            final /* synthetic */ DefaultChannelPipeline this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$newCtx = abstractChannelHandlerContext;
            }

            @Override
            public void run() {
                DefaultChannelPipeline.access$100(this.this$0, this.val$newCtx);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected void onUnhandledInboundException(Throwable cause) {
        try {
            logger.warn("An exceptionCaught() event was fired, and it reached at the tail of the pipeline. It usually means the last handler in the pipeline did not handle the exception.", cause);
        }
        catch (Throwable throwable) {
            void var1_1;
            ReferenceCountUtil.release((Object)var1_1);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)cause);
    }

    protected void onUnhandledInboundChannelActive() {
    }

    protected void onUnhandledInboundChannelInactive() {
    }

    /*
     * WARNING - void declaration
     */
    protected void onUnhandledInboundMessage(Object msg) {
        try {
            logger.debug("Discarded inbound message {} that reached at the tail of the pipeline. Please check your pipeline configuration.", msg);
        }
        catch (Throwable throwable) {
            void var1_1;
            ReferenceCountUtil.release((Object)var1_1);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)msg);
    }

    /*
     * WARNING - void declaration
     */
    protected void onUnhandledInboundMessage(ChannelHandlerContext ctx, Object msg) {
        void var2_2;
        this.onUnhandledInboundMessage(var2_2);
        if (logger.isDebugEnabled()) {
            void var1_1;
            logger.debug("Discarded message pipeline : {}. Channel : {}.", ctx.pipeline().names(), (Object)var1_1.channel());
        }
    }

    protected void onUnhandledInboundChannelReadComplete() {
    }

    protected void onUnhandledInboundUserEventTriggered(Object evt) {
        ReferenceCountUtil.release((Object)evt);
    }

    protected void onUnhandledChannelWritabilityChanged() {
    }

    /*
     * WARNING - void declaration
     */
    protected void incrementPendingOutboundBytes(long size) {
        ChannelOutboundBuffer buffer = this.channel.unsafe().outboundBuffer();
        if (buffer != null) {
            void var1_1;
            void var3_2;
            var3_2.incrementPendingOutboundBytes((long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void decrementPendingOutboundBytes(long size) {
        ChannelOutboundBuffer buffer = this.channel.unsafe().outboundBuffer();
        if (buffer != null) {
            void var1_1;
            void var3_2;
            var3_2.decrementPendingOutboundBytes((long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(DefaultChannelPipeline x0, AbstractChannelHandlerContext x1) {
        void var1_1;
        x0.callHandlerRemoved0((AbstractChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(DefaultChannelPipeline x0, AbstractChannelHandlerContext x1) {
        void var1_1;
        x0.callHandlerAdded0((AbstractChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(DefaultChannelPipeline x0, AbstractChannelHandlerContext x1, boolean x2) {
        void var2_2;
        void var1_1;
        x0.destroyUp((AbstractChannelHandlerContext)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(DefaultChannelPipeline x0, Thread x1, AbstractChannelHandlerContext x2, boolean x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.destroyDown((Thread)var1_1, (AbstractChannelHandlerContext)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$800(DefaultChannelPipeline x0, AbstractChannelHandlerContext x1) {
        void var1_1;
        x0.atomicRemoveFromHandlerList((AbstractChannelHandlerContext)var1_1);
    }

    private final class PendingHandlerRemovedTask
    extends PendingHandlerCallback {
        /*
         * WARNING - void declaration
         */
        PendingHandlerRemovedTask(AbstractChannelHandlerContext ctx) {
            void var2_2;
            super((AbstractChannelHandlerContext)var2_2);
        }

        @Override
        public final void run() {
            DefaultChannelPipeline.access$000(DefaultChannelPipeline.this, this.ctx);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void execute() {
            EventExecutor executor = this.ctx.executor();
            if (executor.inEventLoop()) {
                DefaultChannelPipeline.access$000(DefaultChannelPipeline.this, this.ctx);
                return;
            }
            try {
                executor.execute((Runnable)this);
                return;
            }
            catch (RejectedExecutionException e) {
                if (logger.isWarnEnabled()) {
                    void var2_2;
                    void var1_1;
                    logger.warn("Can't invoke handlerRemoved() as the EventExecutor {} rejected it, removing handler {}.", new Object[]{var1_1, this.ctx.name(), var2_2});
                }
                this.ctx.setRemoved();
                return;
            }
        }
    }

    private final class PendingHandlerAddedTask
    extends PendingHandlerCallback {
        /*
         * WARNING - void declaration
         */
        PendingHandlerAddedTask(AbstractChannelHandlerContext ctx) {
            void var2_2;
            super((AbstractChannelHandlerContext)var2_2);
        }

        @Override
        public final void run() {
            DefaultChannelPipeline.access$100(DefaultChannelPipeline.this, this.ctx);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void execute() {
            EventExecutor executor = this.ctx.executor();
            if (executor.inEventLoop()) {
                DefaultChannelPipeline.access$100(DefaultChannelPipeline.this, this.ctx);
                return;
            }
            try {
                executor.execute((Runnable)this);
                return;
            }
            catch (RejectedExecutionException e) {
                if (logger.isWarnEnabled()) {
                    void var2_2;
                    void var1_1;
                    logger.warn("Can't invoke handlerAdded() as the EventExecutor {} rejected it, removing handler {}.", new Object[]{var1_1, this.ctx.name(), var2_2});
                }
                DefaultChannelPipeline.access$800(DefaultChannelPipeline.this, this.ctx);
                this.ctx.setRemoved();
                return;
            }
        }
    }

    private static abstract class PendingHandlerCallback
    implements Runnable {
        final AbstractChannelHandlerContext ctx;
        PendingHandlerCallback next;

        /*
         * WARNING - void declaration
         */
        PendingHandlerCallback(AbstractChannelHandlerContext ctx) {
            void var1_1;
            this.ctx = var1_1;
        }

        abstract void execute();
    }

    final class HeadContext
    extends AbstractChannelHandlerContext
    implements ChannelInboundHandler,
    ChannelOutboundHandler {
        private final Channel.Unsafe unsafe;
        final /* synthetic */ DefaultChannelPipeline this$0;

        /*
         * WARNING - void declaration
         */
        HeadContext(DefaultChannelPipeline this$0, DefaultChannelPipeline pipeline) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super(pipeline, null, HEAD_NAME, HeadContext.class);
            this.unsafe = var2_2.channel().unsafe();
            this.setAddComplete();
        }

        @Override
        public final ChannelHandler handler() {
            return this;
        }

        @Override
        public final void handlerAdded(ChannelHandlerContext ctx) {
        }

        @Override
        public final void handlerRemoved(ChannelHandlerContext ctx) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
            void var3_3;
            void var2_2;
            this.unsafe.bind((SocketAddress)var2_2, (ChannelPromise)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            void var3_3;
            void var2_2;
            this.unsafe.connect((SocketAddress)var2_2, (SocketAddress)var3_3, promise);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
            void var2_2;
            this.unsafe.disconnect((ChannelPromise)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void close(ChannelHandlerContext ctx, ChannelPromise promise) {
            void var2_2;
            this.unsafe.close((ChannelPromise)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
            void var2_2;
            this.unsafe.deregister((ChannelPromise)var2_2);
        }

        @Override
        public final void read(ChannelHandlerContext ctx) {
            this.unsafe.beginRead();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            void var3_3;
            void var2_2;
            this.unsafe.write(var2_2, (ChannelPromise)var3_3);
        }

        @Override
        public final void flush(ChannelHandlerContext ctx) {
            this.unsafe.flush();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            void var2_2;
            ctx.fireExceptionCaught((Throwable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void channelRegistered(ChannelHandlerContext ctx) {
            void var1_1;
            this.this$0.invokeHandlerAddedIfNeeded();
            var1_1.fireChannelRegistered();
        }

        @Override
        public final void channelUnregistered(ChannelHandlerContext ctx) {
            ctx.fireChannelUnregistered();
            if (!this.this$0.channel.isOpen()) {
                this.this$0.destroy();
            }
        }

        @Override
        public final void channelActive(ChannelHandlerContext ctx) {
            ctx.fireChannelActive();
            this.readIfIsAutoRead();
        }

        @Override
        public final void channelInactive(ChannelHandlerContext ctx) {
            ctx.fireChannelInactive();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void channelRead(ChannelHandlerContext ctx, Object msg) {
            void var2_2;
            ctx.fireChannelRead(var2_2);
        }

        @Override
        public final void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.fireChannelReadComplete();
            this.readIfIsAutoRead();
        }

        private void readIfIsAutoRead() {
            if (this.this$0.channel.config().isAutoRead()) {
                this.this$0.channel.read();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            void var2_2;
            ctx.fireUserEventTriggered(var2_2);
        }

        @Override
        public final void channelWritabilityChanged(ChannelHandlerContext ctx) {
            ctx.fireChannelWritabilityChanged();
        }
    }

    final class TailContext
    extends AbstractChannelHandlerContext
    implements ChannelInboundHandler {
        final /* synthetic */ DefaultChannelPipeline this$0;

        /*
         * WARNING - void declaration
         */
        TailContext(DefaultChannelPipeline this$0, DefaultChannelPipeline pipeline) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((DefaultChannelPipeline)var2_2, null, TAIL_NAME, TailContext.class);
            this.setAddComplete();
        }

        @Override
        public final ChannelHandler handler() {
            return this;
        }

        @Override
        public final void channelRegistered(ChannelHandlerContext ctx) {
        }

        @Override
        public final void channelUnregistered(ChannelHandlerContext ctx) {
        }

        @Override
        public final void channelActive(ChannelHandlerContext ctx) {
            this.this$0.onUnhandledInboundChannelActive();
        }

        @Override
        public final void channelInactive(ChannelHandlerContext ctx) {
            this.this$0.onUnhandledInboundChannelInactive();
        }

        @Override
        public final void channelWritabilityChanged(ChannelHandlerContext ctx) {
            this.this$0.onUnhandledChannelWritabilityChanged();
        }

        @Override
        public final void handlerAdded(ChannelHandlerContext ctx) {
        }

        @Override
        public final void handlerRemoved(ChannelHandlerContext ctx) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            void var2_2;
            this.this$0.onUnhandledInboundUserEventTriggered(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            void var2_2;
            this.this$0.onUnhandledInboundException((Throwable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void channelRead(ChannelHandlerContext ctx, Object msg) {
            void var2_2;
            void var1_1;
            this.this$0.onUnhandledInboundMessage((ChannelHandlerContext)var1_1, var2_2);
        }

        @Override
        public final void channelReadComplete(ChannelHandlerContext ctx) {
            this.this$0.onUnhandledInboundChannelReadComplete();
        }
    }

    private static enum AddStrategy {
        ADD_FIRST,
        ADD_LAST,
        ADD_BEFORE,
        ADD_AFTER;

    }
}

