/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelId;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.MacAddressUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultChannelId
implements ChannelId {
    private static final long serialVersionUID = 3884076183504074063L;
    private static final InternalLogger logger;
    private static final byte[] MACHINE_ID;
    private static final int PROCESS_ID_LEN = 4;
    private static final int PROCESS_ID;
    private static final int SEQUENCE_LEN = 4;
    private static final int TIMESTAMP_LEN = 8;
    private static final int RANDOM_LEN = 4;
    private static final AtomicInteger nextSequence;
    private final byte[] data;
    private final int hashCode;
    private transient String shortValue;
    private transient String longValue;

    public static DefaultChannelId newInstance() {
        return new DefaultChannelId(MACHINE_ID, PROCESS_ID, nextSequence.getAndIncrement(), Long.reverse(System.nanoTime()) ^ System.currentTimeMillis(), PlatformDependent.threadLocalRandom().nextInt());
    }

    static int processHandlePid(ClassLoader loader) {
        if (PlatformDependent.javaVersion() >= 9) {
            Long l;
            Long pid;
            try {
                Long processHandleImplType = Class.forName("java.lang.ProcessHandle", true, loader);
                Method method = ((Class)((Object)processHandleImplType)).getMethod("current", new Class[0]);
                Object processHandleInstance = method.invoke(null, new Object[0]);
                processHandleImplType = ((Class)((Object)processHandleImplType)).getMethod("pid", new Class[0]);
                pid = (Long)((Method)((Object)processHandleImplType)).invoke(method, new Object[0]);
            }
            catch (Exception e) {
                logger.debug("Could not invoke ProcessHandle.current().pid();", (Throwable)e);
                return -1;
            }
            if (pid > Integer.MAX_VALUE || pid < Integer.MIN_VALUE) {
                throw new IllegalStateException("Current process ID exceeds int range: " + pid);
            }
            return l.intValue();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    static int jmxPid(ClassLoader loader) {
        void var3_6;
        int pid;
        Object value;
        Method method;
        Class<?> runtimeMxBeanType;
        try {
            GenericDeclaration mgmtFactoryType = Class.forName("java.lang.management.ManagementFactory", true, loader);
            runtimeMxBeanType = Class.forName("java.lang.management.RuntimeMXBean", true, loader);
            method = mgmtFactoryType.getMethod("getRuntimeMXBean", EmptyArrays.EMPTY_CLASSES);
            Object bean = method.invoke(null, EmptyArrays.EMPTY_OBJECTS);
            mgmtFactoryType = runtimeMxBeanType.getMethod("getName", EmptyArrays.EMPTY_CLASSES);
            value = (String)((Method)mgmtFactoryType).invoke(bean, EmptyArrays.EMPTY_OBJECTS);
        }
        catch (Throwable t) {
            logger.debug("Could not invoke ManagementFactory.getRuntimeMXBean().getName(); Android?", t);
            try {
                ClassLoader classLoader;
                runtimeMxBeanType = Class.forName("android.os.Process", true, classLoader);
                value = runtimeMxBeanType.getMethod("myPid", EmptyArrays.EMPTY_CLASSES);
                value = ((Method)value).invoke(null, EmptyArrays.EMPTY_OBJECTS).toString();
            }
            catch (Throwable t2) {
                logger.debug("Could not invoke Process.myPid(); not Android?", t2);
                value = "";
            }
        }
        int atIndex = ((String)value).indexOf(64);
        if (atIndex >= 0) {
            void var2_3;
            value = ((String)value).substring(0, (int)var2_3);
        }
        try {
            pid = Integer.parseInt((String)value);
        }
        catch (NumberFormatException numberFormatException) {
            pid = -1;
        }
        if (pid < 0) {
            pid = PlatformDependent.threadLocalRandom().nextInt();
            logger.warn("Failed to find the current process ID from '{}'; using a random value: {}", (Object)method, (Object)pid);
        }
        return (int)var3_6;
    }

    /*
     * WARNING - void declaration
     */
    static int defaultProcessId() {
        void var0;
        ClassLoader loader = PlatformDependent.getClassLoader(DefaultChannelId.class);
        int processId = DefaultChannelId.processHandlePid(loader);
        if (processId != -1) {
            void var1_1;
            return (int)var1_1;
        }
        return DefaultChannelId.jmxPid((ClassLoader)var0);
    }

    /*
     * WARNING - void declaration
     */
    DefaultChannelId(byte[] machineId, int processId, int sequence, long timestamp, int random) {
        void var1_2;
        void var3_4;
        void var2_3;
        byte[] data = new byte[machineId.length + 4 + 4 + 8 + 4];
        System.arraycopy(machineId, 0, data, 0, machineId.length);
        int i = 0 + machineId.length;
        DefaultChannelId.writeInt(data, i, (int)var2_3);
        DefaultChannelId.writeInt(data, i += 4, (int)var3_4);
        DefaultChannelId.writeLong(data, i += 4, timestamp);
        DefaultChannelId.writeInt(data, i += 8, random);
        i += 4;
        assert (var1_2 == data.length);
        this.data = data;
        this.hashCode = Arrays.hashCode(data);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeInt(byte[] data, int i, int value) {
        void var2_2;
        if (PlatformDependent.isUnaligned()) {
            PlatformDependent.putInt((byte[])data, (int)i, (int)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value : Integer.reverseBytes(value)));
            return;
        }
        data[i] = (byte)(value >>> 24);
        data[i + 1] = (byte)(value >>> 16);
        data[i + 2] = (byte)(value >>> 8);
        var0[var1_1 + 3] = (byte)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static void writeLong(byte[] data, int i, long value) {
        void var2_2;
        if (PlatformDependent.isUnaligned()) {
            PlatformDependent.putLong((byte[])data, (int)i, (long)(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? value : Long.reverseBytes(value)));
            return;
        }
        data[i] = (byte)(value >>> 56);
        data[i + 1] = (byte)(value >>> 48);
        data[i + 2] = (byte)(value >>> 40);
        data[i + 3] = (byte)(value >>> 32);
        data[i + 4] = (byte)(value >>> 24);
        data[i + 5] = (byte)(value >>> 16);
        data[i + 6] = (byte)(value >>> 8);
        var0[var1_1 + 7] = (byte)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String asShortText() {
        void var1_1;
        String shortValue = this.shortValue;
        if (shortValue == null) {
            this.shortValue = shortValue = ByteBufUtil.hexDump((byte[])this.data, (int)(this.data.length - 4), (int)4);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String asLongText() {
        void var1_1;
        String longValue = this.longValue;
        if (longValue == null) {
            this.longValue = longValue = this.newLongValue();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String newLongValue() {
        void var1_1;
        void var2_2;
        StringBuilder buf = new StringBuilder(2 * this.data.length + 5);
        int machineIdLen = this.data.length - 4 - 4 - 8 - 4;
        int i = this.appendHexDumpField(buf, 0, machineIdLen);
        i = this.appendHexDumpField(buf, i, 4);
        i = this.appendHexDumpField(buf, i, 4);
        i = this.appendHexDumpField(buf, i, 8);
        i = this.appendHexDumpField(buf, i, 4);
        assert (var2_2 == this.data.length);
        return buf.substring(0, var1_1.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private int appendHexDumpField(StringBuilder buf, int i, int length) {
        void var3_3;
        void var1_1;
        buf.append(ByteBufUtil.hexDump((byte[])this.data, (int)i, (int)length));
        var1_1.append('-');
        return (int)(var2_2 += var3_3);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(ChannelId o) {
        void var1_1;
        if (this == o) {
            return 0;
        }
        if (o instanceof DefaultChannelId) {
            void var3_3;
            void var2_2;
            byte[] otherData = ((DefaultChannelId)o).data;
            int len1 = this.data.length;
            int len2 = otherData.length;
            int len = Math.min(len1, len2);
            for (int k = 0; k < len; ++k) {
                byte x = this.data[k];
                byte y = otherData[k];
                if (x == y) continue;
                return (x & 0xFF) - (y & 0xFF);
            }
            return (int)(var2_2 - var3_3);
        }
        return this.asLongText().compareTo(var1_1.asLongText());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultChannelId)) {
            return false;
        }
        DefaultChannelId other = (DefaultChannelId)obj;
        return this.hashCode == other.hashCode && Arrays.equals(this.data, var1_1.data);
    }

    public final String toString() {
        return this.asShortText();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0_1;
        logger = InternalLoggerFactory.getInstance(DefaultChannelId.class);
        nextSequence = new AtomicInteger();
        int processId = -1;
        String customProcessId = SystemPropertyUtil.get((String)"io.netty.processId");
        if (customProcessId != null) {
            try {
                processId = Integer.parseInt(customProcessId);
            }
            catch (NumberFormatException numberFormatException) {}
            if (processId < 0) {
                processId = -1;
                logger.warn("-Dio.netty.processId: {} (malformed)", (Object)customProcessId);
            } else if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (user-set)", (Object)processId);
            }
        }
        if (processId < 0) {
            processId = DefaultChannelId.defaultProcessId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (auto-detected)", (Object)processId);
            }
        }
        PROCESS_ID = processId;
        byte[] machineId = null;
        String customMachineId = SystemPropertyUtil.get((String)"io.netty.machineId");
        if (customMachineId != null) {
            try {
                machineId = MacAddressUtil.parseMAC((String)customMachineId);
            }
            catch (Exception e) {
                void var2_3;
                logger.warn("-Dio.netty.machineId: {} (malformed)", (Object)customMachineId, (Object)var2_3);
            }
            if (machineId != null) {
                void var1_2;
                logger.debug("-Dio.netty.machineId: {} (user-set)", (Object)var1_2);
            }
        }
        if (machineId == null) {
            machineId = MacAddressUtil.defaultMachineId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.machineId: {} (auto-detected)", (Object)MacAddressUtil.formatAddress((byte[])machineId));
            }
        }
        MACHINE_ID = var0_1;
    }
}

