/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultMessageSizeEstimator;
import io.netty.channel.MaxMessagesRecvByteBufAllocator;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.util.internal.ObjectUtil;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultChannelConfig
implements ChannelConfig {
    private static final MessageSizeEstimator DEFAULT_MSG_SIZE_ESTIMATOR = DefaultMessageSizeEstimator.DEFAULT;
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final AtomicIntegerFieldUpdater<DefaultChannelConfig> AUTOREAD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DefaultChannelConfig.class, "autoRead");
    private static final AtomicReferenceFieldUpdater<DefaultChannelConfig, WriteBufferWaterMark> WATERMARK_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelConfig.class, WriteBufferWaterMark.class, "writeBufferWaterMark");
    protected final Channel channel;
    private volatile ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
    private volatile RecvByteBufAllocator rcvBufAllocator;
    private volatile MessageSizeEstimator msgSizeEstimator = DEFAULT_MSG_SIZE_ESTIMATOR;
    private volatile int connectTimeoutMillis = 30000;
    private volatile int writeSpinCount = 16;
    private volatile int maxMessagesPerWrite = Integer.MAX_VALUE;
    private volatile int autoRead = 1;
    private volatile boolean autoClose = true;
    private volatile WriteBufferWaterMark writeBufferWaterMark = WriteBufferWaterMark.DEFAULT;
    private volatile boolean pinEventExecutor = true;

    /*
     * WARNING - void declaration
     */
    public DefaultChannelConfig(Channel channel) {
        this((Channel)var1_1, new AdaptiveRecvByteBufAllocator());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected DefaultChannelConfig(Channel channel, RecvByteBufAllocator allocator) {
        void var1_1;
        void var2_2;
        this.setRecvByteBufAllocator((RecvByteBufAllocator)var2_2, channel.metadata());
        this.channel = var1_1;
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(null, ChannelOption.CONNECT_TIMEOUT_MILLIS, ChannelOption.MAX_MESSAGES_PER_READ, ChannelOption.WRITE_SPIN_COUNT, ChannelOption.ALLOCATOR, ChannelOption.AUTO_READ, ChannelOption.AUTO_CLOSE, ChannelOption.RCVBUF_ALLOCATOR, ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, ChannelOption.WRITE_BUFFER_WATER_MARK, ChannelOption.MESSAGE_SIZE_ESTIMATOR, ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP, ChannelOption.MAX_MESSAGES_PER_WRITE);
    }

    /*
     * WARNING - void declaration
     */
    protected Map<ChannelOption<?>, Object> getOptions(Map<ChannelOption<?>, Object> result, ChannelOption<?> ... options) {
        void var1_1;
        void var2_2;
        if (result == null) {
            result = new IdentityHashMap();
        }
        for (void o : var2_2) {
            result.put((ChannelOption<?>)o, this.getOption((ChannelOption)o));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setOptions(Map<ChannelOption<?>, ?> options) {
        void var2_2;
        Iterator iterator;
        ObjectUtil.checkNotNull(options, (String)"options");
        boolean setAllOptions = true;
        for (Map.Entry e : iterator.entrySet()) {
            void var3_3;
            if (this.setOption((ChannelOption)((Object)e.getKey()), var3_3.getValue())) continue;
            setAllOptions = false;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getOption(ChannelOption<T> option) {
        void var1_1;
        ObjectUtil.checkNotNull(option, (String)"option");
        if (option == ChannelOption.CONNECT_TIMEOUT_MILLIS) {
            return (T)Integer.valueOf(this.getConnectTimeoutMillis());
        }
        if (option == ChannelOption.MAX_MESSAGES_PER_READ) {
            return (T)Integer.valueOf(this.getMaxMessagesPerRead());
        }
        if (option == ChannelOption.WRITE_SPIN_COUNT) {
            return (T)Integer.valueOf(this.getWriteSpinCount());
        }
        if (option == ChannelOption.ALLOCATOR) {
            return (T)this.getAllocator();
        }
        if (option == ChannelOption.RCVBUF_ALLOCATOR) {
            return this.getRecvByteBufAllocator();
        }
        if (option == ChannelOption.AUTO_READ) {
            return (T)Boolean.valueOf(this.isAutoRead());
        }
        if (option == ChannelOption.AUTO_CLOSE) {
            return (T)Boolean.valueOf(this.isAutoClose());
        }
        if (option == ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK) {
            return (T)Integer.valueOf(this.getWriteBufferHighWaterMark());
        }
        if (option == ChannelOption.WRITE_BUFFER_LOW_WATER_MARK) {
            return (T)Integer.valueOf(this.getWriteBufferLowWaterMark());
        }
        if (option == ChannelOption.WRITE_BUFFER_WATER_MARK) {
            return (T)this.getWriteBufferWaterMark();
        }
        if (option == ChannelOption.MESSAGE_SIZE_ESTIMATOR) {
            return (T)this.getMessageSizeEstimator();
        }
        if (option == ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP) {
            return (T)Boolean.valueOf(this.getPinEventExecutorPerGroup());
        }
        if (var1_1 == ChannelOption.MAX_MESSAGES_PER_WRITE) {
            return (T)Integer.valueOf(this.getMaxMessagesPerWrite());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        void var1_1;
        this.validate(option, value);
        if (option == ChannelOption.CONNECT_TIMEOUT_MILLIS) {
            this.setConnectTimeoutMillis((Integer)value);
        } else if (option == ChannelOption.MAX_MESSAGES_PER_READ) {
            this.setMaxMessagesPerRead((Integer)value);
        } else if (option == ChannelOption.WRITE_SPIN_COUNT) {
            this.setWriteSpinCount((Integer)value);
        } else if (option == ChannelOption.ALLOCATOR) {
            this.setAllocator((ByteBufAllocator)value);
        } else if (option == ChannelOption.RCVBUF_ALLOCATOR) {
            this.setRecvByteBufAllocator((RecvByteBufAllocator)value);
        } else if (option == ChannelOption.AUTO_READ) {
            this.setAutoRead((Boolean)value);
        } else if (option == ChannelOption.AUTO_CLOSE) {
            this.setAutoClose((Boolean)value);
        } else if (option == ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK) {
            this.setWriteBufferHighWaterMark((Integer)value);
        } else if (option == ChannelOption.WRITE_BUFFER_LOW_WATER_MARK) {
            this.setWriteBufferLowWaterMark((Integer)value);
        } else if (option == ChannelOption.WRITE_BUFFER_WATER_MARK) {
            this.setWriteBufferWaterMark((WriteBufferWaterMark)value);
        } else if (option == ChannelOption.MESSAGE_SIZE_ESTIMATOR) {
            this.setMessageSizeEstimator((MessageSizeEstimator)value);
        } else if (option == ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP) {
            this.setPinEventExecutorPerGroup((Boolean)value);
        } else if (var1_1 == ChannelOption.MAX_MESSAGES_PER_WRITE) {
            void var2_2;
            this.setMaxMessagesPerWrite((Integer)var2_2);
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected <T> void validate(ChannelOption<T> option, T value) {
        void var2_2;
        ((ChannelOption)((Object)ObjectUtil.checkNotNull(option, (String)"option"))).validate(var2_2);
    }

    @Override
    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)connectTimeoutMillis, (String)"connectTimeoutMillis");
        this.connectTimeoutMillis = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public int getMaxMessagesPerRead() {
        try {
            MaxMessagesRecvByteBufAllocator maxMessagesRecvByteBufAllocator = (MaxMessagesRecvByteBufAllocator)this.getRecvByteBufAllocator();
            return maxMessagesRecvByteBufAllocator.maxMessagesPerRead();
        }
        catch (ClassCastException e) {
            void var1_2;
            throw new IllegalStateException("getRecvByteBufAllocator() must return an object of type MaxMessagesRecvByteBufAllocator", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public ChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        try {
            void var1_1;
            MaxMessagesRecvByteBufAllocator maxMessagesRecvByteBufAllocator = (MaxMessagesRecvByteBufAllocator)this.getRecvByteBufAllocator();
            maxMessagesRecvByteBufAllocator.maxMessagesPerRead((int)var1_1);
            return this;
        }
        catch (ClassCastException e) {
            void var2_3;
            throw new IllegalStateException("getRecvByteBufAllocator() must return an object of type MaxMessagesRecvByteBufAllocator", (Throwable)var2_3);
        }
    }

    public int getMaxMessagesPerWrite() {
        return this.maxMessagesPerWrite;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelConfig setMaxMessagesPerWrite(int maxMessagesPerWrite) {
        void var1_1;
        this.maxMessagesPerWrite = ObjectUtil.checkPositive((int)var1_1, (String)"maxMessagesPerWrite");
        return this;
    }

    @Override
    public int getWriteSpinCount() {
        return this.writeSpinCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelConfig setWriteSpinCount(int writeSpinCount) {
        void var1_1;
        ObjectUtil.checkPositive((int)writeSpinCount, (String)"writeSpinCount");
        if (writeSpinCount == Integer.MAX_VALUE) {
            --writeSpinCount;
        }
        this.writeSpinCount = var1_1;
        return this;
    }

    @Override
    public ByteBufAllocator getAllocator() {
        return this.allocator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelConfig setAllocator(ByteBufAllocator allocator) {
        void var1_1;
        this.allocator = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)var1_1, (String)"allocator");
        return this;
    }

    @Override
    public <T extends RecvByteBufAllocator> T getRecvByteBufAllocator() {
        return (T)this.rcvBufAllocator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        void var1_1;
        this.rcvBufAllocator = (RecvByteBufAllocator)ObjectUtil.checkNotNull((Object)var1_1, (String)"allocator");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void setRecvByteBufAllocator(RecvByteBufAllocator allocator, ChannelMetadata metadata) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)allocator, (String)"allocator");
        ObjectUtil.checkNotNull((Object)metadata, (String)"metadata");
        if (allocator instanceof MaxMessagesRecvByteBufAllocator) {
            void var2_2;
            ((MaxMessagesRecvByteBufAllocator)allocator).maxMessagesPerRead(var2_2.defaultMaxMessagesPerRead());
        }
        this.setRecvByteBufAllocator((RecvByteBufAllocator)var1_1);
    }

    @Override
    public boolean isAutoRead() {
        return this.autoRead == 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelConfig setAutoRead(boolean autoRead) {
        void var2_2;
        void var1_1;
        boolean oldAutoRead;
        boolean bl = oldAutoRead = AUTOREAD_UPDATER.getAndSet(this, autoRead ? 1 : 0) == 1;
        if (autoRead && !oldAutoRead) {
            this.channel.read();
        } else if (var1_1 == false && var2_2 != false) {
            this.autoReadCleared();
        }
        return this;
    }

    protected void autoReadCleared() {
    }

    @Override
    public boolean isAutoClose() {
        return this.autoClose;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelConfig setAutoClose(boolean autoClose) {
        void var1_1;
        this.autoClose = var1_1;
        return this;
    }

    @Override
    public int getWriteBufferHighWaterMark() {
        return this.writeBufferWaterMark.high();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        void var2_2;
        WriteBufferWaterMark waterMark;
        ObjectUtil.checkPositiveOrZero((int)writeBufferHighWaterMark, (String)"writeBufferHighWaterMark");
        do {
            if (writeBufferHighWaterMark >= (waterMark = this.writeBufferWaterMark).low()) continue;
            throw new IllegalArgumentException("writeBufferHighWaterMark cannot be less than writeBufferLowWaterMark (" + waterMark.low() + "): " + writeBufferHighWaterMark);
        } while (!WATERMARK_UPDATER.compareAndSet(this, waterMark, new WriteBufferWaterMark(var2_2.low(), writeBufferHighWaterMark, false)));
        return this;
    }

    @Override
    public int getWriteBufferLowWaterMark() {
        return this.writeBufferWaterMark.low();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        void var2_2;
        WriteBufferWaterMark waterMark;
        ObjectUtil.checkPositiveOrZero((int)writeBufferLowWaterMark, (String)"writeBufferLowWaterMark");
        do {
            if (writeBufferLowWaterMark <= (waterMark = this.writeBufferWaterMark).high()) continue;
            throw new IllegalArgumentException("writeBufferLowWaterMark cannot be greater than writeBufferHighWaterMark (" + waterMark.high() + "): " + writeBufferLowWaterMark);
        } while (!WATERMARK_UPDATER.compareAndSet(this, waterMark, new WriteBufferWaterMark(writeBufferLowWaterMark, var2_2.high(), false)));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        void var1_1;
        this.writeBufferWaterMark = (WriteBufferWaterMark)ObjectUtil.checkNotNull((Object)var1_1, (String)"writeBufferWaterMark");
        return this;
    }

    @Override
    public WriteBufferWaterMark getWriteBufferWaterMark() {
        return this.writeBufferWaterMark;
    }

    @Override
    public MessageSizeEstimator getMessageSizeEstimator() {
        return this.msgSizeEstimator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        void var1_1;
        this.msgSizeEstimator = (MessageSizeEstimator)ObjectUtil.checkNotNull((Object)var1_1, (String)"estimator");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private ChannelConfig setPinEventExecutorPerGroup(boolean pinEventExecutor) {
        void var1_1;
        this.pinEventExecutor = var1_1;
        return this;
    }

    private boolean getPinEventExecutorPerGroup() {
        return this.pinEventExecutor;
    }
}

