/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.AddressedEnvelope;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;

public class DefaultAddressedEnvelope<M, A extends SocketAddress>
implements AddressedEnvelope<M, A> {
    private final M message;
    private final A sender;
    private final A recipient;

    /*
     * WARNING - void declaration
     */
    public DefaultAddressedEnvelope(M message, A recipient, A sender) {
        void var2_2;
        void var3_3;
        void var1_1;
        ObjectUtil.checkNotNull(message, (String)"message");
        if (recipient == null && sender == null) {
            throw new NullPointerException("recipient and sender");
        }
        this.message = var1_1;
        this.sender = var3_3;
        this.recipient = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultAddressedEnvelope(M message, A recipient) {
        this(var1_1, var2_2, null);
        void var2_2;
        void var1_1;
    }

    @Override
    public M content() {
        return this.message;
    }

    @Override
    public A sender() {
        return this.sender;
    }

    @Override
    public A recipient() {
        return this.recipient;
    }

    public int refCnt() {
        if (this.message instanceof ReferenceCounted) {
            return ((ReferenceCounted)this.message).refCnt();
        }
        return 1;
    }

    @Override
    public AddressedEnvelope<M, A> retain() {
        ReferenceCountUtil.retain(this.message);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AddressedEnvelope<M, A> retain(int increment) {
        void var1_1;
        ReferenceCountUtil.retain(this.message, (int)var1_1);
        return this;
    }

    public boolean release() {
        return ReferenceCountUtil.release(this.message);
    }

    /*
     * WARNING - void declaration
     */
    public boolean release(int decrement) {
        void var1_1;
        return ReferenceCountUtil.release(this.message, (int)var1_1);
    }

    @Override
    public AddressedEnvelope<M, A> touch() {
        ReferenceCountUtil.touch(this.message);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AddressedEnvelope<M, A> touch(Object hint) {
        void var1_1;
        ReferenceCountUtil.touch(this.message, (Object)var1_1);
        return this;
    }

    public String toString() {
        if (this.sender != null) {
            return StringUtil.simpleClassName((Object)this) + '(' + this.sender + " => " + this.recipient + ", " + this.message + ')';
        }
        return StringUtil.simpleClassName((Object)this) + "(=> " + this.recipient + ", " + this.message + ')';
    }
}

